/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.http.fetcher;

import com.ibm.es.nuvo.crawler.util.hash.HashableDataBufferOutputStream;
import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.AgentConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.error.ArgCheck;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.http.DownloadFailedException;
import com.ibm.es.nuvo.crawler.web.http.FetchIncompleteLineException;
import com.ibm.es.nuvo.crawler.web.http.HTTPCategory;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.net.ReusableSocket;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class RestartableFetcher {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + RestartableFetcher.class.getName());
    private static final String HTTP_VERSION = "HTTP/1.1";
    protected static final String CRLF = "\r\n";
    protected static final String HTTP_HEADER_CHARSET = "ISO-8859-1";
    protected boolean doFetch = true;
    protected String replaceHttpRequest;
    private HashableDataBufferOutputStream binaryContent;
    private byte[] binaryHeader;
    private byte[] chunkHeader = new byte[128];
    protected String additionalRequest;
    protected CURL currentURL;
    protected boolean closeConnection = true;
    protected boolean contentTruncated;
    protected long expirationTime;
    protected boolean proxied;
    protected Properties headerProperties = new Properties();
    protected short returnCode = (short)-1;
    protected int pageSizeLimit;
    private int connectionTimeout;
    private int maxReconnect;
    private int contentLength;
    private boolean compressed;
    private boolean rangeEnabled;
    private boolean chunked;
    private AgentConfig config;
    private String requestHeader;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fetch(ReusableSocket socket, CURL url, CrawlSpaceConfig conf) throws IOException, WCException {
        block13: {
            String value2222;
            block14: {
                if (!this.doFetch) return;
                this.currentURL = url;
                this.config = conf.getAgent();
                this.pageSizeLimit = url.isRobots() ? CrawlerConfig.getInstance().getRobotConfig().getMaxPageSize() : conf.getMaxPageLength();
                try {
                    try {
                        this.download(socket.getSocket(), conf);
                        socket.setCount(this.maxReconnect);
                        socket.setTimeout(this.connectionTimeout);
                    }
                    catch (IOException e) {
                        if (this.binaryContent != null) {
                            this.binaryContent.dispose();
                        }
                        socket.setValid(false);
                        throw e;
                    }
                    catch (WCException e) {
                        if (this.binaryContent != null) {
                            this.binaryContent.dispose();
                        }
                        socket.setValid(false);
                        throw e;
                    }
                    Object var6_4 = null;
                    if (this.headerProperties == null) break block13;
                    value2222 = this.headerProperties.getProperty("proxy-authenticate");
                    if (this.additionalRequest != null && this.additionalRequest.indexOf("Proxy-Authorization:") < 0 || value2222 == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (this.headerProperties != null) {
                        String value2222 = this.headerProperties.getProperty("proxy-authenticate");
                        if ((this.additionalRequest == null || this.additionalRequest.indexOf("Proxy-Authorization:") >= 0) && value2222 != null && logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, "C4935W.PROXY_NEED_PASSWORD", new Object[]{socket.getSocket().getInetAddress(), socket.getSocket().getPort(), value2222});
                        }
                        value2222 = this.headerProperties.getProperty("www-authenticate");
                        if ((this.additionalRequest == null || this.additionalRequest.indexOf("Authorization:") >= 0) && value2222 != null) {
                            tracer.log(Level.FINE, "Valid user ID and password should be specified to crawl URL " + url + ". Detail " + value2222);
                        }
                    }
                    socket.update();
                    if (!this.contentTruncated) throw throwable;
                    socket.setValid(false);
                    throw throwable;
                }
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "C4935W.PROXY_NEED_PASSWORD", new Object[]{socket.getSocket().getInetAddress(), socket.getSocket().getPort(), value2222});
                }
            }
            value2222 = this.headerProperties.getProperty("www-authenticate");
            if ((this.additionalRequest == null || this.additionalRequest.indexOf("Authorization:") >= 0) && value2222 != null) {
                tracer.log(Level.FINE, "Valid user ID and password should be specified to crawl URL " + url + ". Detail " + value2222);
            }
        }
        socket.update();
        if (!this.contentTruncated) return;
        socket.setValid(false);
    }

    /*
     * Exception decompiling
     */
    protected void download(Socket socket, CrawlSpaceConfig conf) throws IOException, WCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getNextLength(InputStream is) throws IOException {
        int length = 0;
        if (this.chunked) {
            int i;
            int chunkOffset = 0;
            while ((i = is.read()) >= 0) {
                if (chunkOffset >= this.chunkHeader.length) {
                    throw new IOException("Invalid chunk " + new String(this.chunkHeader));
                }
                this.chunkHeader[chunkOffset++] = (byte)i;
                if (chunkOffset < 3 || this.chunkHeader[chunkOffset - 2] != 13 || this.chunkHeader[chunkOffset - 1] != 10) continue;
                String sizeString = new String(this.chunkHeader, 0, chunkOffset - 2).trim();
                if (tracer.isLoggable(Level.FINEST)) {
                    tracer.finest("Chunk " + sizeString);
                }
                length = sizeString.length() > 0 ? Integer.parseInt(sizeString, 16) : 0;
                break;
            }
        } else {
            length = this.contentLength;
        }
        return length;
    }

    private byte[] readHeader(InputStream in) throws IOException, WCException {
        byte[] header = null;
        header = RestartableFetcher.getHeader(in);
        this.parseHeader(header);
        return header;
    }

    public static byte[] getHeader(InputStream in) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        int i = 0;
        int c = 0;
        int l = 0;
        boolean started = false;
        while (true) {
            int last = i;
            i = in.read();
            if (i < 0) break;
            ++l;
            if (!started) {
                if (i == 32) continue;
                started = true;
            }
            c = c % 2 == 0 && i == 13 ? ++c : (c % 2 != 0 && i == 10 ? ++c : 0);
            if (l > 32768) {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "Server return too long response.");
                    if (tracer.isLoggable(Level.FINER)) {
                        tracer.finer("Header dump\n" + new String(os.toByteArray()));
                    }
                }
                throw new IOException("Header too long");
            }
            os.write(i);
            if (last == 10 && i == 10 || c == 4) break;
        }
        byte[] header = os.toByteArray();
        return header;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static short extractHTTPReturnCode(String line) throws WCException {
        ArgCheck.nonWSArg("HTTP status line", line);
        StringTokenizer tokenizer = new StringTokenizer(line, " \t\r\n");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String value = tokenizer.nextToken().trim();
            if (value.length() == 0) throw new DownloadFailedException("Invalid status " + line);
            switch (i) {
                case 0: {
                    if (!value.toLowerCase().startsWith("http")) throw new DownloadFailedException("Invalid status " + line);
                    break;
                }
                case 1: {
                    try {
                        return Short.parseShort(value);
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                }
                default: {
                    throw new DownloadFailedException("Invalid status " + line);
                }
            }
            ++i;
        }
        throw new DownloadFailedException("Invalid status " + line);
    }

    protected void parseHeader(byte[] headerBytes) throws WCException {
        String value;
        block35: {
            int i;
            StringTokenizer tokenizer;
            String header;
            try {
                header = new String(headerBytes, HTTP_HEADER_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                header = new String(headerBytes);
            }
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("Response\n" + header);
            }
            if (!(tokenizer = new StringTokenizer(header, CRLF)).hasMoreTokens()) {
                throw new FetchIncompleteLineException(this.currentURL);
            }
            this.returnCode = RestartableFetcher.extractHTTPReturnCode(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                i = line.indexOf(":");
                if (i < 0) continue;
                String key = line.substring(0, i).trim().toLowerCase();
                String value2 = line.substring(i + 1).trim();
                Object property = this.headerProperties.get(key);
                if (property != null) {
                    String[] array;
                    if (property instanceof String) {
                        array = new String[]{(String)property, value2};
                    } else {
                        String[] ss = (String[])property;
                        array = new String[ss.length + 1];
                        System.arraycopy(ss, 0, array, 0, ss.length);
                        array[array.length - 1] = value2;
                    }
                    this.headerProperties.put(key.toLowerCase(), array);
                    continue;
                }
                this.headerProperties.setProperty(key.toLowerCase(), value2);
            }
            value = this.headerProperties.getProperty("connection");
            if (value == null) {
                value = this.headerProperties.getProperty("proxy-connection");
            }
            this.maxReconnect = 0;
            this.connectionTimeout = 10;
            if ("close".equalsIgnoreCase(value)) {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.fine("closed for " + this.currentURL);
                }
            } else if ("Keep-Alive".equalsIgnoreCase(value)) {
                value = this.headerProperties.getProperty("keep-alive");
                if (value != null) {
                    value = value.toLowerCase();
                    i = 0;
                    i = value.indexOf(44);
                    try {
                        int j;
                        if (i <= 0) break block35;
                        String[] attrs = new String[]{value.substring(0, i).trim(), value.substring(i + 1).trim()};
                        int timeout = 0;
                        int max = 0;
                        for (i = 0; i < 2 && (j = attrs[i].indexOf(61)) >= 0; ++i) {
                            String key = attrs[i].substring(0, j);
                            int num = Integer.parseInt(attrs[i].substring(j + 1));
                            if (key.equals("timeout")) {
                                timeout = num;
                                continue;
                            }
                            if (!key.equals("max")) break;
                            max = num;
                        }
                        if (i == 2) {
                            this.maxReconnect = max;
                            this.connectionTimeout = timeout;
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "C4911W.FAILED_TO_PARSE_HEADER", e);
                    }
                } else {
                    this.maxReconnect = 2;
                }
            }
        }
        this.contentLength = 0;
        this.contentTruncated = false;
        value = this.headerProperties.getProperty("transfer-encoding");
        if ("chunked".equals(value)) {
            this.chunked = true;
        } else {
            int i;
            int j;
            String contentRange;
            value = this.headerProperties.getProperty("content-length");
            if (value != null) {
                try {
                    this.contentLength = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    tracer.log(Level.FINE, "An invalid content length " + value + " was returned from server.");
                }
            }
            value = null;
            if (!this.contentTruncated && HTTPCategory.successful(this.returnCode) && (contentRange = this.headerProperties.getProperty("content-range")) != null && (j = contentRange.indexOf("/", (i = contentRange.indexOf("-")) + 1)) > i && i > 0) {
                value = contentRange.substring(i + 1, j);
                this.rangeEnabled = true;
            }
            if (value != null) {
                try {
                    int len = Integer.parseInt(value);
                    if (this.rangeEnabled) {
                        ++len;
                    }
                    if (this.contentLength == len && this.returnCode == 206) {
                        this.returnCode = (short)200;
                    }
                    this.contentLength = len;
                }
                catch (NumberFormatException e) {
                    tracer.log(Level.FINE, "An invalid content length " + value + " was returned from server.", new Object[]{value});
                }
            }
        }
        value = this.headerProperties.getProperty("content-encoding");
        if (value != null && value.equalsIgnoreCase("gzip")) {
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("gzip " + this.currentURL);
            }
            this.compressed = true;
        } else {
            this.compressed = false;
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Timeout=" + this.connectionTimeout + ", " + "Connection=" + this.maxReconnect + ", " + ", " + "Compressed=" + this.compressed + ", " + "Truncated=" + this.contentTruncated);
        }
    }

    protected void addCommonRequest(String method, StringBuffer request) {
        String language;
        String accept;
        String email;
        request.append(method);
        request.append(" ");
        if (this.proxied) {
            request.append(this.currentURL.toString());
        } else {
            request.append(this.currentURL.getServerLocalPart());
        }
        request.append(" HTTP/1.1\r\n");
        request.append("Host: ").append(this.currentURL.getHostname());
        if (!this.currentURL.isStandaradPort()) {
            request.append(":").append(this.currentURL.getPort());
        }
        request.append(CRLF);
        String name = this.config.getName();
        if (name != null && name.length() > 0) {
            request.append("User-Agent: ").append(name).append(CRLF);
        }
        if ((email = this.config.getEmail()) != null && email.length() > 0) {
            request.append("From: ").append(email).append(CRLF);
        }
        if ((accept = this.config.getAccept()) != null) {
            request.append("Accept: ").append(accept).append(CRLF);
        }
        if ((language = this.config.getLanguage()) == null) {
            request.append("Accept-Language: *\r\n");
        } else {
            request.append("Accept-Language: ").append(language).append(CRLF);
        }
        request.append("Accept-Charset: iso-8859-1, US-ASCII, utf8, *;0.8\r\n");
        request.append("Accept-Encoding: gzip\r\n");
        if (!this.closeConnection) {
            for (int i = 0; i < 2; ++i) {
                if (i == 0) {
                    if (!this.proxied) continue;
                    request.append("Proxy-connection: ");
                } else {
                    request.append("Connection: ");
                }
                request.append("keep-alive\r\n");
            }
            request.append("Keep-Alive: 300\r\n");
        }
        if (this.additionalRequest != null) {
            request.append(this.additionalRequest).append(CRLF);
        }
    }

    protected String getRequest() {
        if (this.replaceHttpRequest != null) {
            return this.replaceHttpRequest;
        }
        StringBuffer sb = new StringBuffer();
        this.addCommonRequest("GET", sb);
        sb.append(CRLF);
        return sb.toString();
    }

    public boolean isTruncated() {
        return this.contentTruncated;
    }

    public void setExpirationTime(int timeoutIntervalSec) {
        this.expirationTime = System.currentTimeMillis() + (long)timeoutIntervalSec * 1000L;
    }

    public void setHTTPProxied(boolean proxied) {
        this.proxied = proxied;
    }

    private void adjustSoTimeout(Socket socket) throws SocketTimeoutException, SocketException {
        long ms = this.expirationTime - System.currentTimeMillis();
        if (ms <= 0L) {
            throw new SocketTimeoutException("Expired");
        }
        socket.setSoTimeout((int)ms);
    }

    public String[] getContentTypeAndEncoding() {
        String[] rv = new String[]{null, null};
        String type = this.headerProperties.getProperty("content-type");
        if (type == null) {
            return rv;
        }
        String propertyValueLC = type.toLowerCase();
        int ixcs = propertyValueLC.indexOf("charset");
        if (ixcs > 0) {
            String ct = propertyValueLC.substring(0, ixcs).trim();
            int ixsc = ct.indexOf(59);
            if (ixsc > 0) {
                ct = ct.substring(0, ixsc).trim();
            }
            rv[0] = ct;
            int ixeq = propertyValueLC.indexOf("=", ixcs + 7);
            if (ixeq < 0) {
                return rv;
            }
            rv[1] = type.substring(ixeq + 1).trim();
        } else {
            rv[0] = propertyValueLC.trim();
        }
        return rv;
    }

    public short getHTTPReturnCode() {
        return this.returnCode;
    }

    public Properties getHTTPHeaderProperties() {
        return this.headerProperties;
    }

    public byte[] getHTTPHeader() {
        byte[] bs = this.binaryHeader;
        if (bs != null) {
            byte[] retCopy = new byte[bs.length];
            System.arraycopy(bs, 0, retCopy, 0, bs.length);
            return retCopy;
        }
        return new byte[0];
    }

    public void addToRequestHeader(String s) {
        while (true) {
            if (s == null || s.length() == 0) {
                return;
            }
            if (!s.endsWith(CRLF)) break;
            s = s.substring(0, s.length() - 2);
        }
        StringBuffer sb = new StringBuffer();
        if (this.additionalRequest != null) {
            sb.append(this.additionalRequest);
            sb.append(CRLF);
        }
        sb.append(s);
        this.additionalRequest = sb.toString();
    }

    public HashableDataBufferOutputStream getContent() {
        return this.binaryContent;
    }

    public CURL getURL() {
        return this.currentURL;
    }

    public String getRequestHeader() {
        return this.requestHeader;
    }
}

