/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.http.fetcher;

import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigChangeListener;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigEventBroaker;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.http.HTTPTrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetcherMonitor {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static FetcherMonitor instance = new FetcherMonitor();
    private Map<String, HistoryManager> buffers = new HashMap<String, HistoryManager>();

    private FetcherMonitor() {
    }

    public static FetcherMonitor instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(String id) {
        Map<String, HistoryManager> map = this.buffers;
        synchronized (map) {
            CrawlSpaceConfig config = CrawlSpaceConfig.forName(id);
            if (config == null) {
                return;
            }
            this.buffers.put(id, new HistoryManager(id, config.getLogURL()));
        }
    }

    public boolean isActive(String id) {
        return this.buffers.containsKey(id);
    }

    public void log(String id, String request, String response) {
        HistoryManager manager = this.buffers.get(id);
        if (manager == null) {
            return;
        }
        manager.put(request, response);
    }

    public List<HTTPTrace> list(String id) {
        HistoryManager manager = this.buffers.get(id);
        if (manager == null) {
            return null;
        }
        return manager.get();
    }

    public void clear(String id) {
        this.buffers.remove(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HistoryManager
    implements ConfigChangeListener {
        private HTTPTrace[] list = new HTTPTrace[0];
        private int count;
        private String id;

        HistoryManager(String id, int size) {
            this.id = id;
            if (size < 0) {
                size = 0;
            }
            this.list = new HTTPTrace[size];
            ConfigEventBroaker.register(id, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(String request, String response) {
            if (request == null && response == null || this.list == null || this.list.length == 0) {
                return;
            }
            HTTPTrace[] hTTPTraceArray = this.list;
            synchronized (this.list) {
                this.list[this.count % this.list.length] = new HTTPTrace(request, response);
                ++this.count;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<HTTPTrace> get() {
            ArrayList<HTTPTrace> ret = new ArrayList<HTTPTrace>();
            HTTPTrace[] hTTPTraceArray = this.list;
            synchronized (this.list) {
                int i;
                int offset = this.count % this.list.length;
                if (this.count > this.list.length) {
                    for (i = offset; i < this.list.length; ++i) {
                        ret.add(this.list[i]);
                    }
                }
                for (i = 0; i < offset; ++i) {
                    ret.add(this.list[i]);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSize(int size) {
            if (this.list.length == size) {
                return;
            }
            if (size < 0) {
                size = 0;
            }
            HTTPTrace[] hTTPTraceArray = this.list;
            synchronized (this.list) {
                List<HTTPTrace> tmpList = this.get();
                this.list = new HTTPTrace[size];
                int s = Math.min(size, tmpList.size());
                int o = Math.max(size - tmpList.size(), 0);
                System.arraycopy(tmpList.toArray(), o, this.list, 0, s);
                this.count = s;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void applyChange() throws WCException {
            CrawlSpaceConfig config = CrawlSpaceConfig.forName(this.id);
            if (config == null) {
                return;
            }
            this.setSize(config.getLogURL());
        }
    }
}

