/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.http;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class HTTPTrace {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String START_SEPARATOR_HEADER = "\r\n------------------------------  ";
    private static final String START_SEPARATOR_TRAILER = "  ------------------------------\r\n";
    private static final String END_SEPARATOR = "\r\n--------------------------------------------------------------------------------\r\n";
    private static final DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS z");
    private String request;
    private String response;
    private long timestamp;

    public HTTPTrace(String request, String response) {
        this.request = request.trim();
        this.response = response.trim();
        this.timestamp = System.currentTimeMillis();
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public Date getTime() {
        return new Date(this.timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(START_SEPARATOR_HEADER);
        DateFormat dateFormat = HTTPTrace.dateFormat;
        synchronized (dateFormat) {
            builder.append(HTTPTrace.dateFormat.format(this.getTime()));
        }
        builder.append(START_SEPARATOR_TRAILER);
        builder.append(this.request);
        builder.append(END_SEPARATOR);
        if (this.response != null) {
            builder.append(this.response);
        }
        return builder.toString();
    }
}

