/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.http;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.util.hash.HashableDataBufferOutputStream;
import com.ibm.es.nuvo.crawler.web.config.FormBaseAuthenticator;
import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.crawler.web.cookie.CookieEntry;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.db.tables.CookieTable;
import com.ibm.es.nuvo.crawler.web.error.EncodingException;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.http.DownloadFailedException;
import com.ibm.es.nuvo.crawler.web.http.FetchIncompleteLineException;
import com.ibm.es.nuvo.crawler.web.http.fetcher.FBAReauthFetcher;
import com.ibm.es.nuvo.crawler.web.http.fetcher.FetcherMonitor;
import com.ibm.es.nuvo.crawler.web.http.fetcher.RestartableFetcher;
import com.ibm.es.nuvo.crawler.web.http.filter.prefetch.BasicAuthFilter;
import com.ibm.es.nuvo.crawler.web.http.filter.prefetch.CookieFilter;
import com.ibm.es.nuvo.crawler.web.http.filter.prefetch.PrefetchFilter;
import com.ibm.es.nuvo.crawler.web.http.filter.prefetch.ProxyBasicAuthFilter;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.net.ReusableSocket;
import com.ibm.es.nuvo.crawler.web.net.ReusableSocketManager;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class Client {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + Client.class.getName());
    private static List<PrefetchFilter> defaultPrefetchFilters = new ArrayList<PrefetchFilter>();
    private static final String[] COOKIES = new String[]{"set-cookie", "set-cookie2"};
    private CrawlRec rec;
    private List<PrefetchFilter> prefetchFilters = new ArrayList<PrefetchFilter>();
    private ReusableSocket m_socket;
    private CURL url;
    private RestartableFetcher fetcher;
    private short forcedHTTPReturnCode;
    private String m_aclString;
    private FormBaseAuthenticator fba;
    private CURL referer;

    public Client(CrawlRec cr) {
        this.rec = cr;
        this.url = cr.getURL();
        for (PrefetchFilter filter : defaultPrefetchFilters) {
            if (!cr.isPersistent() && filter instanceof CookieFilter) continue;
            try {
                this.instAddPrefetchFilter(filter.instance());
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "C4904W.CLIENT_PREFETCH_ERROR", e);
            }
        }
    }

    public void download() throws WCException {
        this.download(new ReentrantLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(Lock lock) throws WCException {
        block37: {
            int retry = 5;
            FetcherMonitor monitor = FetcherMonitor.instance();
            String id = this.rec.getCrawlerId();
            if (this.rec.getConfig() == null || !this.rec.getConfig().isValid()) {
                return;
            }
            try {
                this.rec.setFetching(true);
                while (retry-- > 0) {
                    try {
                        block38: {
                            if (this.rec.getConfig() == null || !this.rec.getConfig().isValid()) break block37;
                            this._connectToServer();
                            if (this.rec.getConfig() == null || !this.rec.getConfig().isValid()) break block37;
                            lock.lock();
                            try {
                                this.callPrefetchFilters();
                                if (this.rec.getConfig() != null && this.rec.getConfig().isValid()) break block38;
                                break;
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                        this.fetcher.fetch(this.m_socket, this.url, this.rec.getConfig());
                        if (this.rec.isPersistent() && this.rec.getConfig().isValid()) {
                            this.saveCookies();
                        }
                        break;
                    }
                    catch (Exception e) {
                        if (e instanceof FetchIncompleteLineException || e instanceof SocketException) {
                            if (this.m_socket != null) {
                                this.m_socket.setValid(false);
                            }
                            Thread.sleep(100L);
                            if (retry == 1) {
                                throw e;
                            }
                            tracer.finer("Retry " + retry + " " + this.url);
                            this.fetcher = null;
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        byte[] response;
                        if (this.fetcher != null && monitor.isActive(id) && (response = this.fetcher.getHTTPHeader()) != null) {
                            try {
                                monitor.log(id, this.fetcher.getRequestHeader(), new String(response, "ISO8859-1"));
                            }
                            catch (UnsupportedEncodingException ignored) {}
                        }
                        ReusableSocketManager.getInstance().returnSocket(this.m_socket);
                    }
                }
            }
            catch (WCException we) {
                Message message = new Message("C4903W.CLIENT_DOWNLOAD_ERROR", this.rec.toString(), this.rec.getConfig().getCollectionId());
                ExtendedException exception = new ExtendedException(message, (Throwable)we);
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, exception);
                }
                throw we;
            }
            catch (Exception e) {
                throw new DownloadFailedException(this.url, e);
            }
            finally {
                this.rec.setFetching(false);
            }
        }
    }

    private void _connectToServer() throws IOException {
        int soTimeout = CrawlerConfig.getInstance().getSoTimeout();
        boolean proxied = this.rec.isProxied();
        int t = Math.min(soTimeout * 10 + 2, soTimeout / 2) * 1000;
        this.m_socket = ReusableSocketManager.getInstance().getSocket(this.rec, t, proxied);
        if (this.m_socket == null) {
            throw new IOException("Socet is null");
        }
        this.fetcher = this._chooseFetcher();
        if (proxied) {
            this.fetcher.setHTTPProxied(true);
        }
        this.fetcher.setExpirationTime(soTimeout);
    }

    public void callPrefetchFilters() {
        this.m_aclString = null;
        for (PrefetchFilter filter : this.prefetchFilters) {
            block5: {
                try {
                    this._addToRequestHeader(filter.httpHeaderContent(this.rec));
                }
                catch (Throwable e) {
                    if (!logger.isLoggable(Level.WARNING)) break block5;
                    logger.log(Level.WARNING, "C4904W.CLIENT_PREFETCH_ERROR", e);
                }
            }
            try {
                this._addToACLString(filter.acls(this.rec));
            }
            catch (Throwable e) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "C4904W.CLIENT_PREFETCH_ERROR", e);
            }
        }
    }

    private RestartableFetcher _chooseFetcher() {
        RestartableFetcher ret = null;
        ret = this.fba != null ? new FBAReauthFetcher(this.referer, this.fba) : new RestartableFetcher();
        return ret;
    }

    private void _addToRequestHeader(String s) {
        if (s != null && s.length() > 0 && this.fetcher != null) {
            this.fetcher.addToRequestHeader(s);
        }
    }

    private void _addToACLString(String s) {
        if (s != null && s.length() > 0) {
            this.m_aclString = this.m_aclString + s;
        }
    }

    public String[] getContentTypeAndEncoding() {
        if (this.fetcher == null) {
            return null;
        }
        return this.fetcher.getContentTypeAndEncoding();
    }

    public String getContentType() {
        if (this.fetcher == null) {
            return null;
        }
        String[] rv = this.fetcher.getContentTypeAndEncoding();
        return rv != null && rv.length > 0 ? rv[0] : null;
    }

    public void saveCookies() {
        for (int i = 0; i < COOKIES.length; ++i) {
            Object object = this.getHTTPHeaderProperties().get(COOKIES[i]);
            if (object == null) continue;
            String id = this.rec.getCrawlerId();
            if (object instanceof String) {
                CookieTable.getInstance(id).update(CookieEntry.newEntry(this.url, (String)object));
                continue;
            }
            String[] ss = (String[])object;
            for (int j = 0; j < ss.length; ++j) {
                CookieTable.getInstance(id).update(CookieEntry.newEntry(this.url, ss[j]));
            }
        }
    }

    void setFBAJob(FormBaseAuthenticator fba) {
        this.fba = fba;
    }

    public short getHTTPReturnCode() {
        if (this.fetcher == null) {
            return 0;
        }
        if (this.forcedHTTPReturnCode != 0) {
            return this.forcedHTTPReturnCode;
        }
        return this.fetcher.getHTTPReturnCode();
    }

    public CURL getRedirectURL() {
        Properties p = this.getHTTPHeaderProperties();
        if (p == null) {
            return null;
        }
        String path = p.getProperty("location");
        if (path == null) {
            return null;
        }
        CURL curl = new CURL(path);
        if (curl.isValid()) {
            return curl;
        }
        curl = new CURL(this.url, path);
        return curl.isValid() ? curl : null;
    }

    public void setForcedHTTPReturnCode(short code) {
        this.forcedHTTPReturnCode = code;
    }

    public boolean isTruncated() {
        if (this.fetcher == null) {
            return false;
        }
        return this.fetcher.isTruncated();
    }

    public Properties getHTTPHeaderProperties() {
        if (this.fetcher == null) {
            return null;
        }
        return this.fetcher.getHTTPHeaderProperties();
    }

    public byte[] getHTTPHeader() {
        return this.fetcher != null ? this.fetcher.getHTTPHeader() : null;
    }

    public HashableDataBufferOutputStream getContent() {
        return this.fetcher == null ? null : this.fetcher.getContent();
    }

    public String getContentString() {
        String encoding = null;
        if (this.fetcher == null || this.fetcher.getContent() == null) {
            return null;
        }
        encoding = this.getEncoding(null);
        try {
            int len;
            Reader reader = this.getContentAsReader(encoding);
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((len = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, len);
            }
            return writer.toString();
        }
        catch (Exception e) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "", e);
            }
            return null;
        }
    }

    public Reader getContentAsReader(String encoding) throws WCException {
        try {
            HashableDataBufferOutputStream content;
            if (this.fetcher == null || (content = this.fetcher.getContent()) == null) {
                return null;
            }
            encoding = this.getEncoding(encoding);
            return new InputStreamReader(content.getInputStream(), encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new EncodingException("getContentString", encoding, uee);
        }
        catch (DataBufferException e) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "", e);
            }
            return null;
        }
    }

    private String getEncoding(String encoding) {
        String ret = encoding;
        if (ret == null) {
            ret = this.fetcher == null ? null : this.fetcher.getContentTypeAndEncoding()[1];
        }
        boolean notSupported = false;
        if (ret != null) {
            try {
                notSupported = !Charset.isSupported(ret);
            }
            catch (Exception ignored) {
                notSupported = true;
            }
        }
        if (ret == null || notSupported) {
            ret = this.rec.getConfig().getCodepage();
        }
        if (ret != null) {
            try {
                notSupported = !Charset.isSupported(ret);
            }
            catch (Exception ignored) {
                notSupported = true;
            }
        }
        if (ret == null || notSupported) {
            ret = "ISO8859-1";
        }
        return ret;
    }

    public CURL getURL() {
        if (this.fetcher == null) {
            return null;
        }
        return this.fetcher.getURL();
    }

    public String getHTTPBasicAuthACLString() {
        return this.m_aclString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean instAddPrefetchFilter(PrefetchFilter f) {
        List<PrefetchFilter> list = this.prefetchFilters;
        synchronized (list) {
            this.prefetchFilters.add(f);
            return true;
        }
    }

    void setReferer(CURL referer) {
        this.referer = referer;
    }

    public void clear() {
        HashableDataBufferOutputStream content;
        if (this.fetcher != null && (content = this.fetcher.getContent()) != null) {
            content.dispose();
        }
    }

    static {
        try {
            defaultPrefetchFilters.add(new CookieFilter());
            defaultPrefetchFilters.add(new BasicAuthFilter());
            defaultPrefetchFilters.add(new ProxyBasicAuthFilter());
        }
        catch (Exception e) {
            tracer.log(Level.FINE, "Static init", e);
        }
    }
}

