/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.http;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.util.Base64;

public class BasicAuth {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String rootURLString;
    private String realmName;
    private String user;
    private String password;
    private String acl;
    private CURL rootURL;
    private String m_authorizationString;
    protected BasicAuth m_next;

    public BasicAuth(String domain, String realm, String user, String password, String acl) {
        this.rootURL = new CURL(domain);
        this.rootURLString = this.rootURL.toString();
        this.rootURLString = domain;
        this.realmName = realm;
        this.user = user;
        this.password = password;
        this.acl = acl;
    }

    public String getACLString() {
        return this.acl;
    }

    public String getHTTPBasicAuthorization() {
        return this._getAuthorizationString();
    }

    public Hash64 getHash64() {
        return this.rootURL.getHostHash();
    }

    public String toString() {
        return this.rootURLString + "," + this.realmName + "," + this.user + "," + this.password + "," + this.acl;
    }

    protected String _getAuthorizationString() {
        if (this.m_authorizationString == null) {
            this.m_authorizationString = "Authorization: Basic " + Base64.encode((this.user + ":" + this.password).getBytes());
        }
        return this.m_authorizationString;
    }

    protected boolean _isEncryptionUsed() {
        return true;
    }

    public CURL getRootURL() {
        return this.rootURL;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }
}

