/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.error;

import com.ibm.es.nuvo.crawler.web.error.NegativeException;
import com.ibm.es.nuvo.crawler.web.error.NoValueException;
import com.ibm.es.nuvo.crawler.web.error.NonpositiveException;
import com.ibm.es.nuvo.crawler.web.error.RangeException;
import com.ibm.es.nuvo.crawler.web.error.WCException;

public class ArgCheck {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static void nonnullState(String name, Object value) throws WCException {
        if (value == null) {
            throw new NoValueException(name);
        }
    }

    public static void nullState(String name, Object value) throws WCException {
        if (value != null) {
            throw new NoValueException(name);
        }
    }

    public static String nonWSArg(String name, String value) throws WCException {
        if (value == null || value.trim().length() == 0) {
            throw new NoValueException(name);
        }
        return value;
    }

    public static void nonWSState(String name, String value) throws WCException {
        if (value == null || value.trim().length() == 0) {
            throw new NoValueException(name);
        }
    }

    public static Object notNull(String name, Object value) throws WCException {
        if (value == null) {
            throw new NoValueException(name);
        }
        return value;
    }

    public static void positive(String name, int value) throws WCException {
        if (value <= 0) {
            throw new NonpositiveException(name);
        }
    }

    public static void positive(String name, long value) throws WCException {
        if (value <= 0L) {
            throw new NonpositiveException(name);
        }
    }

    public static void nonnegative(String name, int value) throws WCException {
        if (value < 0) {
            throw new NegativeException(name);
        }
    }

    public static void nonnegative(String name, long value) throws WCException {
        if (value < 0L) {
            throw new NegativeException(name);
        }
    }

    public static int inRange(String name, int value, int min, int max) throws WCException {
        if (value < min || value > max) {
            throw new RangeException(name, min, max, value);
        }
        return value;
    }
}

