/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db.tables;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.URIStatus;
import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.bucket.BucketManager;
import com.ibm.es.nuvo.crawler.web.configuration.space.AgentConfig;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.crawler.web.db.InsertRequest;
import com.ibm.es.nuvo.crawler.web.db.UpdateRequest;
import com.ibm.es.nuvo.crawler.web.db.tables.AbstractTable;
import com.ibm.es.nuvo.crawler.web.db.tables.SystemTable;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.rule.WebSpace;
import com.ibm.es.nuvo.crawler.web.util.BloomFilter;
import com.ibm.es.nuvo.crawler.web.util.UnixTime;
import com.ibm.es.nuvo.crawler.web.util.WCRequest;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLTable
extends AbstractTable {
    static final int PRI_CONFIG_CHANGE = -50;
    static final int PRI_REFRESH = -100;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int COMMIT_COUNT = 500;
    private static final boolean STORE_FILTER = true;
    private static final String[] INFO_COLUMNS = new String[]{"crawldate", "recrawldate", "httpcode", "discoverer", "flags1", "modifieddate", "urlstr"};
    private boolean enableBloomFilter = true;
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + URLTable.class.getName());
    private PreparedStatement stmtURLCount;
    private PreparedStatement stmtFingerCount;
    private PreparedStatement stmtInsert;
    private PreparedStatement stmtUpdate;
    private PreparedStatement stmtSelect;
    private boolean crawlNewURL;
    private DBConnection connection;
    private DBConnection updateConnection;
    private boolean closed;
    private Lock lock = new ReentrantLock(true);
    private Lock updateLock = new ReentrantLock(true);
    private BloomFilter urlFilter = new BloomFilter(0x200000, 24);
    private DBConnection monitorConnection;
    private int cacheHit;
    private int numChecked;

    public static URLTable getInstance(String collectionId) {
        return (URLTable)URLTable.getInstance(collectionId, URLTable.class);
    }

    URLTable(String id) throws WCException, SQLException {
        super(id);
        this.connection = this.getConnection();
        this.monitorConnection = this.getConnection();
        this.updateConnection = this.getConnection();
        this.updateConnection.setAutoCommit(false);
        this.stmtURLCount = this.connection.prepareStatement("SELECT COUNT(*) FROM %s.url where URLHASH=? WITH UR");
        this.stmtFingerCount = this.connection.prepareStatement("SELECT COUNT(*) FROM %s.url where fingerprint=? WITH UR");
        this.stmtUpdate = this.updateConnection.prepareStatement("UPDATE %s.url SET httpcode=?,httpcodecount=?,crawldate=?,recrawldate=?,serverdate=?,expiredate=?,modifieddate=?,fingerprint=?,flags1=? WHERE urlhash = ?");
        this.stmtInsert = this.updateConnection.prepareStatement("INSERT INTO %s.url (hosthash,urlhash,discoverer,creationdate,urlstr,recrawldate) VALUES (?,?,?,?,?,0)");
        if (this.enableBloomFilter) {
            boolean loaded = false;
            SystemTable sys = SystemTable.getInstance(id);
            sys.lockClose();
            BloomFilter url = sys.loadBloomFilter(1);
            if (url != null) {
                loaded = true;
                this.urlFilter = url;
            }
            if (!loaded) {
                this.loadFilter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFilter() {
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            Statement statement = null;
            ResultSet set = null;
            try {
                statement = this.connection.createStatement();
                set = statement.executeQuery("SELECT URLHASH FROM whitney.url  WITH UR");
                while (set.next()) {
                    long url = set.getLong(1);
                    if (set.wasNull()) continue;
                    this.urlFilter.add(url);
                }
            }
            catch (Exception e) {
                block8: {
                    try {
                        if (!tracer.isLoggable(Level.FINE)) break block8;
                        tracer.log(Level.FINE, "While loading data into bloom filter", e);
                    }
                    catch (Throwable throwable) {
                        URLTable.close(statement);
                        URLTable.close(set);
                        throw throwable;
                    }
                }
                URLTable.close(statement);
                URLTable.close(set);
            }
            URLTable.close(statement);
            URLTable.close(set);
            return;
            this.enableBloomFilter = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getValidUrlCount() {
        int count = -1;
        this.updateLastUsed();
        PreparedStatement stmtSyncValidURLCounter = null;
        DBConnection dBConnection = this.monitorConnection;
        synchronized (dBConnection) {
            block10: {
                try {
                    stmtSyncValidURLCounter = this.monitorConnection.prepareStatement("SELECT COUNT(*) AS ct FROM %s.url WHERE httpcode between 200 and 299 WITH UR");
                    count = this.getCount(stmtSyncValidURLCounter);
                    if (count >= 0) break block10;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "C4812E.TABLE_URL_SYNC");
                    }
                    count = 0;
                }
                catch (SQLException sqle) {
                    logger.log(Level.SEVERE, "C4812E.TABLE_URL_SYNC", sqle);
                    count = -1;
                    URLTable.close(stmtSyncValidURLCounter);
                }
                catch (WCException e) {
                    logger.log(Level.SEVERE, "C4812E.TABLE_URL_SYNC", e);
                    count = -1;
                    {
                        catch (Throwable throwable) {
                            URLTable.close(stmtSyncValidURLCounter);
                            throw throwable;
                        }
                    }
                    URLTable.close(stmtSyncValidURLCounter);
                }
            }
            URLTable.close(stmtSyncValidURLCounter);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUrlExist(long hashCode) throws SQLException {
        Object object;
        this.updateLastUsed();
        if (this.numChecked % 1000 == 0 && tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "Cache hit " + this.cacheHit + " total " + this.numChecked + " passed " + (this.numChecked - this.cacheHit));
        }
        ++this.numChecked;
        if (this.enableBloomFilter) {
            object = this.urlFilter;
            synchronized (object) {
                if (!this.urlFilter.add(hashCode)) {
                    ++this.cacheHit;
                    return false;
                }
                if (this.urlFilter.canTrust()) {
                    ++this.cacheHit;
                    return true;
                }
            }
        }
        object = this.connection;
        synchronized (object) {
            boolean bl;
            try {
                this.stmtURLCount.setLong(1, hashCode);
                bl = this.getCount(this.stmtURLCount) > 0;
            }
            catch (Throwable throwable) {
                URLTable.clear(this.stmtURLCount);
                throw throwable;
            }
            URLTable.clear(this.stmtURLCount);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countCrawledURL() throws WCException, SQLException {
        this.updateLastUsed();
        DBConnection dBConnection = this.monitorConnection;
        synchronized (dBConnection) {
            int n;
            PreparedStatement statement = null;
            try {
                statement = this.monitorConnection.prepareStatement("SELECT COUNT(*) FROM %s.url WHERE crawldate IS NOT NULL WITH UR");
                n = this.getCount(statement);
            }
            catch (Throwable throwable) {
                URLTable.close(statement);
                throw throwable;
            }
            URLTable.close(statement);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countCrawledURL(long hostHash, long from, long to) throws WCException, SQLException {
        this.updateLastUsed();
        PreparedStatement statement = null;
        DBConnection dBConnection = this.monitorConnection;
        synchronized (dBConnection) {
            int n;
            try {
                statement = this.monitorConnection.prepareStatement("SELECT COUNT(*) FROM %s.url WHERE hosthash = ? AND crawldate AND crawldate >= ?  AND crawldate <= ? IS NOT NULL  WITH UR");
                statement.setLong(1, hostHash);
                statement.setLong(2, from);
                statement.setLong(3, to);
                n = this.getCount(statement);
            }
            catch (Throwable throwable) {
                URLTable.close(statement);
                throw throwable;
            }
            URLTable.close(statement);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countNotCrawledURL() throws WCException, SQLException {
        this.updateLastUsed();
        DBConnection dBConnection = this.monitorConnection;
        synchronized (dBConnection) {
            int n;
            PreparedStatement statement = null;
            try {
                statement = this.monitorConnection.prepareStatement("SELECT COUNT(*) FROM %s.url WHERE crawldate IS NULL  WITH UR");
                n = this.getCount(statement);
            }
            catch (Throwable throwable) {
                URLTable.close(statement);
                throw throwable;
            }
            URLTable.close(statement);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countOverDueUrl() throws WCException, SQLException {
        this.updateLastUsed();
        PreparedStatement statement = null;
        DBConnection dBConnection = this.monitorConnection;
        synchronized (dBConnection) {
            int n;
            try {
                statement = this.monitorConnection.prepareStatement("SELECT COUNT(*) FROM %s.url WHERE recrawldate < ?  WITH UR");
                statement.setInt(1, UnixTime.now());
                n = this.getCount(statement);
            }
            catch (Throwable throwable) {
                URLTable.close(statement);
                throw throwable;
            }
            URLTable.close(statement);
            return n;
        }
    }

    public Map<Integer, Integer> getCodeDistribution(Long hostHash) throws WCException, SQLException {
        this.updateLastUsed();
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT httpcode, COUNT(httpcode) FROM %s.url WHERE ");
        if (hostHash != null) {
            buffer.append("HOSTHASH = ");
            buffer.append(hostHash);
            buffer.append("AND");
        }
        buffer.append("httpcode IS NOT NULL GROUP BY HTTPCODE ORDER BY httpcode  WITH UR");
        Map<Integer, Integer> map = this.getCountMap(buffer.toString());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Integer> getCountMap(String query) throws WCException, SQLException {
        this.updateLastUsed();
        PreparedStatement stm = null;
        ResultSet rs = null;
        DBConnection dBConnection = this.monitorConnection;
        synchronized (dBConnection) {
            TreeMap<Integer, Integer> treeMap;
            try {
                stm = this.monitorConnection.prepareStatement(query);
                TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
                rs = stm.executeQuery();
                while (rs.next()) {
                    map.put(rs.getInt(1), rs.getInt(2));
                }
                treeMap = map;
            }
            catch (Throwable throwable) {
                URLTable.close(rs);
                URLTable.close(stm);
                throw throwable;
            }
            URLTable.close(rs);
            URLTable.close(stm);
            return treeMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int countURLAtHost(long hostHash, Integer from, Integer to, boolean notNull) {
        this.updateLastUsed();
        StringBuilder buffer = new StringBuilder();
        buffer.append("SELECT COUNT(*) FROM %s.url WHERE hosthash = ");
        buffer.append(hostHash);
        if (notNull) {
            buffer.append(" AND crawldate IS NOT NULL ");
        } else {
            if (from == null && to == null) {
                return 0;
            }
            buffer.append(" AND recrawldate > ? AND recrawldate < ?");
        }
        buffer.append(" WITH UR ");
        PreparedStatement statement = null;
        int count = 0;
        DBConnection dBConnection = this.monitorConnection;
        synchronized (dBConnection) {
            try {
                statement = this.monitorConnection.prepareStatement(buffer.toString());
                count = this.getCount(statement);
            }
            catch (WCException e) {
                Message message = new Message("C4928W.TABLE_COUNT_FAIL", buffer.toString());
                ExtendedException exception = new ExtendedException(message, (Throwable)e);
                logger.log(Level.WARNING, exception);
                URLTable.close(statement);
            }
            catch (SQLException ignore) {
                URLTable.close(statement);
                {
                    catch (Throwable throwable) {
                        URLTable.close(statement);
                        throw throwable;
                    }
                }
            }
            URLTable.close(statement);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getUrlInfo(long urlHash) throws WCException, SQLException {
        this.updateLastUsed();
        Properties prop = new Properties();
        PreparedStatement statement = null;
        ResultSet set = null;
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            try {
                statement = this.connection.prepareStatement("SELECT crawldate,recrawldate,httpcode,discoverer,flags1,modifieddate,urlstr FROM %s.url WHERE urlhash = ?  WITH UR");
                statement.setLong(1, urlHash);
                set = statement.executeQuery();
                if (set.next()) {
                    for (int i = 0; i < INFO_COLUMNS.length; ++i) {
                        Object object = set.getObject(i + 1);
                        if (object == null || set.wasNull()) continue;
                        prop.put(INFO_COLUMNS[i], String.valueOf(object));
                    }
                }
            }
            catch (Throwable throwable) {
                URLTable.close(set);
                URLTable.close(statement);
                throw throwable;
            }
            URLTable.close(set);
            URLTable.close(statement);
        }
        return prop;
    }

    private void add(long hostHash, long urlHash, long discovered, int created, String url) throws SQLException {
        this.stmtInsert.setLong(1, hostHash);
        this.stmtInsert.setLong(2, urlHash);
        this.stmtInsert.setLong(3, discovered);
        this.stmtInsert.setInt(4, created);
        this.stmtInsert.setString(5, url);
        this.stmtInsert.addBatch();
        if (tracer.isLoggable(Level.FINEST)) {
            tracer.finer(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] add(Collection<WCRequest> requests, int skip) throws SQLException {
        this.updateLastUsed();
        int[] ret = null;
        AbstractTable.ExecuteResults results = new AbstractTable.ExecuteResults(requests.size() - skip);
        int count = 0;
        this.updateLock.lock();
        try {
            try {
                StringBuilder sBuf = new StringBuilder();
                for (WCRequest wcRequest : requests) {
                    InsertRequest request = (InsertRequest)wcRequest;
                    if (skip-- > 0) continue;
                    sBuf.append(request.m_depth).append('.').append(request.m_urlString);
                    this.add(request.m_hostHash, request.m_urlHash, request.m_discoverer, request.m_creationDate, sBuf.toString());
                    sBuf.setLength(0);
                    if (count++ <= 500) continue;
                    this.updateLastUsed();
                    ret = this.stmtInsert.executeBatch();
                    this.updateConnection.commit();
                    results.add(ret);
                    count = 0;
                }
                if (count > 0) {
                    this.updateLastUsed();
                    ret = this.stmtInsert.executeBatch();
                    this.updateConnection.commit();
                    results.add(ret);
                }
            }
            catch (SQLException e) {
                this.updateConnection.rollback();
                this.urlFilter.setFailed(true);
                throw e;
            }
            finally {
                URLTable.clear(this.stmtInsert);
            }
        }
        finally {
            this.updateLock.unlock();
        }
        return results.getArray();
    }

    /*
     * Loose catch block
     */
    public int[] update(ArrayList<UpdateRequest> requestList) throws SQLException {
        this.updateLastUsed();
        int count = 0;
        AbstractTable.ExecuteResults results = new AbstractTable.ExecuteResults(requestList.size());
        this.updateLock.lock();
        try {
            try {
                int[] ret;
                for (UpdateRequest request : requestList) {
                    this.stmtUpdate.setShort(1, request.m_httpCode);
                    this.stmtUpdate.setShort(2, request.m_httpCodeCount);
                    this.stmtUpdate.setInt(3, request.m_crawlDate);
                    int recrawl = request.m_recrawlDate;
                    if (request.config != null && !request.config.isValid()) {
                        recrawl = 0;
                    }
                    this.stmtUpdate.setInt(4, recrawl);
                    this.stmtUpdate.setInt(5, request.m_serverDate);
                    this.stmtUpdate.setInt(6, request.m_expireDate);
                    this.stmtUpdate.setInt(7, request.m_modifiedDate);
                    this.stmtUpdate.setInt(8, request.m_fingerprint);
                    this.stmtUpdate.setInt(9, request.m_flags1);
                    this.stmtUpdate.setLong(10, request.m_urlHash);
                    this.stmtUpdate.addBatch();
                    if (count++ <= 500) continue;
                    this.updateLastUsed();
                    ret = this.stmtUpdate.executeBatch();
                    this.updateConnection.commit();
                    results.add(ret);
                    count = 0;
                }
                if (count > 0) {
                    this.updateLastUsed();
                    ret = this.stmtUpdate.executeBatch();
                    this.updateConnection.commit();
                    results.add(ret);
                }
                Object i$ = results.getArray();
                return i$;
            }
            catch (SQLException e) {
                try {
                    this.updateConnection.rollback();
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                URLTable.clear(this.stmtUpdate);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.updateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<CrawlRec> getCrawlRecs(Bucket bucket) throws WCException, SQLException {
        boolean canCrawlNewURL;
        this.updateLastUsed();
        int limit = bucket.getMaxURL();
        if (limit < 1) {
            limit = 1;
        }
        if (limit > 1000) {
            limit = 1000;
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Loading crawl records into " + bucket + " up to " + limit);
        }
        if ((canCrawlNewURL = bucket.getManager().canCrawlNewURL()) != this.crawlNewURL || this.stmtSelect == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SELECT urlstr,crawldate,recrawldate,httpcode,httpcodecount,fingerprint FROM %s.url WHERE ");
            if (!canCrawlNewURL) {
                buffer.append("( recrawldate > 0 AND ");
            }
            buffer.append("recrawldate < ? ");
            if (!canCrawlNewURL) {
                buffer.append(") ");
            }
            buffer.append("AND hosthash = ? ORDER BY RECRAWLDATE ASC WITH UR");
            if (tracer.isLoggable(Level.FINEST)) {
                tracer.finer("Statement to load : " + buffer.toString());
            }
            DBConnection dBConnection = this.connection;
            synchronized (dBConnection) {
                URLTable.close(this.stmtSelect);
                String query = buffer.toString();
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.fine("Prepare : " + query);
                }
                this.stmtSelect = this.connection.prepareStatement(query);
            }
            this.crawlNewURL = canCrawlNewURL;
        }
        ResultSet rs = null;
        ArrayList<CrawlRec> list = new ArrayList<CrawlRec>();
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            try {
                this.stmtSelect.setMaxRows(limit);
                this.stmtSelect.setInt(1, UnixTime.now());
                this.stmtSelect.setLong(2, bucket.getHostHash().longValue());
                rs = this.stmtSelect.executeQuery();
                String global = bucket.getConfig().getAcl().getGlobal();
                String language = bucket.getConfig().getLanguage();
                while (rs.next()) {
                    String urlString;
                    int index;
                    CrawlRec cr = new CrawlRec();
                    cr.setContentLanguage(language);
                    if (global != null) {
                        cr.setSecurityACLs(global);
                    }
                    if ((index = (urlString = rs.getString("urlstr")).indexOf(46)) >= 0) {
                        String depthStr = urlString.substring(0, index);
                        try {
                            cr.setDepth(Integer.parseInt(depthStr));
                            urlString = urlString.substring(index + 1);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    cr.setURL(new CURL(urlString));
                    int j = rs.getInt("crawldate");
                    cr.setCrawlDate(j, rs.wasNull());
                    j = rs.getInt("recrawldate");
                    cr.setCrawlIntervalSec(j - cr.getCrawlDate(), rs.wasNull());
                    short s = rs.getShort("httpcode");
                    cr.setOldHTTPStatus(s, rs.wasNull());
                    s = rs.getShort("httpcodecount");
                    cr.setHTTPStatusCount(s, rs.wasNull());
                    j = rs.getInt("fingerprint");
                    cr.setOldFingerprint(j, rs.wasNull());
                    list.add(cr);
                }
            }
            catch (Throwable throwable) {
                URLTable.close(rs);
                URLTable.clear(this.stmtSelect);
                throw throwable;
            }
            URLTable.close(rs);
            URLTable.clear(this.stmtSelect);
        }
        if (list.size() > 0) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, list.size() + " records was loaded into " + bucket);
                if (tracer.isLoggable(Level.FINEST) && list.size() > 0) {
                    tracer.finest(list.toString());
                }
            }
        } else if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("no record was loaded into " + bucket);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            URLTable.close(this.stmtSelect);
            URLTable.close(this.stmtURLCount);
            URLTable.close(this.stmtUpdate);
            URLTable.close(this.stmtInsert);
            URLTable.close(this.stmtFingerCount);
            URLTable.close(this.connection);
            this.updateLock.lock();
            try {
                URLTable.close(this.updateConnection);
            }
            finally {
                this.updateLock.unlock();
            }
            URLTable.close(this.monitorConnection);
            if (tracer.isLoggable(Level.FINER)) {
                try {
                    tracer.finer("Connection status " + this.connection.isClosed() + " " + this.updateConnection.isClosed() + " " + this.monitorConnection.isClosed());
                }
                catch (SQLException e) {
                    tracer.log(Level.FINE, "status", e);
                }
            }
            SystemTable sys = SystemTable.getInstance(this.getId());
            if (this.enableBloomFilter && !this.urlFilter.isFailed()) {
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer(this.getId() + " : Storing bloom filter");
                }
                sys.storeBloomFilter(1, this.urlFilter);
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer(this.getId() + " : Bloom filter was stored");
                }
            }
            sys.release();
            this.closed = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int recrawl(String pattern, boolean force, WebSpace space, AgentConfig config, boolean proxyChanged, boolean basicAuthChanged, boolean formAuthChanged, BucketManager.ConfigChecker checker) {
        int count;
        block45: {
            count = 0;
            this.updateLastUsed();
            this.lockClose();
            PreparedStatement statement = null;
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("Recrawl " + (pattern == null ? "all" : pattern));
            }
            this.updateLock.lock();
            try {
                block44: {
                    if (checker != null && checker.isAborted()) {
                        int n = 0;
                        return n;
                    }
                    try {
                        if (space == null && !basicAuthChanged && !formAuthChanged && !proxyChanged || force) {
                            StringBuilder builder = new StringBuilder();
                            builder.append("update %s.url set recrawldate= ").append(-50).append(" ");
                            if (force) {
                                builder.append(", fingerprint=0 ");
                            }
                            builder.append("where recrawldate>0 and httpcode is not null");
                            if (pattern != null) {
                                builder.append(" and urlstr like '");
                                builder.append(pattern);
                                builder.append("'");
                            }
                            statement = this.updateConnection.prepareStatement(builder.toString());
                            count = statement.executeUpdate();
                            this.updateConnection.commit();
                            if (tracer.isLoggable(Level.FINE)) {
                                tracer.fine("Set recrawldate to 0. # of urls are " + count);
                            }
                            break block44;
                        }
                        ResultSet set = null;
                        try {
                            StringBuilder builder = new StringBuilder();
                            boolean first = true;
                            builder.append("select urlstr,httpcode,recrawldate from %s.url where httpcode in ( ");
                            if (space != null) {
                                builder.append("200,780,760");
                                first = false;
                            }
                            if (config != null) {
                                if (basicAuthChanged) {
                                    if (!first) {
                                        builder.append(",");
                                    }
                                    first = false;
                                    builder.append("401");
                                }
                                if (formAuthChanged) {
                                    if (space == null) {
                                        if (!first) {
                                            builder.append(",");
                                        }
                                        first = false;
                                        builder.append("200");
                                    }
                                    if (!first) {
                                        builder.append(",");
                                    }
                                    first = false;
                                    builder.append("302");
                                }
                                if (proxyChanged) {
                                    if (!first) {
                                        builder.append(",");
                                    }
                                    first = false;
                                    builder.append("611,612,613,614,615");
                                }
                            }
                            builder.append(" ) and recrawldate > 0 for update of recrawldate");
                            String qry = builder.toString();
                            statement = this.updateConnection.prepareStatementForUpdate(qry);
                            this.updateConnection.setAutoCommit(false);
                            set = statement.executeQuery();
                            while (set.next() && (checker == null || !checker.isAborted())) {
                                String url = set.getString(1);
                                int code = set.getInt(2);
                                CURL curl = new CURL(url);
                                boolean allowed = false;
                                if (space != null) {
                                    allowed = space.isAllowed(curl) && !space.isExcluded(curl);
                                }
                                boolean doUpdate = false;
                                if (space != null) {
                                    boolean bl = doUpdate = code == 200 && !allowed || code == 760 && allowed;
                                }
                                if (config != null) {
                                    if (!doUpdate && basicAuthChanged && config.getBasicAuth(curl) != null) {
                                        doUpdate = true;
                                    }
                                    if (!doUpdate && formAuthChanged && config.getFormBaseAuthenticator(curl) != null) {
                                        doUpdate = true;
                                    }
                                    if (!doUpdate && proxyChanged && code > 610 && code < 616) {
                                        doUpdate = true;
                                    }
                                }
                                if (!doUpdate) continue;
                                set.updateInt("recrawldate", -50);
                                set.updateRow();
                                if (count++ <= 10000) continue;
                                this.updateConnection.commit();
                                count = 0;
                            }
                            if (count > 0) {
                                this.updateConnection.commit();
                            }
                        }
                        catch (Throwable e) {
                            try {
                                e.printStackTrace();
                                this.updateConnection.rollback();
                                throw e;
                            }
                            catch (Throwable throwable) {
                                URLTable.close(set);
                                throw throwable;
                            }
                        }
                        URLTable.close(set);
                    }
                    catch (Throwable e) {
                        try {
                            logger.log(Level.WARNING, "G0006E.CAUSED_BY", e);
                            break block45;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                this.updateConnection.setAutoCommit(false);
                            }
                            catch (SQLException ignored) {}
                            URLTable.close(statement);
                        }
                    }
                }
                try {
                    this.updateConnection.setAutoCommit(false);
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                URLTable.close(statement);
            }
            finally {
                this.updateLock.unlock();
                this.updateLastUsed();
                this.release();
            }
        }
        SystemTable sys = SystemTable.getInstance(this.getId());
        if (sys == null) return count;
        if (!force) return count;
        if (checker != null) {
            if (checker.isAborted()) return count;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.asLongBuffer().put(System.currentTimeMillis());
        sys.update(3, buffer.array());
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forceRefresh() {
        int count = 0;
        this.updateLastUsed();
        this.lockClose();
        PreparedStatement statement = null;
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("forceRefresh ");
        }
        this.updateLock.lock();
        try {
            String qry = "update %s.url set recrawldate = -100, fingerprint=0 where httpcode = 200 and recrawldate > -100";
            statement = this.updateConnection.prepareStatement(qry);
            this.updateConnection.setAutoCommit(true);
            count = statement.executeUpdate();
        }
        catch (Exception e) {
            count = -1;
            logger.log(Level.WARNING, "G0006E.CAUSED_BY", e);
        }
        finally {
            try {
                try {
                    this.updateConnection.setAutoCommit(false);
                }
                catch (SQLException sQLException) {}
                URLTable.close(statement);
            }
            finally {
                this.updateLock.unlock();
            }
            this.updateLastUsed();
            this.release();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<URIStatus> reportURLStatus(String urlString, int maxReturned) {
        this.updateLastUsed();
        PreparedStatement statement = null;
        ResultSet set = null;
        ArrayList<URIStatus> list = new ArrayList<URIStatus>();
        String like = urlString;
        boolean isURLHash = false;
        boolean isArchiveUri = false;
        if (urlString.contains("?ArchiveEntry=")) {
            isArchiveUri = true;
        }
        Long hash = null;
        CURL curl = new CURL(urlString);
        if (urlString.length() > 0) {
            String hostname;
            if (urlString.indexOf("%") < 0 && urlString.indexOf("_") < 0) {
                if (!curl.isValid()) {
                    return list;
                }
                hash = curl.getURLHash().longValue();
                isURLHash = true;
                like = null;
            } else if (curl.isValid() && (hostname = curl.getHostname()).indexOf("%") < 0 && hostname.indexOf("_") < 0) {
                hash = curl.getHostHash().longValue();
                isURLHash = false;
            }
        }
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            block22: {
                this.lockClose();
                try {
                    String sql = "select crawldate,httpcode,urlstr,uristring from %s.url left outer join %s.archivedata on urlhash=PARENTURIHASH WHERE " + (like != null ? "( LOWER(urlstr) like ? escape '\\' OR LOWER(uristring) like ? escape '\\' ) " : " ") + (hash != null ? (like != null ? "AND " : "") + (isURLHash ? (isArchiveUri ? "urihash = ? " : "urlhash = ? ") : "hosthash = ? ") : " ") + "WITH UR";
                    statement = this.connection.prepareStatement(sql);
                    if (maxReturned > 0) {
                        statement.setMaxRows(maxReturned);
                    }
                    int argCount = 1;
                    if (like != null) {
                        statement.setString(argCount++, urlString.toLowerCase());
                        statement.setString(argCount++, urlString.toLowerCase());
                    }
                    if (hash != null) {
                        statement.setLong(argCount++, hash);
                    }
                    if (tracer.isLoggable(Level.FINER)) {
                        tracer.finer(sql + " " + like + " " + hash + " " + isURLHash);
                    }
                    set = statement.executeQuery();
                    int count = 0;
                    while (set.next()) {
                        String url = set.getString(3);
                        String aurl = set.getString(4);
                        if (!set.wasNull()) {
                            url = aurl;
                        }
                        list.add(new URIStatus(url, set.getInt(2), (long)set.getInt(1) * 1000L));
                        ++count;
                    }
                    this.release();
                }
                catch (SQLException ignored) {
                    ignored.printStackTrace();
                    break block22;
                }
                catch (Exception e) {
                    Loggers.auditLogger.log(Level.WARNING, "", e);
                    break block22;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.release();
                    URLTable.close(set);
                    URLTable.close(statement);
                }
                URLTable.close(set);
                URLTable.close(statement);
            }
        }
        return list;
    }

    @Override
    protected boolean isClosed() {
        return URLTable.isClosed(this.connection) || URLTable.isClosed(this.updateConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countRefreshDoc() {
        this.updateLastUsed();
        DBConnection dBConnection = this.monitorConnection;
        synchronized (dBConnection) {
            int n;
            PreparedStatement statement = null;
            try {
                statement = this.monitorConnection.prepareStatement("SELECT COUNT(*) FROM %s.url WHERE recrawldate = -100");
                int count = this.getCount(statement);
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.fine("countRefreshDoc " + count);
                }
                n = count;
            }
            catch (Exception e) {
                try {
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "", e);
                    }
                }
                catch (Throwable throwable) {
                    URLTable.close(statement);
                    throw throwable;
                }
                URLTable.close(statement);
            }
            URLTable.close(statement);
            return n;
        }
        return -1;
    }
}

