/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db.tables;

import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.crawler.web.db.tables.AbstractTable;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.util.BloomFilter;
import com.ibm.es.nuvo.crawler.web.util.StreamUtils;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

public class SystemTable
extends AbstractTable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + SystemTable.class.getName());
    private DBConnection connection;
    public static final int KEY_CONFIG_HASH = 0;
    public static final int KEY_URL_BLOOM = 1;
    public static final int KEY_FINGER_BLOOM = 2;
    public static final int KEY_FORCE_RECRAWL_DATE = 3;
    public static final int KEY_FORCE_UPDATE_SCHEDULED = 4;
    private PreparedStatement stmtGetValue;
    private PreparedStatement stmtInsertValue;
    private PreparedStatement stmtUpdateValue;
    private boolean foeceUpdateScheduled = false;

    public static SystemTable getInstance(String collectionId) {
        return (SystemTable)SystemTable.getInstance(collectionId, SystemTable.class);
    }

    SystemTable(String id) {
        super(id);
        try {
            this.connect();
            byte[] bs = this.get(4);
            if (bs != null && Boolean.valueOf(new String(bs)).booleanValue()) {
                this.foeceUpdateScheduled = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws WCException, SQLException {
        SystemTable systemTable = this;
        synchronized (systemTable) {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = this.getConnection();
                this.connection.setAutoCommit(false);
                SystemTable.close(this.stmtGetValue);
                this.stmtGetValue = this.connection.prepareStatementForUpdate("select value from %s.config where name=? for update");
                SystemTable.close(this.stmtUpdateValue);
                this.stmtUpdateValue = this.connection.prepareStatementForUpdate("select value from %s.config where name=? for update of value");
                SystemTable.close(this.stmtInsertValue);
                this.stmtInsertValue = this.connection.prepareStatement("insert into %s.config values (?,?)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(int key) throws SQLException {
        this.updateLastUsed();
        byte[] ret = null;
        try {
            this.connect();
        }
        catch (Exception e) {
            return null;
        }
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            ResultSet set = null;
            try {
                this.stmtGetValue.setInt(1, key);
                set = this.stmtGetValue.executeQuery();
                if (set.next()) {
                    ret = set.wasNull() ? null : set.getBytes(1);
                }
            }
            catch (Throwable throwable) {
                SystemTable.clear(this.stmtGetValue);
                SystemTable.close(set);
                throw throwable;
            }
            SystemTable.clear(this.stmtGetValue);
            SystemTable.close(set);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int key, byte[] hash) {
        try {
            this.connect();
        }
        catch (Exception e) {
            return;
        }
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            ResultSet set = null;
            boolean updated = false;
            try {
                this.stmtUpdateValue.setInt(1, key);
                try {
                    set = this.stmtUpdateValue.executeQuery();
                    if (set.next()) {
                        set.updateBytes(1, hash);
                        set.updateRow();
                        updated = true;
                    }
                }
                finally {
                    SystemTable.close(set);
                }
                if (!updated) {
                    this.stmtInsertValue.setInt(1, key);
                    this.stmtInsertValue.setBytes(2, hash);
                    int i = this.stmtInsertValue.executeUpdate();
                    if (i == 0 && tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "Not inserted");
                    }
                }
                this.connection.commit();
            }
            catch (Throwable e) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "Not inserted");
                }
            }
            finally {
                SystemTable.clear(this.stmtInsertValue);
                SystemTable.clear(this.stmtUpdateValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BloomFilter loadBloomFilter(int key) {
        this.updateLastUsed();
        BloomFilter filter = null;
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            ResultSet set = null;
            try {
                this.stmtGetValue.setInt(1, key);
                set = this.stmtGetValue.executeQuery();
                if (set.next()) {
                    Blob ret;
                    Blob blob = ret = set.wasNull() ? null : set.getBlob(1);
                    if (ret != null) {
                        InputStream bis = null;
                        ObjectInputStream ois = null;
                        try {
                            bis = ret.getBinaryStream();
                            ois = new ObjectInputStream(bis);
                            filter = (BloomFilter)ois.readObject();
                        }
                        catch (Throwable throwable) {
                            StreamUtils.safeClose(ois);
                            StreamUtils.safeClose(bis);
                            throw throwable;
                        }
                        StreamUtils.safeClose(ois);
                        StreamUtils.safeClose(bis);
                    }
                    set.deleteRow();
                }
                this.connection.commit();
            }
            catch (Exception e) {
                block14: {
                    try {
                        try {
                            this.connection.rollback();
                        }
                        catch (SQLException ignored) {
                            // empty catch block
                        }
                        if (!tracer.isLoggable(Level.FINE)) break block14;
                        tracer.log(Level.FINE, "" + key, e);
                    }
                    catch (Throwable throwable) {
                        SystemTable.clear(this.stmtGetValue);
                        SystemTable.close(set);
                        throw throwable;
                    }
                }
                SystemTable.clear(this.stmtGetValue);
                SystemTable.close(set);
            }
            SystemTable.clear(this.stmtGetValue);
            SystemTable.close(set);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeBloomFilter(int key, BloomFilter filter) {
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            ResultSet set = null;
            boolean updated = false;
            InputStream is = null;
            try {
                this.stmtUpdateValue.setInt(1, key);
                is = filter.getInputStream();
                int len = filter.getSizeInBytes();
                try {
                    set = this.stmtUpdateValue.executeQuery();
                    if (set.next()) {
                        set.updateBinaryStream(1, is, len);
                        set.updateRow();
                        updated = true;
                    }
                }
                finally {
                    SystemTable.close(set);
                }
                if (!updated) {
                    this.stmtInsertValue.setInt(1, key);
                    this.stmtInsertValue.setBinaryStream(2, is, len);
                    int i = this.stmtInsertValue.executeUpdate();
                    if (i == 0 && tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "Not inserted");
                    }
                }
                this.connection.commit();
            }
            catch (Exception e) {
                block16: {
                    try {
                        try {
                            this.connection.rollback();
                        }
                        catch (SQLException ignore) {
                            // empty catch block
                        }
                        if (!tracer.isLoggable(Level.FINE)) break block16;
                        tracer.log(Level.FINE, "BloomFilter", e);
                    }
                    catch (Throwable throwable) {
                        StreamUtils.safeClose(is);
                        SystemTable.clear(this.stmtInsertValue);
                        SystemTable.clear(this.stmtUpdateValue);
                        throw throwable;
                    }
                }
                StreamUtils.safeClose(is);
                SystemTable.clear(this.stmtInsertValue);
                SystemTable.clear(this.stmtUpdateValue);
            }
            StreamUtils.safeClose(is);
            SystemTable.clear(this.stmtInsertValue);
            SystemTable.clear(this.stmtUpdateValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        SystemTable systemTable = this;
        synchronized (systemTable) {
            SystemTable.close(this.stmtGetValue);
            SystemTable.close(this.stmtInsertValue);
            SystemTable.close(this.stmtUpdateValue);
            SystemTable.close(this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClosed() {
        SystemTable systemTable = this;
        synchronized (systemTable) {
            return SystemTable.isClosed(this.connection);
        }
    }

    public boolean isFoeceUpdateScheduled() {
        return this.foeceUpdateScheduled;
    }

    public void setFoeceUpdateScheduled(boolean foeceUpdateScheduled) {
        this.foeceUpdateScheduled = foeceUpdateScheduled;
        this.update(4, String.valueOf(foeceUpdateScheduled).getBytes());
    }
}

