/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db.tables;

import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.crawler.web.db.tables.AbstractTable;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RobotsTable
extends AbstractTable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private PreparedStatement stmRobotsUpdate;
    private PreparedStatement stmRobotsInsert;
    private PreparedStatement stmCount;
    private PreparedStatement stmSelectTxt;
    private DBConnection connection = this.getConnection();

    public static RobotsTable getInstance(String collectionId) {
        RobotsTable robotsTable = (RobotsTable)RobotsTable.getInstance(collectionId, RobotsTable.class);
        return robotsTable;
    }

    public RobotsTable(String id) throws WCException, SQLException {
        super(id);
        this.stmCount = this.connection.prepareStatement("select count(*) from %s.robots WHERE hosthash = ? with UR");
        this.stmRobotsInsert = this.connection.prepareStatement("INSERT INTO %s.robots (robotstxt,hosthash) VALUES (?,?)");
        this.stmRobotsUpdate = this.connection.prepareStatement("UPDATE %s.robots SET robotstxt = ? WHERE hosthash = ?");
        this.stmSelectTxt = this.connection.prepareStatement("SELECT robotstxt FROM %s.robots where hosthash=? with UR");
        this.connection.setAutoCommit(true);
    }

    public boolean updateRobotText(Bucket bucket, String robotsTxt) throws SQLException {
        return this.updateRobotText(bucket.getHostHash().longValue(), robotsTxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRobotText(long hostHash, String robotsTxt) throws SQLException {
        boolean ret;
        this.updateLastUsed();
        ResultSet set = null;
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            block10: {
                try {
                    this.stmCount.setLong(1, hostHash);
                    set = this.stmCount.executeQuery();
                    boolean exist = false;
                    if (set.next()) {
                        boolean bl = exist = set.getInt(1) > 0;
                    }
                    if (!exist) {
                        this.stmRobotsInsert.setString(1, robotsTxt);
                        this.stmRobotsInsert.setLong(2, hostHash);
                        ret = this.stmRobotsInsert.execute();
                        break block10;
                    }
                    this.stmRobotsUpdate.setString(1, robotsTxt);
                    this.stmRobotsUpdate.setLong(2, hostHash);
                    ret = this.stmRobotsUpdate.execute();
                }
                catch (SQLException e) {
                    try {
                        if (!RobotsTable.isTruncated(e)) {
                            throw e;
                        }
                        ret = true;
                    }
                    catch (Throwable throwable) {
                        RobotsTable.close(set);
                        RobotsTable.clear(this.stmCount);
                        RobotsTable.clear(this.stmRobotsInsert);
                        RobotsTable.clear(this.stmRobotsUpdate);
                        throw throwable;
                    }
                    RobotsTable.close(set);
                    RobotsTable.clear(this.stmCount);
                    RobotsTable.clear(this.stmRobotsInsert);
                    RobotsTable.clear(this.stmRobotsUpdate);
                }
            }
            RobotsTable.close(set);
            RobotsTable.clear(this.stmCount);
            RobotsTable.clear(this.stmRobotsInsert);
            RobotsTable.clear(this.stmRobotsUpdate);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRobotsTxt(long hostHash) throws SQLException {
        this.updateLastUsed();
        ResultSet set = null;
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            block4: {
                String string;
                try {
                    this.stmSelectTxt.setLong(1, hostHash);
                    set = this.stmSelectTxt.executeQuery();
                    if (!set.next()) break block4;
                    String ret = set.getString(1);
                    string = set.wasNull() ? null : ret;
                }
                catch (Throwable throwable) {
                    RobotsTable.close(set);
                    RobotsTable.clear(this.stmSelectTxt);
                    throw throwable;
                }
                RobotsTable.close(set);
                RobotsTable.clear(this.stmSelectTxt);
                return string;
            }
            RobotsTable.close(set);
            RobotsTable.clear(this.stmSelectTxt);
            return null;
        }
    }

    protected void close() {
        RobotsTable.close(this.stmRobotsInsert);
        RobotsTable.close(this.stmRobotsUpdate);
        RobotsTable.close(this.stmCount);
        RobotsTable.close(this.stmSelectTxt);
        RobotsTable.close(this.connection);
    }

    protected boolean isClosed() {
        return RobotsTable.isClosed(this.connection);
    }
}

