/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db.tables;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.crawler.web.db.tables.AbstractTable;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import java.net.InetAddress;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPTable
extends AbstractTable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private DBConnection connection = this.getConnection();
    private PreparedStatement stmDelete = this.connection.prepareStatement("DELETE FROM %s.ip WHERE hosthash = ?");
    private PreparedStatement stmInsert = this.connection.prepareStatement("INSERT INTO %s.ip(hosthash, address) VALUES (?,?)");

    public static IPTable getInstance(String collectionId) {
        return (IPTable)IPTable.getInstance(collectionId, IPTable.class);
    }

    IPTable(String id) throws WCException, SQLException {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIP(HashMap<Hash64, Bucket> buckets) throws WCException, SQLException {
        this.updateLastUsed();
        PreparedStatement statement = null;
        ResultSet set = null;
        try {
            for (int i = 0; i < 2; ++i) {
                statement = this.connection.prepareStatement("SELECT hosthash,address FROM %s.ip with UR");
                set = statement.executeQuery();
                while (set.next()) {
                    Bucket bucket;
                    long l = set.getLong(1);
                    byte[] addr = set.getBytes(2);
                    if (set.wasNull() || (bucket = buckets.get(new Hash64(l))) == null) continue;
                    bucket.addIPAddress(addr);
                }
                IPTable.close(set);
                IPTable.close(statement);
                set = null;
                statement = null;
            }
        }
        finally {
            IPTable.close(set);
            IPTable.close(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] update(long hostHash, ArrayList<InetAddress> list) throws SQLException {
        this.updateLastUsed();
        try {
            int[] ret;
            this.stmDelete.setLong(1, hostHash);
            this.stmDelete.execute();
            for (InetAddress addr : list) {
                this.stmInsert.setLong(1, hostHash);
                this.stmInsert.setBytes(2, addr.getAddress());
                this.stmInsert.addBatch();
            }
            int[] nArray = ret = this.stmInsert.executeBatch();
            return nArray;
        }
        finally {
            IPTable.clear(this.stmDelete);
            IPTable.clear(this.stmInsert);
        }
    }

    @Override
    protected void close() {
        IPTable.close(this.stmDelete);
        IPTable.close(this.stmInsert);
        IPTable.close(this.connection);
    }

    @Override
    protected boolean isClosed() {
        return IPTable.isClosed(this.connection);
    }
}

