/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db.tables;

import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public abstract class DBUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + DBUtils.class.getName());

    static boolean isCausedByUniqueConstraint(SQLException e) {
        return e != null && 30000 == e.getErrorCode();
    }

    protected static boolean isTruncated(SQLException e) {
        return e != null && 30000 == e.getErrorCode();
    }

    protected static void close(ResultSet set) {
        if (set == null) {
            return;
        }
        try {
            set.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static void close(Statement statement) {
        block3: {
            if (statement == null) {
                return;
            }
            DBUtils.clear(statement);
            try {
                statement.close();
            }
            catch (SQLException e) {
                if (!tracer.isLoggable(Level.FINE)) break block3;
                tracer.log(Level.FINE, "close", e);
            }
        }
    }

    protected static void clear(Statement statement) {
        if (statement == null) {
            return;
        }
        if (statement instanceof PreparedStatement) {
            try {
                ((PreparedStatement)statement).clearParameters();
            }
            catch (SQLException ignored) {
                // empty catch block
            }
        }
        try {
            statement.clearWarnings();
        }
        catch (SQLException ignored) {
            // empty catch block
        }
        try {
            statement.clearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void close(DBConnection connection) {
        try {
            int retry = 5;
            boolean rollback = false;
            while (retry-- > 0) {
                try {
                    if (connection == null || connection.isClosed()) return;
                    connection.close();
                }
                catch (SQLException e) {
                    block11: {
                        if (rollback) throw e;
                        try {
                            if (tracer.isLoggable(Level.FINE)) {
                                tracer.log(Level.FINE, "rollback");
                            }
                            connection.setAutoCommit(true);
                            connection.rollback();
                        }
                        catch (SQLException e2) {
                            if (!tracer.isLoggable(Level.FINE)) break block11;
                            tracer.log(Level.FINE, "rollback", e2);
                        }
                    }
                    rollback = true;
                    continue;
                    return;
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (!tracer.isLoggable(Level.FINE)) return;
            tracer.log(Level.FINE, "close", e);
        }
    }

    protected static void close(Connection connection) {
        block3: {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                if (!tracer.isLoggable(Level.FINE)) break block3;
                tracer.log(Level.FINE, "close", e);
            }
        }
    }

    protected static boolean isClosed(DBConnection connection) {
        try {
            return connection == null || connection.isClosed();
        }
        catch (SQLException e) {
            return true;
        }
    }
}

