/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db.tables;

import com.ibm.es.nuvo.crawler.web.cookie.CookieEntry;
import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.crawler.web.db.tables.AbstractTable;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieTable
extends AbstractTable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + CookieTable.class.getName());
    private DBConnection connection;
    private PreparedStatement stmInsert;
    private HashSet<Long> ignoreSet = new HashSet();
    private Map<Integer, CookieEntry> cookies = new HashMap<Integer, CookieEntry>();

    public static CookieTable getInstance(String collectionId) {
        return (CookieTable)CookieTable.getInstance(collectionId, CookieTable.class);
    }

    CookieTable(String id) throws WCException, SQLException {
        super(id);
        this.connection = this.getConnection();
        this.connection.setAutoCommit(false);
        this.stmInsert = this.connection.prepareStatement("insert into %s.cookie values(?,?,?,?,?,?,?,?,?) ");
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        block6: {
            PreparedStatement statement = null;
            ResultSet set = null;
            try {
                statement = this.connection.prepareStatement("select * from %s.cookie where expires > " + System.currentTimeMillis());
                set = statement.executeQuery();
                while (set.next()) {
                    String domain = set.getString("domain");
                    if (set.wasNull()) continue;
                    this.update(CookieEntry.newEntry(new CURL("http://" + domain), set.getString("name"), set.getString("value"), set.getInt("expires"), set.getString("path"), domain, set.getInt("version"), set.getString("SECURE").equals("Y"), false));
                }
                CookieTable.close(statement);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
                break block6;
            }
            finally {
                CookieTable.close(statement);
                CookieTable.close(set);
            }
            CookieTable.close(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CookieEntry entry) {
        if (entry == null) {
            return;
        }
        Map<Integer, CookieEntry> map = this.cookies;
        synchronized (map) {
            this.cookies.put(entry.hashCode(), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable(Collection<CookieEntry> cookieList) {
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            try {
                int cc = 0;
                for (CookieEntry entry : cookieList) {
                    if (entry == null || entry.isSession()) continue;
                    this.updateLastUsed();
                    if (tracer.isLoggable(Level.FINEST)) {
                        tracer.finest("update\n" + entry);
                    }
                    int i = 1;
                    this.stmInsert.setLong(i++, 0L);
                    this.stmInsert.setLong(i++, 0L);
                    this.stmInsert.setInt(i++, entry.getExpire());
                    this.stmInsert.setString(i++, entry.isSecure() ? "Y" : "N");
                    this.stmInsert.setShort(i++, (short)entry.getVersion());
                    this.stmInsert.setString(i++, entry.getName());
                    this.stmInsert.setString(i++, entry.getValue());
                    this.stmInsert.setString(i++, entry.getPath());
                    this.stmInsert.setString(i++, entry.getDomain());
                    this.stmInsert.addBatch();
                    if (++cc <= 100) continue;
                    cc = 0;
                    this.stmInsert.executeBatch();
                    this.connection.commit();
                }
                if (cc > 0) {
                    this.stmInsert.executeBatch();
                    this.connection.commit();
                }
            }
            catch (SQLException e) {
                CookieTable.logSQLException(tracer, Level.FINE, "Failed to update cookie", e);
                try {
                    this.connection.rollback();
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
            }
            finally {
                CookieTable.clear(this.stmInsert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCookieEntry(CURL url) {
        if (url == null || !url.isValid()) {
            return null;
        }
        if (this.ignoreSet.remove(url.getHostHash().longValue())) {
            return null;
        }
        this.updateLastUsed();
        String urlPath = url.getPath();
        String hostname = url.getHostname();
        long start = System.currentTimeMillis();
        Map<Integer, CookieEntry> map = this.cookies;
        synchronized (map) {
            HashMap<String, CookieEntry> map2 = new HashMap<String, CookieEntry>();
            int version = 0;
            for (CookieEntry entry : this.cookies.values()) {
                int vers;
                String domain;
                if (!urlPath.startsWith(entry.getPath()) || (domain = entry.getDomain()) != null && !hostname.endsWith(domain)) continue;
                String name = entry.getName();
                CookieEntry existEntry = (CookieEntry)map2.get(name);
                if (existEntry != null) {
                    if (existEntry.getPath() != null && existEntry.getPath().length() >= entry.getPath().length()) continue;
                    map2.remove(name);
                }
                if ((vers = entry.getVersion()) > version) {
                    version = vers;
                }
                map2.put(name, entry);
            }
            if (map2.size() == 0) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("Cookie: ");
            int orgLen = buffer.length();
            if (version > 0) {
                buffer.append("$Version=\"");
                buffer.append(version);
                buffer.append("\"");
            }
            for (CookieEntry entry : map2.values()) {
                if (buffer.length() > orgLen) {
                    buffer.append("; ");
                }
                buffer.append(entry.getName());
                buffer.append("=");
                buffer.append(entry.getValue());
                if (version <= 0 || entry.getPath() == null) continue;
                buffer.append("; $Path=\"");
                buffer.append(entry.getPath());
                buffer.append("\"");
            }
            if (buffer.length() > 0 && tracer.isLoggable(Level.FINER)) {
                tracer.finer("Get cookie in " + (System.currentTimeMillis() - start) + "\n" + url + "\n" + buffer.toString());
            }
            return buffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() {
        Map<Integer, CookieEntry> map = this.cookies;
        synchronized (map) {
            if (this.removeAll() >= 0) {
                this.updateTable(this.cookies.values());
            }
        }
        CookieTable.close(this.stmInsert);
        CookieTable.close(this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeAll() {
        PreparedStatement statement = null;
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            int n;
            try {
                statement = this.connection.prepareStatement("delete from %s.cookie");
                int ret = statement.executeUpdate();
                this.connection.commit();
                n = ret;
            }
            catch (Exception ignored) {
                try {
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException ign) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    CookieTable.close(statement);
                    throw throwable;
                }
                CookieTable.close(statement);
            }
            CookieTable.close(statement);
            return n;
        }
        return -1;
    }

    public void ignoreCookie(CURL url) {
        this.ignoreSet.add(url.getHostHash().longValue());
    }

    @Override
    protected boolean isClosed() {
        return CookieTable.isClosed(this.connection);
    }
}

