/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db.tables;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.crawler.web.db.tables.AbstractTable;
import com.ibm.es.nuvo.crawler.web.error.ArgCheck;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketTable
extends AbstractTable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private DBConnection connection = this.getConnection();

    BucketTable(String id) throws WCException {
        super(id);
    }

    public static BucketTable getInstance(String collectionId) {
        return (BucketTable)BucketTable.getInstance(collectionId, BucketTable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(Bucket bucket, boolean resetDNS, boolean resetRobots) throws WCException, SQLException {
        if (this.connection == null) {
            return;
        }
        ArgCheck.notNull("bucket", bucket);
        PreparedStatement stmUpdate = null;
        this.updateLastUsed();
        try {
            stmUpdate = this.connection.prepareStatement("UPDATE %s.bucket SET dnsdate=?,dnsfailcount=?,robotsdate=?,robotsfailcount=?,servertype=?,volatile=?,activatedate=?,scandate=?,scancount=?,crawldate=?,uncrawledcount=?,deactivatedate=? WHERE hosthash = ?");
            if (resetDNS) {
                stmUpdate.setInt(1, 0);
                stmUpdate.setShort(2, (short)0);
            } else {
                stmUpdate.setInt(1, bucket.getDNSDate());
                stmUpdate.setShort(2, (short)bucket.getDNSFailCount());
            }
            if (resetRobots) {
                stmUpdate.setInt(3, 0);
                stmUpdate.setShort(4, (short)0);
            } else {
                stmUpdate.setInt(3, bucket.getRobotsDate());
                stmUpdate.setShort(4, (short)bucket.getRobotsFailCount());
            }
            stmUpdate.setString(5, bucket.getServerType());
            stmUpdate.setInt(6, bucket.isVolatile() ? 1 : 0);
            stmUpdate.setInt(7, bucket.getActivateDate());
            stmUpdate.setInt(8, bucket.getScanDate());
            stmUpdate.setInt(9, bucket.getScanCount());
            stmUpdate.setInt(10, bucket.getCrawlDate());
            stmUpdate.setInt(11, bucket.getUncrawledCount());
            stmUpdate.setInt(12, bucket.getDeactivateDate());
            stmUpdate.setLong(13, bucket.getHostHash().longValue());
            stmUpdate.executeUpdate();
        }
        catch (Throwable throwable) {
            BucketTable.clear(stmUpdate);
            throw throwable;
        }
        BucketTable.clear(stmUpdate);
    }

    public synchronized void add(Bucket bucket) throws WCException, SQLException {
        if (this.connection == null) {
            return;
        }
        PreparedStatement statement = null;
        this.updateLastUsed();
        try {
            statement = this.connection.prepareStatement("INSERT INTO %s.bucket (HOSTHASH,PROTONUM,HOSTNAME,PORT) VALUES (?,?,?,?)");
            statement.setLong(1, bucket.getHostHash().longValue());
            statement.setShort(2, (short)bucket.getProtocolNumber());
            statement.setString(3, bucket.getHostname());
            statement.setInt(4, bucket.getPort());
            statement.execute();
            this.connection.commit();
        }
        catch (SQLException e) {
            try {
                try {
                    this.connection.rollback();
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable throwable) {
                BucketTable.close(statement);
                throw throwable;
            }
        }
        BucketTable.close(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<Hash64, Bucket> loadBuckets(String spaceID) throws WCException, SQLException {
        this.updateLastUsed();
        PreparedStatement statement = null;
        HashMap<Hash64, Bucket> map = new HashMap<Hash64, Bucket>();
        ResultSet set = null;
        try {
            statement = this.connection.prepareStatement("SELECT * FROM %s.bucket with UR");
            set = statement.executeQuery();
            while (set.next()) {
                Bucket bucket = this.createBucket(spaceID, set);
                map.put(bucket.getHostHash(), bucket);
            }
        }
        catch (Throwable throwable) {
            BucketTable.close(set);
            BucketTable.close(statement);
            throw throwable;
        }
        BucketTable.close(set);
        BucketTable.close(statement);
        return map;
    }

    private Bucket createBucket(String crawlerID, ResultSet set) throws SQLException {
        boolean isVolatile;
        String serverType = set.getString(9);
        if (set.wasNull()) {
            serverType = null;
        }
        boolean bl = isVolatile = set.getInt(10) != 0;
        if (set.wasNull()) {
            isVolatile = false;
        }
        Bucket bucket = new Bucket(crawlerID, set.getLong(1), set.getShort(2), set.getString(3), set.getInt(4), this.getInt(5, set), this.getInt(6, set), this.getInt(7, set), this.getInt(8, set), serverType, isVolatile, this.getInt(11, set), this.getInt(12, set), this.getInt(13, set), this.getInt(14, set), this.getInt(15, set), this.getInt(16, set));
        return bucket;
    }

    private int getInt(int i, ResultSet set) throws SQLException {
        int ret = set.getInt(i);
        return set.wasNull() ? 0 : ret;
    }

    @Override
    protected void close() {
        BucketTable.close(this.connection);
        this.connection = null;
    }

    @Override
    protected boolean isClosed() {
        return BucketTable.isClosed(this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        PreparedStatement stm = null;
        DBConnection dBConnection = this.connection;
        synchronized (dBConnection) {
            try {
                stm = this.connection.prepareStatement("delete from %s.bucket where hosthash not in ( select hosthash from %s.url group by hosthash )");
                stm.executeUpdate();
            }
            catch (Exception ignored) {
                try {
                    ignored.printStackTrace();
                }
                catch (Throwable throwable) {
                    BucketTable.close(stm);
                    throw throwable;
                }
                BucketTable.close(stm);
            }
            BucketTable.close(stm);
        }
    }
}

