/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db.tables;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.archive.ArchiveEntryProcessor;
import com.ibm.es.nuvo.crawler.web.archive.ArchiveHandleException;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.crawler.web.db.tables.AbstractTable;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.rule.WebSpace;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveEntryTable
extends AbstractTable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + ArchiveEntryTable.class.getName());
    private static final String COLUMN_URIHASH = "URIHASH";
    private static final String COLUMN_PARENTURIHASH = "PARENTURIHASH";
    private static final String COLUMN_FINGERPRINT = "FINGERPRINT";
    private static final String COLUMN_URISTRING = "URISTRING";
    private PreparedStatement m_selectEntry;
    private PreparedStatement m_insertEntry;
    private PreparedStatement m_updateEntry;
    private PreparedStatement m_deleteEntry;
    private boolean m_prepared = false;
    private DBConnection connection;

    ArchiveEntryTable(String id) throws WCException {
        super(id);
        this.prepare();
    }

    public static ArchiveEntryTable getInstance(String collectionId) {
        return (ArchiveEntryTable)ArchiveEntryTable.getInstance(collectionId, ArchiveEntryTable.class);
    }

    public synchronized void prepare() throws WCException {
        this.updateLastUsed();
        try {
            this.connection = this.getConnection();
            this.connection.setAutoCommit(true);
            this.m_selectEntry = this.connection.prepareStatement("SELECT URISTRING,FINGERPRINT FROM %s.ARCHIVEDATA WHERE PARENTURIHASH=? with UR");
            this.m_insertEntry = this.connection.prepareStatement("INSERT INTO %s.ARCHIVEDATA VALUES (?,?,?,?)");
            this.m_updateEntry = this.connection.prepareStatement("UPDATE %s.ARCHIVEDATA SET FINGERPRINT=? WHERE URIHASH=?");
            this.m_deleteEntry = this.connection.prepareStatement("DELETE FROM %s.ARCHIVEDATA WHERE URIHASH=?");
            this.m_prepared = true;
        }
        catch (SQLException e) {
            throw new ArchiveHandleException("Falied to prepare for archive support", (Throwable)e);
        }
        catch (WCException e) {
            throw new ArchiveHandleException("Falied to prepare for archive support", (Throwable)e);
        }
    }

    public ArchiveEntryProcessor getProcessor(CURL url, CrawlRec cr, WebSpace space, String encoding) throws WCException {
        ArchiveEntryProcessor processor = new ArchiveEntryProcessor(url, cr, space, encoding, this);
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(CURL entry, CrawlRec rec, CURL parent) throws SQLException {
        this.updateLastUsed();
        if (!this.m_prepared) {
            return;
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Commit");
        }
        try {
            if (404 == rec.getNewHTTPStatus()) {
                this.m_deleteEntry.setLong(1, entry.getURLHash().longValue());
                this.m_deleteEntry.execute();
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Delete " + rec.getURL());
                }
            } else if (rec.getOldFingerprint() != 0) {
                if (rec.getNewFingerprint() != rec.getOldFingerprint()) {
                    this.m_updateEntry.setLong(1, rec.getNewFingerprint());
                    this.m_updateEntry.setLong(2, entry.getURLHash().longValue());
                    this.m_updateEntry.execute();
                    if (tracer.isLoggable(Level.FINER)) {
                        tracer.finer("Update " + rec.getURL());
                    }
                }
            } else {
                this.m_insertEntry.setLong(1, entry.getURLHash().longValue());
                this.m_insertEntry.setLong(2, parent.getURLHash().longValue());
                this.m_insertEntry.setLong(3, rec.getNewFingerprint());
                this.m_insertEntry.setString(4, entry.toString());
                this.m_insertEntry.execute();
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Insert " + rec.getURL());
                }
            }
        }
        finally {
            ArchiveEntryTable.clear(this.m_deleteEntry);
            ArchiveEntryTable.clear(this.m_updateEntry);
            ArchiveEntryTable.clear(this.m_insertEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<Hash64, CrawlRec> getEntries(CURL parent) throws SQLException {
        if (!this.m_prepared) {
            return null;
        }
        this.updateLastUsed();
        this.m_selectEntry.setLong(1, parent.getURLHash().longValue());
        ResultSet set = null;
        try {
            set = this.m_selectEntry.executeQuery();
            HashMap<Hash64, CrawlRec> ret = null;
            if (set != null) {
                ret = new HashMap<Hash64, CrawlRec>();
                while (set.next()) {
                    CrawlRec rec = new CrawlRec();
                    rec.setURL(new CURL(set.getString(1)));
                    rec.setOldFingerprint(set.getInt(2));
                    ret.put(rec.getURL().getURLHash(), rec);
                }
            }
            HashMap<Hash64, CrawlRec> hashMap = ret;
            return hashMap;
        }
        finally {
            ArchiveEntryTable.close(set);
            ArchiveEntryTable.clear(this.m_selectEntry);
        }
    }

    @Override
    protected synchronized void close() {
        ArchiveEntryTable.close(this.m_selectEntry);
        ArchiveEntryTable.close(this.m_insertEntry);
        ArchiveEntryTable.close(this.m_deleteEntry);
        ArchiveEntryTable.close(this.connection);
        this.m_prepared = false;
    }

    @Override
    protected boolean isClosed() {
        return ArchiveEntryTable.isClosed(this.connection);
    }
}

