/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db.tables;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.crawler.web.bucket.FederatedBucketManager;
import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.crawler.web.db.DBConnectionManager;
import com.ibm.es.nuvo.crawler.web.db.tables.DBUtils;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTable
extends DBUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + AbstractTable.class.getName());
    private static final int CLOSE_DELAY = 5000;
    private static Map<String, AbstractTable> instanceMap = new HashMap<String, AbstractTable>();
    private String id;
    private long keepAlive = -1L;
    private long lastUsed = System.currentTimeMillis();
    private int referCount;
    private static Map<String, Lock> locks = new HashMap<String, Lock>();

    AbstractTable(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DBConnection getConnection() throws WCException {
        Lock lock = AbstractTable.getLock(this.id);
        lock.lock();
        try {
            DBConnection dBConnection = DBConnectionManager.instance().createConnection(this.id);
            return dBConnection;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lock getLock(String key) {
        Lock lock = locks.get(key);
        if (lock == null) {
            Map<String, Lock> map = locks;
            synchronized (map) {
                lock = locks.get(key);
                if (lock == null) {
                    lock = new ReentrantLock();
                    locks.put(key, lock);
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AbstractTable getInstance(String id, Class<? extends AbstractTable> cls) {
        Map<String, AbstractTable> map;
        String tableId = AbstractTable.getKey(id, cls);
        if (!DBConnectionManager.instance().available(id)) {
            return null;
        }
        AbstractTable table = instanceMap.get(tableId);
        if (table != null) {
            map = instanceMap;
            synchronized (map) {
                if (table.isClosed()) {
                    table = instanceMap.get(tableId);
                    if (table != null && table.isClosed()) {
                        AbstractTable t = instanceMap.remove(tableId);
                        if (t != null) {
                            t.close();
                        }
                        table = null;
                    }
                } else {
                    table.updateLastUsed();
                }
            }
        }
        if (table == null) {
            map = instanceMap;
            synchronized (map) {
                table = instanceMap.get(tableId);
                if (table == null) {
                    try {
                        Constructor<? extends AbstractTable> constructor = cls.getDeclaredConstructor(String.class);
                        table = constructor.newInstance(id);
                        instanceMap.put(tableId, table);
                        if (!FederatedBucketManager.instance().isActive(id)) {
                            AbstractTable.closeTable(true, tableId, 5000);
                            if (tracer.isLoggable(Level.FINER)) {
                                tracer.finer("Schedule to close table (inactive space ) " + tableId);
                            }
                        }
                    }
                    catch (Exception e) {
                        Message message = new Message("C4810E.TABLE_INIT", cls.getName(), DBConnectionManager.instance().getCollectionID(id));
                        ExtendedException exception = new ExtendedException(message, (Throwable)e);
                        logger.log(Level.SEVERE, exception);
                        table = null;
                    }
                }
            }
        }
        return table;
    }

    private static String getKey(String id, Class<? extends AbstractTable> cls) {
        return id + File.pathSeparator + cls.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCount(PreparedStatement statement) throws SQLException {
        int count = -1;
        ResultSet set = null;
        int retry = 1;
        while (true) {
            try {
                set = statement.executeQuery();
                if (set.next()) {
                    count = set.getInt(1);
                    break;
                }
                logger.log(Level.WARNING, "C4928W.TABLE_COUNT_FAIL", new Object[]{statement.getMetaData().toString()});
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("40001") && retry-- > 0) {
                    logger.log(Level.INFO, "C5002I.DB_RETRY", new Object[]{statement.getMetaData().toString()});
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ignored) {}
                    continue;
                }
                throw e;
            }
            finally {
                AbstractTable.close(set);
                AbstractTable.clear(statement);
                continue;
            }
            break;
        }
        return count;
    }

    protected static String getString(ResultSet set, int offset) throws SQLException {
        if (set == null) {
            return null;
        }
        String ret = set.getString(offset);
        if (set.wasNull()) {
            return null;
        }
        return ret;
    }

    protected static void logSQLException(Logger l, Level level, String msg, SQLException e) {
        while (e != null) {
            l.log(level, msg, e);
            e = e.getNextException();
        }
    }

    public String getId() {
        return this.id;
    }

    protected void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    protected abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(String id, boolean set) {
        Lock lock = AbstractTable.getLock(id);
        lock.lock();
        try {
            id = id + File.pathSeparator;
            Map<String, AbstractTable> map = instanceMap;
            synchronized (map) {
                List<String> tables = AbstractTable.getTables(id);
                for (String tableId : tables) {
                    AbstractTable.closeTable(set, tableId, 5000);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void closeTable(boolean set, String tableId, int timeout) {
        AbstractTable table = instanceMap.get(tableId);
        if (set) {
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("Schedule to release " + tableId);
            }
            table.keepAlive = timeout;
            AbstractTable abstractTable = table;
            abstractTable.getClass();
            WebCrawler.schedule(abstractTable.new CloseTask(tableId), table.keepAlive, 1000L);
        } else {
            if (table.keepAlive > 0L && tracer.isLoggable(Level.FINER)) {
                tracer.finer("Canceled to release " + tableId);
            }
            table.keepAlive = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getTables(String id) {
        Lock lock = AbstractTable.getLock(id);
        lock.lock();
        try {
            ArrayList<String> list = new ArrayList<String>();
            Object object = instanceMap;
            synchronized (object) {
                for (String key : instanceMap.keySet()) {
                    if (!key.startsWith(id)) continue;
                    list.add(key);
                }
            }
            object = list;
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    public Statement createStatement() throws WCException, SQLException {
        return this.getConnection().createStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drop(String id) throws ExtendedException {
        Lock lock = AbstractTable.getLock(id);
        lock.lock();
        try {
            AbstractTable.close(id, true);
            long timeout = System.currentTimeMillis() + 180000L;
            try {
                while (timeout > System.currentTimeMillis()) {
                    List<String> tables = AbstractTable.getTables(id);
                    if (!(tables != null && tables.size() != 0 || DBConnectionManager.instance().isActiveDB(id))) {
                        DBConnectionManager.instance().drop(id);
                        break;
                    }
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        int maxWait = 30;
        try {
            while (maxWait-- > 0) {
                Map<String, AbstractTable> map = instanceMap;
                synchronized (map) {
                    if (instanceMap.size() == 0) {
                        break;
                    }
                }
                if (tracer.isLoggable(Level.FINER)) {
                    map = instanceMap;
                    synchronized (map) {
                        tracer.finer("Waiting for closing " + instanceMap.keySet());
                    }
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void lockClose() {
        ++this.referCount;
    }

    protected void release() {
        if (this.referCount > 0) {
            --this.referCount;
        }
    }

    protected abstract boolean isClosed();

    protected static class ExecuteResults {
        private int[] results;
        private int offset;

        public ExecuteResults(int capacity) {
            this.results = new int[capacity];
        }

        public void add(int[] rets) {
            if (rets == null || rets.length + this.offset > this.results.length) {
                return;
            }
            System.arraycopy(rets, 0, this.results, this.offset, rets.length);
            this.offset += rets.length;
        }

        public int[] getArray() {
            int[] ret = new int[this.offset];
            System.arraycopy(this.results, 0, ret, 0, this.offset);
            return ret;
        }
    }

    private class CloseTask
    extends TimerTask {
        private String key;

        public CloseTask(String key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (AbstractTable.this.keepAlive < 0L) {
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Canceled " + this.key);
                }
                this.cancel();
                return;
            }
            long now = System.currentTimeMillis();
            if (AbstractTable.this.lastUsed + AbstractTable.this.keepAlive > now) {
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Keep Alive  " + this.key + " time left " + (AbstractTable.this.lastUsed + AbstractTable.this.keepAlive - now));
                }
                return;
            }
            if (AbstractTable.this.referCount > 0) {
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Refered " + this.key + " " + AbstractTable.this.referCount);
                }
                AbstractTable.this.lastUsed += 100L;
                return;
            }
            Map map = instanceMap;
            synchronized (map) {
                block14: {
                    AbstractTable table;
                    if (tracer.isLoggable(Level.FINER)) {
                        tracer.finer("Releasing " + this.key);
                    }
                    if ((table = (AbstractTable)instanceMap.remove(this.key)) != null) {
                        try {
                            AbstractTable.this.close();
                        }
                        catch (Exception e) {
                            if (!tracer.isLoggable(Level.FINE)) break block14;
                            tracer.log(Level.FINE, "Closng " + table, e);
                        }
                    }
                }
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Released " + this.key);
                }
            }
            this.cancel();
        }
    }
}

