/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db;

import com.ibm.es.nuvo.crawler.web.bucket.FederatedBucketManager;
import com.ibm.es.nuvo.crawler.web.db.AsyncDBOperator;
import com.ibm.es.nuvo.crawler.web.db.UpdateRequest;
import com.ibm.es.nuvo.crawler.web.db.tables.URLTable;
import com.ibm.es.nuvo.crawler.web.util.WCRequest;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLUpdater
extends AsyncDBOperator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + URLUpdater.class.getName());
    public static final String s_agent = "URLUpdater";
    private static URLUpdater s_instance = new URLUpdater();

    @Override
    public void _clientInit() throws Exception {
        super._clientInit();
        this._assignThread("Ant", s_agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _processRequest(WCRequest r) throws Exception {
        List<WCRequest> list;
        List<WCRequest> list2 = list = this.getWaitingSet();
        synchronized (list2) {
            list.add(r);
        }
        this.flush(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processWaitingURLs(String id, List<WCRequest> list) {
        int count;
        if (list == null || list.size() == 0) {
            return;
        }
        int attempting = 0;
        if (!FederatedBucketManager.instance().isActive(id)) {
            return;
        }
        HashMap<Long, UpdateRequest> map = new HashMap<Long, UpdateRequest>();
        for (WCRequest wcRequest : list) {
            UpdateRequest r = (UpdateRequest)wcRequest;
            if (r.m_httpCode == 0) {
                if (!tracer.isLoggable(Level.FINE)) continue;
                tracer.log(Level.FINE, "An invalid URL update request was found. Code: " + r.m_httpCode + ". Hash: " + r.m_urlHash + ".");
                continue;
            }
            map.put(r.m_urlHash, r);
        }
        ArrayList<UpdateRequest> requestList = new ArrayList<UpdateRequest>();
        attempting = map.size();
        requestList.addAll(map.values());
        map.clear();
        if (attempting == 0) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.fine("No URLs being attempted in URLUpdater");
            }
            return;
        }
        int[] counts = null;
        try {
            counts = URLTable.getInstance(id).update(requestList);
        }
        catch (BatchUpdateException bue) {
            counts = bue.getUpdateCounts();
            if (tracer.isLoggable(Level.FINE)) {
                tracer.fine("No URLs being attempted in URLUpdater");
                tracer.log(Level.FINE, "Failed to update URL.", bue);
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer(requestList.toString());
                }
            }
        }
        catch (SQLException se) {
            tracer.log(Level.FINE, "Failed to update URL.", se);
        }
        finally {
            requestList.clear();
        }
        int n = count = counts == null ? 0 : counts.length;
        if (count != attempting) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "The status of URLs cannot be updated. " + id + " " + count + " " + attempting);
            }
        } else {
            for (int j = 0; j < count; ++j) {
                if (counts[j] != -3 || !tracer.isLoggable(Level.FINE)) continue;
                tracer.log(Level.FINE, "Failed to update " + j + "th row URL for " + id + ". ");
            }
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "URLUpdater: updated " + count + " URLs");
            }
        }
    }

    public static URLUpdater instance() {
        return s_instance;
    }

    private URLUpdater() {
        super(s_agent);
        this.setQueueSizes(1000);
        this.setQueueTimeoutSec(1);
        this.setHardLimit(2000);
        this.setFlashInterval(30);
    }

    @Override
    protected void doDBOperation(String id, List<WCRequest> list) throws Exception {
        this._processWaitingURLs(id, list);
    }
}

