/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db;

import com.ibm.es.nuvo.crawler.web.bucket.FederatedBucketManager;
import com.ibm.es.nuvo.crawler.web.db.AsyncDBOperator;
import com.ibm.es.nuvo.crawler.web.db.InsertRequest;
import com.ibm.es.nuvo.crawler.web.db.InsertRequestSet;
import com.ibm.es.nuvo.crawler.web.db.tables.URLTable;
import com.ibm.es.nuvo.crawler.web.util.WCRequest;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLInserter
extends AsyncDBOperator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int URL_SOFT_LIMIT = 10000;
    private static final int URL_HARD_LIMIT = 20000;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + URLInserter.class.getName());
    public static final String s_agent = "URLInserter";
    private Map<String, Integer> numInserted = new HashMap<String, Integer>();
    private static URLInserter s_instance = new URLInserter();

    @Override
    protected void _clientInit() throws Exception {
        super._clientInit();
        this._assignThread("Ant", s_agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _processRequest(WCRequest r) throws Exception {
        List<WCRequest> list;
        List<WCRequest> list2 = list = this.getWaitingSet();
        synchronized (list2) {
            if (r != null) {
                List<InsertRequest> requests = ((InsertRequestSet)r).getRequests();
                if (tracer.isLoggable(Level.FINEST)) {
                    tracer.finest("Adding " + requests.size());
                }
                list.addAll(requests);
            }
        }
        this.flush(10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void _insertURLs(String id, List<WCRequest> list) {
        int nFailed;
        void var7_12;
        if (list == null || list.size() == 0) {
            return;
        }
        if (!FederatedBucketManager.instance().isActive(id)) {
            return;
        }
        ArrayList<InsertRequest> removeURLs = new ArrayList<InsertRequest>();
        int verified = 0;
        HashSet<Long> set = new HashSet<Long>();
        for (WCRequest wCRequest : list) {
            InsertRequest request = (InsertRequest)wCRequest;
            try {
                if (set.add(request.m_urlHash) && !URLTable.getInstance(id).isUrlExist(request.m_urlHash)) continue;
                removeURLs.add(request);
                ++verified;
            }
            catch (SQLException e) {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "Error while filtering URL " + e.getErrorCode(), e);
                }
                removeURLs.add(request);
                ++verified;
            }
        }
        set.clear();
        set = null;
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer(id + " Total " + list.size() + "  Remains " + (list.size() - removeURLs.size()));
        }
        list.removeAll(removeURLs);
        removeURLs.clear();
        int size = list.size();
        Map<String, Integer> map = this.numInserted;
        synchronized (map) {
            Integer total = this.numInserted.get(id);
            if (total == null) {
                total = 0;
            }
            total = total + size;
            this.numInserted.put(id, total);
        }
        if (size == 0) {
            return;
        }
        int[] nArray = new int[size];
        int start = 0;
        try {
            while (true) {
                int[] lcounts;
                try {
                    lcounts = URLTable.getInstance(id).add(list, start);
                    if (start == 0) {
                        int[] nArray2 = lcounts;
                    } else if (lcounts.length + start <= nArray.length) {
                        System.arraycopy(lcounts, 0, nArray, start, lcounts.length);
                    }
                }
                catch (BatchUpdateException bue) {
                    if (bue.getErrorCode() == 30000) {
                        lcounts = bue.getUpdateCounts();
                        if (lcounts.length + start <= nArray.length) {
                            System.arraycopy(lcounts, 0, nArray, start, lcounts.length);
                        }
                        nArray[lcounts.length] = -3;
                        if ((start += lcounts.length + 1) < lcounts.length) {
                            if (!tracer.isLoggable(Level.FINE)) continue;
                            tracer.fine("Dupplicated key was found skip it and retry. " + start + " " + nArray.length);
                            continue;
                        }
                    } else if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "Insert into table " + bue.getErrorCode(), bue);
                    }
                }
                break;
            }
        }
        catch (SQLException se) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "Insert into table " + se.getErrorCode(), se);
            }
            return;
        }
        ArrayList<WCRequest> fails = null;
        for (int j = 0; j < ((void)var7_12).length; ++j) {
            if (var7_12[j] != -3) continue;
            if (fails == null) {
                fails = new ArrayList<WCRequest>();
            }
            fails.add(list.get(j));
        }
        int n = nFailed = fails == null ? 0 : fails.size();
        if (nFailed == 0) {
            return;
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Failed count is " + nFailed);
        }
        if (tracer.isLoggable(Level.FINEST)) {
            for (WCRequest wcRequest3 : fails) {
                InsertRequest request = (InsertRequest)wcRequest3;
                tracer.finest("Insert-URL " + request.m_urlString + " failed");
            }
        }
    }

    public static URLInserter instance() {
        return s_instance;
    }

    private URLInserter() {
        super(s_agent);
        this.setQueueSizes(200);
        this.setQueueTimeoutSec(1);
        this.setHardLimit(20000);
    }

    public int getNumInserted(String id) {
        Integer total = this.numInserted.get(id);
        return total != null ? total : 0;
    }

    @Override
    protected synchronized void doDBOperation(String id, List<WCRequest> list) throws Exception {
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("insert url is called for " + id);
        }
        this._insertURLs(id, list);
    }
}

