/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.crawler.web.db.DBConnectionManager;
import com.ibm.es.nuvo.crawler.web.error.GenericException;
import com.ibm.es.nuvo.crawler.web.error.NoValueException;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.logging.Level;

public class DBTableOperator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + DBTableOperator.class.getName());
    public static final String TABLE_BUCKET = "BUCKET";
    public static final String TABLE_ROBOTS = "ROBOTS";
    public static final String TABLE_IP = "IP";
    public static final String TABLE_URL = "URL";
    public static final String TABLE_ARCHIVEDATA = "ARCHIVEDATA";
    private static final String[] TABLES = new String[]{"BUCKET", "ROBOTS", "IP", "URL", "ARCHIVEDATA", "COOKIE"};
    private static DBTableOperator instance;
    private static final String SQL_FILE = "web_cs.sql";

    public static synchronized DBTableOperator instance() {
        if (instance == null) {
            instance = new DBTableOperator();
        }
        return instance;
    }

    public void checkTables(String id, String dbPath) throws WCException {
        DBConnectionManager.instance().putDBPath(id, dbPath);
        this.checkTables(id);
    }

    public void checkTables(String id) throws WCException {
        try {
            String schemaName = "whitney";
            if (!this._existTable(id, schemaName)) {
                this._executeSQL(id, SQL_FILE, schemaName, true);
            }
        }
        catch (SQLException e) {
            ExtendedException exception = new ExtendedException("C3502E.DB_OP_CHECK", (Throwable)e);
            logger.log(Level.SEVERE, exception);
            GenericException wce = new GenericException("Failed to check tables " + id, (Throwable)e);
            throw wce;
        }
        catch (NoValueException ignored) {
        }
        catch (WCException e) {
            logger.log(Level.FINE, "Failed to check tables " + id);
            GenericException wce = new GenericException("Failed to check tables " + id, (Throwable)e);
            throw wce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _existTable(String id, String schema) throws SQLException, WCException {
        DBConnection dbc = null;
        try {
            dbc = DBConnectionManager.instance().createConnection(id);
            for (String tableName : TABLES) {
                Connection connection = dbc.getConnection();
                DatabaseMetaData metadata = connection.getMetaData();
                String[] tableTypes = new String[]{"TABLE"};
                ResultSet rs = null;
                try {
                    rs = metadata.getTables(connection.getCatalog(), schema.toUpperCase(), tableName.toUpperCase(), tableTypes);
                    boolean hasTable = rs.next();
                    if (!hasTable) {
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException ignored) {}
                    }
                }
                rs = null;
            }
        }
        finally {
            if (dbc != null) {
                dbc.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _executeSQL(String id, String filename, String schemaName, boolean force) throws SQLException, WCException {
        InputStream is = DBTableOperator.class.getResourceAsStream(filename);
        if (is == null) {
            throw new RuntimeException("Could not read sql : " + filename);
        }
        DBConnection dbc = null;
        try {
            DBConnection dBConnection = dbc = DBConnectionManager.instance().createConnection(id);
            synchronized (dBConnection) {
                Statement stmt = null;
                try {
                    InputStreamReader isr = new InputStreamReader(is);
                    stmt = dbc.createStatement();
                    try {
                        BufferedReader br = new BufferedReader(isr);
                        try {
                            String line;
                            StringBuilder sql = new StringBuilder(256);
                            while ((line = br.readLine()) != null) {
                                block27: {
                                    if ((line = line.trim()).startsWith("--")) continue;
                                    line = MessageFormat.format(line, schemaName);
                                    sql.append(line);
                                    if (!line.trim().endsWith(";")) continue;
                                    sql.deleteCharAt(sql.length() - 1);
                                    try {
                                        SQLWarning warnings;
                                        if (tracer.isLoggable(Level.FINER)) {
                                            tracer.finer(sql.toString());
                                        }
                                        boolean ret = stmt.execute(sql.toString());
                                        if (tracer.isLoggable(Level.FINER)) {
                                            tracer.finer("ret " + ret);
                                        }
                                        if ((warnings = stmt.getWarnings()) != null) {
                                            tracer.fine(warnings.toString());
                                        }
                                    }
                                    catch (SQLException e) {
                                        if (tracer.isLoggable(Level.FINE)) {
                                            tracer.log(Level.FINE, "DB Operation" + e.getMessage());
                                        }
                                        if (force) break block27;
                                        GenericException wce = new GenericException("failed to _executeSQL", (Throwable)e);
                                        throw wce;
                                    }
                                }
                                sql.setLength(0);
                            }
                        }
                        finally {
                            br.close();
                        }
                    }
                    finally {
                        isr.close();
                    }
                    stmt.close();
                    stmt = null;
                }
                catch (IOException e) {
                    GenericException wce = new GenericException("failed to _executeSQL", (Throwable)e);
                    throw wce;
                }
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            if (dbc != null) {
                dbc.close();
            }
        }
    }
}

