/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db;

import com.ibm.es.nuvo.crawler.web.error.ArgCheck;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBStatement {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int S_UPDATABLE = 1;
    String query;
    PreparedStatement preparedStatement;

    public DBStatement(PreparedStatement statement) throws WCException {
        ArgCheck.notNull("statement", statement);
        this.query = "";
        this.preparedStatement = statement;
    }

    public void addBatch() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.addBatch();
        }
    }

    public void clearBatch() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.clearBatch();
        }
    }

    public void close() throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.close();
        }
    }

    public int[] executeBatch() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.executeBatch();
        }
        return null;
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.executeQuery();
        }
        return null;
    }

    public int executeUpdate() throws SQLException {
        if (this.preparedStatement != null) {
            return this.preparedStatement.executeUpdate();
        }
        return 0;
    }

    public void setBlob(int index, Blob arg) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setBlob(index, arg);
        }
    }

    public void setBlobNull(int index) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setNull(index, 2004);
        }
    }

    public void setBytes(int index, byte[] arg) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setBytes(index, arg);
        }
    }

    public void setBytesNull(int index) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setNull(index, -3);
        }
    }

    public void setInt(int index, int arg) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setInt(index, arg);
        }
    }

    public void setIntNull(int index) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setNull(index, 4);
        }
    }

    public void setLong(int index, long arg) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setLong(index, arg);
        }
    }

    public void setLongNull(int index) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setNull(index, -5);
        }
    }

    public void setShort(int index, short arg) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setShort(index, arg);
        }
    }

    public void setShortNull(int index) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setNull(index, 5);
        }
    }

    public void setString(int index, String arg) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setString(index, arg);
        }
    }

    public void setMaxRows(int rows) throws SQLException {
        if (this.preparedStatement != null) {
            this.preparedStatement.setMaxRows(rows);
        }
    }

    public String toString() {
        return this.query;
    }
}

