/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.crawler.web.db.DBConnection;
import com.ibm.es.nuvo.crawler.web.db.DBShutdownListener;
import com.ibm.es.nuvo.crawler.web.error.ArgCheck;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.FileUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBConnectionManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + DBConnectionManager.class.getName());
    private boolean initialized;
    private static final boolean EMBEDDED_DB = true;
    public static final String SCHEMA_NAME = "whitney";
    private Map<String, List<DBShutdownListener>> shutdownListeners = new HashMap<String, List<DBShutdownListener>>();
    private Map<String, String> dbPath = new HashMap<String, String>();
    private Map<String, String> idMap = new HashMap<String, String>();
    private Map<String, Integer> refCount = new HashMap<String, Integer>();
    private Map<String, TimerTask> shutdownTasks = new HashMap<String, TimerTask>();
    private static DBConnectionManager s_instance = new DBConnectionManager();

    public static synchronized DBConnectionManager instance() {
        return s_instance;
    }

    private DBConnectionManager() {
    }

    public DBConnection createConnection(String name) throws WCException {
        DBConnection dbc = new DBConnection(name);
        return dbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnection(String name) {
        Map<String, Integer> map = this.refCount;
        synchronized (map) {
            Integer count = this.refCount.get(name);
            if (count != null) {
                Object object = count;
                Integer n = count = Integer.valueOf(count - 1);
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Refer- " + name + " " + count);
                }
                this.refCount.put(name, count);
                if (count == 0) {
                    object = this.shutdownTasks;
                    synchronized (object) {
                        if (!this.shutdownTasks.containsKey(name)) {
                            ShutdownTask task = new ShutdownTask(name);
                            this.shutdownTasks.put(name, task);
                            WebCrawler.schedule(task, 1000L, 1000L);
                        }
                    }
                }
            }
        }
    }

    Connection makeConnection(String name) throws WCException {
        Connection connection = this.getConnection(name);
        ArgCheck.notNull("conneciton", connection);
        return connection;
    }

    public void init() throws Exception {
        this.loadJDBCDrivers();
    }

    private synchronized Connection getConnection(String name) {
        Connection connection = this.getConnection(name, false);
        if (connection == null) {
            connection = this.getConnection(name, true);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Connection getConnection(String name, boolean create) {
        this.loadJDBCDrivers();
        Map<String, TimerTask> map = this.shutdownTasks;
        synchronized (map) {
            TimerTask task = this.shutdownTasks.remove(name);
            if (task != null) {
                task.cancel();
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Shutdown canceled " + name);
                }
            }
        }
        String url = this.getURL(name, ";create=" + create);
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("driver url:" + url);
        }
        Connection connection = null;
        Map<String, Integer> map2 = this.refCount;
        synchronized (map2) {
            try {
                connection = DriverManager.getConnection(url);
            }
            catch (SQLWarning ignored) {
            }
            catch (SQLException sqle) {
                while (sqle != null && create) {
                    Message message = new Message("C3500E.DB_CONN_CREATE", this.dbPath.get(name), name);
                    ExtendedException exception = new ExtendedException(message, (Throwable)sqle);
                    logger.log(Level.SEVERE, exception);
                    if (tracer.isLoggable(Level.FINE)) {
                        Throwable cause;
                        tracer.log(Level.FINE, url, sqle);
                        while ((cause = sqle.getCause()) != null) {
                            tracer.log(Level.FINE, "caused by", cause);
                        }
                        while ((cause = sqle.getNextException()) != null) {
                            tracer.log(Level.FINE, "caused by", cause);
                        }
                    }
                    sqle = sqle.getNextException();
                }
                connection = null;
            }
            if (connection != null) {
                Integer count = this.refCount.get(name);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                if (tracer.isLoggable(Level.FINER)) {
                    tracer.finer("Refer+ " + name + " " + count);
                }
                this.refCount.put(name, count);
            }
        }
        return connection;
    }

    private String getURL(String name, String option) {
        String path = name == null ? "" : this.dbPath.get(name);
        String url = "jdbc:derby:" + path + option + ";";
        return url;
    }

    private void loadJDBCDrivers() {
        if (this.initialized) {
            return;
        }
        String driver = "org.apache.derby.jdbc.EmbeddedDriver";
        try {
            Class.forName(driver);
            this.initialized = true;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "C4803E.DB_LOAD_DRIVER_FAIL", new Object[]{driver});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(String id) {
        String url = this.getURL(id, ";shutdown=true");
        if (id == null) {
            this.initialized = false;
        }
        List<DBShutdownListener> listeners = this.getShutdownListeners(id);
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("Shutdown db " + id);
        }
        List<DBShutdownListener> list = listeners;
        synchronized (list) {
            block10: {
                try {
                    Connection c = DriverManager.getConnection(url);
                    if (c == null) break block10;
                    c.close();
                }
                catch (SQLException sqle) {
                    while (sqle != null) {
                        if (tracer.isLoggable(Level.FINE)) {
                            tracer.log(Level.FINE, "Shutdown " + url + "  " + sqle.getMessage());
                        }
                        sqle = sqle.getNextException();
                    }
                }
            }
            for (DBShutdownListener listener : listeners) {
                listener.shutdownCompleted();
            }
            listeners.clear();
        }
    }

    public void drop(String id) throws ExtendedException {
        String path = this.dbPath.get(id);
        int retry = 60;
        Vector<String> list = null;
        if (path != null) {
            File target = new File(path);
            while (retry-- > 0 && (list = FileUtils.removeDirectory(target)).size() != 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {}
            }
        }
        if (list != null && list.size() > 0) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "DB is not clean remove manually. " + path + " " + list);
            }
            Message message = new Message("C4936W.DROP_FILE_LEFT");
            message.addArgument(path);
            throw new ExtendedException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownListener(String id, DBShutdownListener listener) {
        List<DBShutdownListener> list;
        List<DBShutdownListener> list2 = list = this.getShutdownListeners(id);
        synchronized (list2) {
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBShutdownListener> getShutdownListeners(String id) {
        List<DBShutdownListener> list = this.shutdownListeners.get(id);
        if (list == null) {
            Map<String, List<DBShutdownListener>> map = this.shutdownListeners;
            synchronized (map) {
                list = this.shutdownListeners.get(id);
                if (list == null) {
                    list = new ArrayList<DBShutdownListener>();
                    this.shutdownListeners.put(id, list);
                }
            }
        }
        return list;
    }

    public void putDBPath(String id, String db) {
        this.dbPath.put(id, db);
    }

    public boolean available(String id) {
        return this.dbPath.containsKey(id);
    }

    public void setCollectionID(String collectionId, String crawlerId) {
        this.idMap.put(crawlerId, collectionId);
    }

    public String getCollectionID(String crawlerId) {
        return this.idMap.get(crawlerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveDB(String name) {
        Map<String, Integer> map = this.refCount;
        synchronized (map) {
            return this.refCount.containsKey(name);
        }
    }

    private class ShutdownTask
    extends TimerTask {
        private String id;

        public ShutdownTask(String id) {
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = DBConnectionManager.this.refCount;
            synchronized (map) {
                Integer count = (Integer)DBConnectionManager.this.refCount.get(this.id);
                if (count != null && count > 0) {
                    if (tracer.isLoggable(Level.FINER)) {
                        tracer.finer("Shutdown for " + this.id + " is canceled");
                    }
                    return;
                }
                try {
                    if (tracer.isLoggable(Level.FINER)) {
                        tracer.finer("Shutdown " + this.id);
                    }
                    DBConnectionManager.this.shutdown(this.id);
                    DBConnectionManager.this.refCount.remove(this.id);
                }
                finally {
                    this.cancel();
                }
            }
        }
    }
}

