/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db;

import com.ibm.es.nuvo.crawler.web.db.DBConnectionManager;
import com.ibm.es.nuvo.crawler.web.error.ArgCheck;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Level;

public class DBConnection {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + DBConnection.class.getName());
    private String id;
    private Connection connection;

    DBConnection(String name) throws WCException {
        this.id = name;
        this.connection = DBConnectionManager.instance().makeConnection(name);
    }

    public void close() throws SQLException {
        if (this.connection != null && !this.isClosed()) {
            this.connection.close();
            DBConnectionManager.instance().closeConnection(this.id);
        }
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.isClosed()) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.isClosed()) {
            this.connection.rollback();
        }
    }

    public void setAutoCommit(boolean yn) throws SQLException {
        if (this.connection != null && !this.isClosed()) {
            this.connection.setAutoCommit(yn);
        }
    }

    Connection getConnection() {
        return this.connection;
    }

    public PreparedStatement prepareStatement(String query) throws WCException, SQLException {
        ArgCheck.notNull("sql", query);
        ArgCheck.notNull("connection", this.connection);
        query = this.getQuery(query);
        PreparedStatement preparedStatement = this.connection.prepareStatement(query);
        SQLWarning warnings = preparedStatement.getWarnings();
        if (warnings != null && tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "The SQL statement cannot be prepared. An SQL statement is a command for the database where crawled documents are stored.", warnings);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatementForUpdate(String query) throws WCException, SQLException {
        ArgCheck.notNull("sql", query);
        ArgCheck.notNull("connection", this.connection);
        query = this.getQuery(query);
        PreparedStatement preparedStatement = this.connection.prepareStatement(query, 1003, 1008);
        SQLWarning warnings = preparedStatement.getWarnings();
        if (warnings != null && tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "The SQL statement cannot be prepared. An SQL statement is a command for the database where crawled documents are stored.", warnings);
        }
        return preparedStatement;
    }

    private String getQuery(String macroQuery) throws WCException {
        ArgCheck.notNull("sql", macroQuery);
        String query = macroQuery.replaceAll("%s", "whitney");
        if (tracer.isLoggable(Level.FINEST)) {
            tracer.finest(query);
        }
        return query;
    }

    public Statement createStatement() throws WCException, SQLException {
        ArgCheck.notNull("connection", this.connection);
        return this.connection.createStatement();
    }
}

