/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.util.hash.HashableDataBufferOutputStream;
import com.ibm.es.nuvo.crawler.web.admin.WCMonitor;
import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.http.HTTPCategory;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.net.InvalidURLException;
import com.ibm.es.nuvo.crawler.web.parser.doc.Field;
import com.ibm.es.nuvo.crawler.web.parser.html.stream.MetaHandler;
import com.ibm.es.nuvo.crawler.web.rule.WebSpace;
import com.ibm.es.nuvo.crawler.web.rule.WildcardRule;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlRec {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static ExtendedLogger logger = Loggers.logger;
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + CrawlRec.class.getName());
    private CrawlSpaceConfig config;
    private boolean verified;
    private Properties headerProperties;
    private boolean rss;
    private boolean html;
    private String knownCharset;
    private int m_depth;
    private CURL m_url;
    private CURL m_baseURL;
    private CURL m_redirectURL;
    private CURL m_downstreamURL;
    private InetSocketAddress m_inetSocketAddress;
    private String httpProxyAuth;
    private Integer m_creationDate;
    private Integer m_crawlDate;
    private Integer crawlIntervalSec;
    private Short m_newHTTPStatus = 0;
    private Short m_oldHTTPStatus = 0;
    private Short m_httpStatusCount = 1;
    private Integer m_newFingerprint;
    private Integer m_oldFingerprint;
    private HashableDataBufferOutputStream binaryContent;
    private String m_httpBasicAuthACLString;
    private boolean m_truncated;
    private boolean m_compressed;
    private String m_contentTypeLC;
    private String m_encoding = "ISO8859-1";
    private List<CURL> m_outLinks;
    private StringBuffer m_securityACLs;
    private boolean m_noIndex;
    private boolean m_noFollow;
    private String m_contentLanguage = "en";
    private int m_serverDate;
    private int m_expirationDate;
    private int m_lastModifiedDate;
    private String m_serverID;
    private boolean m_writeRDS = true;
    private boolean m_updateURL = true;
    private ArrayList<Field> m_metadataFields = new ArrayList();
    private long longHash;
    private static Pattern expandSectionRegex = Pattern.compile("\\.nsf.*\\&expandsection=", 2);
    private static WildcardRule expandSectionPattern = WildcardRule.compile("*.nsf*&expandsection=*", false, false);
    private Bucket m_bucket;
    private boolean m_setFetchStarting;
    private boolean m_setFetchEnding;
    private long m_dateOfCommonMeta;

    public String toString() {
        return this.m_url.toString();
    }

    public int getDepth() {
        return this.m_depth;
    }

    public void setDepth(int depth) {
        this.m_depth = depth;
    }

    public void setURL(CURL url) {
        this.m_url = url;
    }

    public CURL getURL() {
        return this.m_url;
    }

    public void setBaseURL(CURL url) {
        this.m_baseURL = url;
    }

    public CURL getBaseURL() {
        return this.m_baseURL;
    }

    public void setRedirectURL(CURL redirectURL) {
        if (redirectURL == null || !this.m_url.toString().equals(redirectURL.toString()) && redirectURL.isValid()) {
            this.m_redirectURL = redirectURL;
        }
    }

    public CURL getRedirectURL() {
        return this.m_redirectURL;
    }

    public void setDownstreamURL(CURL downstreamURL) {
        if (downstreamURL == null || downstreamURL.isValid()) {
            this.m_downstreamURL = downstreamURL;
        }
    }

    public CURL getDownstreamURL() {
        return this.m_downstreamURL;
    }

    public void setInetSocketAddress(InetSocketAddress inetSocketAddress) {
        this.m_inetSocketAddress = inetSocketAddress;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.m_inetSocketAddress;
    }

    public void setProxyAuth(String credential) {
        this.httpProxyAuth = credential;
    }

    public String getProxyAuth() {
        return this.httpProxyAuth;
    }

    public void setCreationDate(int creationDateUT) {
        this.m_creationDate = creationDateUT;
    }

    public void setCreationDate(int creationDateUT, boolean wasNull) {
        this.m_creationDate = wasNull ? null : Integer.valueOf(creationDateUT);
    }

    public int getCreationDate() {
        return this.m_creationDate == null ? 0 : this.m_creationDate;
    }

    public void setCrawlDate(int crawlDateUT) {
        this.m_crawlDate = crawlDateUT;
    }

    public void setCrawlDate(int crawlDateUT, boolean wasNull) {
        this.m_crawlDate = wasNull ? null : Integer.valueOf(crawlDateUT);
    }

    public int getCrawlDate() {
        return this.m_crawlDate == null ? 0 : this.m_crawlDate;
    }

    public void setCrawlIntervalSec(int oldCrawlIntervalSec) {
        this.crawlIntervalSec = oldCrawlIntervalSec;
    }

    public void setCrawlIntervalSec(int crawlIntervalSec, boolean wasNull) {
        this.crawlIntervalSec = wasNull ? null : Integer.valueOf(crawlIntervalSec);
    }

    public int getCrawlIntervalSec() {
        return this.crawlIntervalSec == null ? 0 : this.crawlIntervalSec;
    }

    public void setNewHTTPStatus(int httpStatus) {
        this.m_newHTTPStatus = (short)httpStatus;
    }

    public short getNewHTTPStatus() {
        return this.m_newHTTPStatus == null ? (short)0 : this.m_newHTTPStatus;
    }

    public void setOldHTTPStatus(int httpStatus) {
        this.m_oldHTTPStatus = (short)httpStatus;
    }

    public void setOldHTTPStatus(int httpStatus, boolean wasNull) {
        this.m_oldHTTPStatus = wasNull ? null : Short.valueOf((short)httpStatus);
    }

    public short getOldHTTPStatus() {
        return this.m_oldHTTPStatus == null ? (short)0 : this.m_oldHTTPStatus;
    }

    public void setHTTPStatusCount(int httpStatusCount) {
        this.m_httpStatusCount = (short)httpStatusCount;
    }

    public void setHTTPStatusCount(int httpStatusCount, boolean wasNull) {
        this.m_httpStatusCount = wasNull ? null : Short.valueOf((short)httpStatusCount);
    }

    public short getHTTPStatusCount() {
        return this.m_httpStatusCount == null ? (short)0 : this.m_httpStatusCount;
    }

    public void setNewFingerprint(int fingerprint) {
        this.m_newFingerprint = fingerprint;
    }

    public void setNewFingerprint(int fingerprint, boolean wasNull) {
        this.m_newFingerprint = wasNull ? null : Integer.valueOf(fingerprint);
    }

    public int getNewFingerprint() {
        return this.m_newFingerprint == null ? 0 : this.m_newFingerprint;
    }

    public void setOldFingerprint(int fingerprint) {
        this.m_oldFingerprint = fingerprint;
    }

    public void setOldFingerprint(int fingerprint, boolean wasNull) {
        this.m_oldFingerprint = wasNull ? null : Integer.valueOf(fingerprint);
    }

    public int getOldFingerprint() {
        return this.m_oldFingerprint == null ? 0 : this.m_oldFingerprint;
    }

    public void setContent(HashableDataBufferOutputStream data) {
        this.binaryContent = data;
        if (data != null) {
            this.longHash = this.binaryContent.getHash();
        }
    }

    public HashableDataBufferOutputStream getContent() {
        return this.binaryContent;
    }

    public void setHTTPBasicAuthACLString(String httpBasicAuthACLString) {
        this.m_httpBasicAuthACLString = httpBasicAuthACLString;
    }

    public String getHTTPBasicAuthACLString() {
        return this.m_httpBasicAuthACLString;
    }

    public void setTruncated(boolean truncated) {
        this.m_truncated = truncated;
    }

    public boolean isTruncated() {
        return this.m_truncated;
    }

    public void setCompressed(boolean compressed) {
        this.m_compressed = compressed;
    }

    public boolean isCompressed() {
        return this.m_compressed;
    }

    public void setContentTypeLC(String contentType) {
        this.m_contentTypeLC = contentType == null ? null : contentType.toLowerCase();
    }

    public String getContentTypeLC() {
        return this.m_contentTypeLC;
    }

    public void setEncoding(String encoding) {
        if (encoding != null) {
            this.m_encoding = encoding;
        }
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setOutLinks(List<?> outLinks) {
        CURL base = this.m_baseURL;
        if (base == null || !base.isValid()) {
            base = this.m_url;
        }
        if ((base == null || !base.isValid()) && tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, new InvalidURLException("base", base.toString(), this.m_url).toString());
        }
        ArrayList<CURL> newList = new ArrayList<CURL>();
        if (outLinks != null) {
            for (Object o : outLinks) {
                if (o == null) continue;
                CURL curl = null;
                if (o instanceof String) {
                    String urlSpec = (String)o;
                    curl = new CURL(urlSpec);
                    if (!curl.isValid() && curl.mayBeRelative() && base.isValid()) {
                        curl = new CURL(base, urlSpec);
                    }
                } else {
                    curl = (CURL)o;
                }
                if (curl.isValid()) {
                    newList.add(curl);
                    continue;
                }
                if (!tracer.isLoggable(Level.FINE)) continue;
                tracer.log(Level.FINE, new InvalidURLException("doc outlink", curl, this.m_url.toString()).toString());
            }
        }
        this.m_outLinks = newList;
    }

    public List<CURL> getOutLinks() {
        return this.m_outLinks;
    }

    public void addSecurityACLs(String csl) {
        if (csl == null || csl.length() == 0) {
            return;
        }
        String[] sa = csl.split("[, \t]+", -1);
        if (sa == null || sa.length == 0) {
            return;
        }
        for (int j = 0; j < sa.length; ++j) {
            if (sa[j] == null) continue;
            sa[j] = sa[j].trim();
            if (sa[j] == null || sa[j].length() == 0) continue;
            if (this.m_securityACLs == null) {
                this.m_securityACLs = new StringBuffer();
            }
            if (this.m_securityACLs.length() > 0) {
                this.m_securityACLs.append(",");
            }
            this.m_securityACLs.append(sa[j]);
        }
    }

    public String getSecurityACLs() {
        return this.m_securityACLs == null ? null : this.m_securityACLs.toString();
    }

    public void setSecurityACLs(String acl) {
        this.m_securityACLs = null;
        this.addSecurityACLs(acl);
    }

    public void setNoIndex(boolean noIndex) {
        this.m_noIndex = noIndex;
    }

    public boolean isNoIndex() {
        return this.m_noIndex;
    }

    public void setNoFollow(boolean noFollow) {
        this.m_noFollow = noFollow;
    }

    public boolean isNoFollow() {
        return this.m_noFollow;
    }

    public void setContentLanguage(String contentLanguage) {
        this.m_contentLanguage = contentLanguage;
    }

    public String getContentLanguage() {
        return this.m_contentLanguage;
    }

    public void setServerDate(String serverDate) {
        this.m_serverDate = this._parseDateString(serverDate);
    }

    public int getServerDate() {
        return this.m_serverDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.m_expirationDate = this._parseDateString(expirationDate);
    }

    public int getExpirationDate() {
        return this.m_expirationDate;
    }

    public void setLastModifiedDate(String lastModifiedDate) {
        this.m_lastModifiedDate = this._parseDateString(lastModifiedDate);
    }

    public void setLastModifiedDate(int lastModifiedDate) {
        this.m_lastModifiedDate = lastModifiedDate;
    }

    public int getLastModifiedDate() {
        return this.m_lastModifiedDate;
    }

    private int _parseDateString(String s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        Date d = MetaHandler.parseDate(s);
        if (d != null) {
            return (int)(d.getTime() / 1000L);
        }
        return 0;
    }

    public void setServerID(String serverID) {
        this.m_serverID = serverID;
    }

    public String getServerID() {
        return this.m_serverID;
    }

    public void setWriteRDS(boolean writeRDS) {
        this.m_writeRDS = writeRDS;
    }

    public boolean doWriteRDS() {
        return this.m_writeRDS;
    }

    public void setUpdateURL(boolean updateURL) {
        this.m_updateURL = updateURL;
    }

    public boolean doUpdateURL() {
        return this.m_updateURL;
    }

    public List<Field> getMetadataFields() {
        return this.m_metadataFields;
    }

    public void setMetadataFields(List<Field> list) {
        this.m_metadataFields.clear();
        this.m_metadataFields.addAll(list);
    }

    public void handleDownloadException(WCException wce) {
        if (wce == null) {
            return;
        }
        for (Throwable t = wce.getCause(); t != null; t = t.getCause()) {
            if (t instanceof SocketTimeoutException) {
                this.setNewHTTPStatus(613);
                return;
            }
            if (t instanceof ConnectException) {
                this.setNewHTTPStatus(612);
                return;
            }
            if (t instanceof SocketException) {
                this.setNewHTTPStatus(611);
                return;
            }
            if (t instanceof SSLException) {
                this.setNewHTTPStatus(614);
                return;
            }
            if (!(t instanceof WCException)) {
                if (!tracer.isLoggable(Level.FINE)) break;
                tracer.log(Level.FINE, "handleDownloadException", wce);
                break;
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            Message message = new Message("C5021I.UNKNOWN_DOWNLOAD_ERROR", this.m_url.toString());
            ExtendedException exception = new ExtendedException(message, (Throwable)wce);
            logger.log(Level.INFO, exception);
        }
        this.setNewHTTPStatus(615);
    }

    public void metadataProcessing() {
        CURL u;
        if (this.getNewHTTPStatus() == 200) {
            if (this.m_redirectURL != null) {
                this.setNewHTTPStatus(3020);
            } else if (this.isNoIndex()) {
                this.setNewHTTPStatus(2004);
            }
        }
        if (HTTPCategory.redirect(this.getNewHTTPStatus()) && this.m_redirectURL == null) {
            this.setNewHTTPStatus(618);
            this.m_writeRDS = false;
        }
        if (expandSectionPattern.matches(this.m_url.toString())) {
            Matcher m = expandSectionRegex.matcher(this.m_url.toString());
            if (m.find() && m.end() - 15 > 0) {
                this.setDownstreamURL(new CURL(this.m_url.toString().substring(0, m.end() - 15)));
            }
            m = null;
        }
        if (this.binaryContent != null) {
            int ihash = (int)(this.longHash & 0xFFFFFFFFFFFFFFFFL ^ this.longHash >> 32 & 0xFFFFFFFFFFFFFFFFL);
            this.setNewFingerprint(ihash);
        }
        if (HTTPCategory.serverOrConnectionProblem(this.getNewHTTPStatus()) && !HTTPCategory.serverOrConnectionProblem(this.getOldHTTPStatus())) {
            this.setNewFingerprint(this.getOldFingerprint());
            this.m_writeRDS = false;
        }
        if ((u = this.m_downstreamURL) == null) {
            u = this.m_url;
        }
        if (u == null || !u.isValid()) {
            this.m_writeRDS = false;
        }
    }

    public boolean isProxied() {
        return this.m_bucket == null ? false : this.m_bucket.getProxyAddress() != null;
    }

    public void setBucket(Bucket bucket) {
        this.m_bucket = bucket;
        if (bucket != null) {
            this.config = this.m_bucket.getConfig();
            String proxyAuth = bucket.getProxyAuth();
            if (proxyAuth != null && proxyAuth.length() > 0) {
                this.setProxyAuth(proxyAuth);
            }
        }
    }

    public Bucket getBucket() {
        return this.m_bucket;
    }

    public WebSpace getWebSpace() {
        if (this.m_bucket == null) {
            return null;
        }
        return this.m_bucket.getConfig().getWebSpace();
    }

    public void deregister() {
        if (this.m_bucket != null) {
            if (!this.m_setFetchStarting) {
                this.m_bucket.fetchStarting();
            }
            if (!this.m_setFetchEnding) {
                this.m_bucket.fetchEnding();
            }
            this.m_bucket.deregisterCrawlRec(this);
        }
    }

    public void setFetching(boolean fetching) {
        if (this.m_bucket != null) {
            if (fetching) {
                if (!this.m_setFetchStarting) {
                    this.m_bucket.fetchStarting();
                    this.m_setFetchStarting = true;
                }
            } else if (!this.m_setFetchEnding) {
                this.m_bucket.fetchEnding();
                this.m_setFetchEnding = true;
            }
        }
    }

    public long getDateOfCommonMeta() {
        return this.m_dateOfCommonMeta;
    }

    public String getCrawlerId() {
        return this.config.getId();
    }

    public void recordCrawled() {
        WCMonitor.forName(this.config.getId()).recordRecentlyCrawledURL(this.m_url);
        if (!this.m_url.isRobots()) {
            this.getBucket().getManager().recordCrawled(this);
        }
    }

    public CrawlSpaceConfig getConfig() {
        return this.config;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public Properties getHeaderProperties() {
        return this.headerProperties;
    }

    public void setHeaderProperties(Properties headerProperties) {
        this.headerProperties = headerProperties;
    }

    public boolean isPersistent() {
        return this.m_bucket.getManager().isPersistent();
    }

    public boolean isRss() {
        return this.rss;
    }

    public void setRss(boolean rss) {
        this.rss = rss;
    }

    public boolean isHtml() {
        return this.html;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public void setConfig(CrawlSpaceConfig config) {
        this.config = config;
    }

    public String getKnownCharset() {
        return this.knownCharset;
    }

    public void setKnownCharset(String knownCharset) {
        if (knownCharset != null) {
            this.knownCharset = knownCharset;
            this.setEncoding(knownCharset);
        }
    }

    public void setLongHash(long longHash) {
        this.longHash = longHash;
    }

    public long getLongHash() {
        return this.longHash;
    }
}

