/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.db;

import com.ibm.es.nuvo.crawler.web.thread.WCQRunnableImpl;
import com.ibm.es.nuvo.crawler.web.util.WCRequest;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncDBOperator
extends WCQRunnableImpl {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + AsyncDBOperator.class.getName());
    private static final int MAX_WAIT = 1000;
    private AsyncTask asyncTask;
    private Thread wokerThread;
    private HashSet<WCRequest> readySet = new HashSet();
    private int hardLimit = 20000;
    private int flashInterval = 10;
    private List<WCRequest> waitingSet = new ArrayList<WCRequest>();
    private String asyncName;
    private long lastFlush;

    public AsyncDBOperator(String name) {
        this(name, name + "_DBOp");
    }

    public AsyncDBOperator(String name, String asyncName) {
        super(name);
        this.asyncName = asyncName;
    }

    @Override
    protected void _clientInit() throws Exception {
        this.asyncTask = new AsyncTask();
    }

    @Override
    protected void _clientStart() throws Exception {
        super._clientStart();
        this.wokerThread = new Thread((Runnable)this.asyncTask, this.asyncName);
        this.wokerThread.start();
    }

    @Override
    protected void _clientStop() throws Exception {
        this.flush();
        super._clientStop();
        if (this.wokerThread != null) {
            this.wokerThread.interrupt();
            this.wokerThread = null;
        }
    }

    public void flush() throws InterruptedException, Exception {
        this.lastFlush = 0L;
        this.flush(0);
    }

    @Override
    protected void _processTimeout() throws Exception {
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Timeout");
        }
        this.flush(0);
    }

    protected abstract void doDBOperation(String var1, List<WCRequest> var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void flush(int limit) throws InterruptedException, Exception {
        Throwable throwable;
        if (this.waitingSet.size() > limit || System.currentTimeMillis() - this.lastFlush > (long)(this.flashInterval * 1000)) {
            this.lastFlush = System.currentTimeMillis();
            boolean queued = false;
            Collection<WCRequest> collection = this.waitingSet;
            synchronized (collection) {
                if (this.waitingSet.size() > this.hardLimit && this.isWriting()) {
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.fine("Queue is too large waiting for flush." + this.waitingSet.size());
                    }
                    queued = true;
                }
            }
            if (queued) {
                collection = this.readySet;
                synchronized (collection) {
                    while (this.isWriting()) {
                        this.readySet.wait(100L);
                    }
                }
            }
            if (!this.isWriting()) {
                collection = this.readySet;
                synchronized (collection) {
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.fine("Inserting into readyUrls");
                    }
                    if (this.waitingSet.size() > 0) {
                        this.readySet.addAll(this.waitingSet);
                        this.waitingSet.clear();
                        this.readySet.notifyAll();
                    }
                }
            } else if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("Queue is operating. The list was not flushed ." + this.waitingSet.size());
            }
        } else if (tracer.isLoggable(Level.FINEST)) {
            tracer.finest("Not flushed.");
        }
        if (this.asyncTask != null && (throwable = this.asyncTask.getThrowable()) != null && tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "An unknown error occurred when the table was updated.", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWriting() {
        if (this.asyncTask != null) {
            AsyncTask asyncTask = this.asyncTask;
            synchronized (asyncTask) {
                return this.asyncTask.operating;
            }
        }
        return true;
    }

    protected int getHardLimit() {
        return this.hardLimit;
    }

    protected void setHardLimit(int hardLimit) {
        this.hardLimit = hardLimit;
    }

    protected List<WCRequest> getWaitingSet() {
        return this.waitingSet;
    }

    public void setFlashInterval(int flashInterval) {
        this.flashInterval = flashInterval;
    }

    public long getLastFlush() {
        return this.lastFlush;
    }

    public long countQueue(boolean waiting) {
        if (waiting) {
            return this.waitingSet.size();
        }
        return this.readySet.size();
    }

    private class AsyncTask
    implements Runnable {
        private Throwable throwable;
        private boolean operating;
        private Map<String, List<WCRequest>> requests = new HashMap<String, List<WCRequest>>();

        private AsyncTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            HashSet hashSet = AsyncDBOperator.this.readySet;
            // MONITORENTER : hashSet
            while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    // MONITOREXIT : hashSet
                    return;
                }
                try {
                    if (AsyncDBOperator.this.readySet.size() == 0) {
                        this.operating = false;
                        if (tracer.isLoggable(Level.FINEST)) {
                            tracer.fine("Waiting for ready.");
                        }
                        AsyncDBOperator.this.readySet.notifyAll();
                        AsyncDBOperator.this.readySet.wait(1000L);
                        continue;
                    }
                    this.operating = true;
                    if (tracer.isLoggable(Level.FINEST)) {
                        tracer.finest("Inserting readyUrls");
                    }
                    if (AsyncDBOperator.this.readySet.size() <= 0) continue;
                    ArrayList list = new ArrayList(AsyncDBOperator.this.readySet);
                    try {
                        AsyncDBOperator.this.readySet.clear();
                        for (WCRequest request : list) {
                            String crawlerId = request.getId();
                            List<WCRequest> l = this.requests.get(crawlerId);
                            if (l == null) {
                                l = new ArrayList<WCRequest>();
                                this.requests.put(crawlerId, l);
                            }
                            l.add(request);
                        }
                        for (String id : this.requests.keySet()) {
                            List<WCRequest> l = this.requests.get(id);
                            if (l.size() == 0) continue;
                            AsyncDBOperator.this.doDBOperation(id, l);
                            l.clear();
                        }
                        this.requests.clear();
                        continue;
                    }
                    finally {
                        list.clear();
                        list = null;
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable e) {
                    this.throwable = e;
                    continue;
                }
                break;
            }
        }

        private Throwable getThrowable() {
            return this.throwable;
        }
    }
}

