/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.data;

import java.util.regex.Pattern;

public class SimpleWildcardPattern {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String m_originalString;
    private boolean m_wild;
    private Pattern m_pattern;

    public SimpleWildcardPattern(String pat) {
        this.m_originalString = pat;
        boolean bl = this.m_wild = this.m_originalString.indexOf(42) >= 0;
        if (!this.m_wild) {
            return;
        }
        pat = pat.replaceAll("\\.", "\\\\.");
        pat = pat.replaceAll("\\*", ".*");
        this.m_pattern = Pattern.compile(pat);
    }

    public boolean matches(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() == 0) {
            return false;
        }
        if (!this.m_wild) {
            return s.equals(this.m_originalString);
        }
        return this.m_pattern.matcher(s).matches();
    }

    public String originalString() {
        return this.m_originalString;
    }

    public String toString() {
        return this.m_originalString;
    }

    public static void main(String[] args) {
        SimpleWildcardPattern p = new SimpleWildcardPattern("w3.ibm.com");
        System.out.println("Match (yes)? " + (p.matches("w3.ibm.com") ? "yes" : "no"));
        System.out.println("Match ( no)? " + (p.matches("w2.ibm.com") ? "yes" : "no"));
        System.out.println("Match ( no)? " + (p.matches("") ? "yes" : "no"));
        p = new SimpleWildcardPattern("*.ibm.com");
        System.out.println("Match (yes)? " + (p.matches("w3.ibm.com") ? "yes" : "no"));
        System.out.println("Match ( no)? " + (p.matches("w2.ibm.com") ? "yes" : "no"));
        System.out.println("Match ( no)? " + (p.matches("") ? "yes" : "no"));
    }
}

