/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.cookie;

import com.ibm.es.nuvo.crawler.util.hash.Hash32;
import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.parser.html.stream.MetaHandler;
import com.ibm.es.nuvo.crawler.web.util.UnixTime;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;

public class CookieEntry {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + CookieEntry.class.getName());
    private String name;
    private String value;
    private int expire;
    private String path;
    private String domain;
    private int version;
    private boolean secure;
    private boolean session;
    private int hash;
    private static final String[] TOP_DOMAINS = new String[]{"com", "edu", "net", "org", "gov", "mil", "int"};
    private static final HashSet<String> TOP_DOMAIN_SET = new HashSet();
    private static final SimpleDateFormat DATE_FORMAT;

    public static CookieEntry newEntry(CURL url, String cookieText) {
        if (url == null || cookieText == null) {
            return null;
        }
        int i = 0;
        int j = 0;
        String path = null;
        String domain = null;
        String cValue = null;
        String cName = null;
        int expires = 0;
        int version = 0;
        boolean secure = false;
        boolean valid = true;
        int length = cookieText.length();
        try {
            while (j >= 0) {
                i = cookieText.indexOf(59, j);
                int q = cookieText.indexOf(34, j);
                if ((q < i || i < 0) && q >= 0) {
                    if ((q = cookieText.indexOf(34, q + 1)) < 0) {
                        valid = false;
                        break;
                    }
                    i = cookieText.indexOf(59, q + 1);
                }
                if (length - 1 == i) break;
                String token = i < 0 ? cookieText.substring(j) : cookieText.substring(j, i);
                token = token.trim();
                j = i + 1;
                int k = token.indexOf(61);
                if (k < 0 || k == token.length() - 1) {
                    if (token.equalsIgnoreCase("secure")) {
                        secure = true;
                        if (j != 0) continue;
                        break;
                    }
                    valid = false;
                    break;
                }
                String name = token.substring(0, k).trim();
                String value = token.substring(k + 1).trim();
                if (!name.equalsIgnoreCase("comment")) {
                    if (name.equalsIgnoreCase("expires")) {
                        Date date = MetaHandler.parseDate(value = CookieEntry.trimQuote(value));
                        if (date != null) {
                            expires = (int)(date.getTime() / 1000L);
                            if (expires < 0) {
                                expires = (int)(System.currentTimeMillis() / 1000L + 60L);
                            }
                        } else if (tracer.isLoggable(Level.FINE)) {
                            tracer.log(Level.FINE, "C4914W.INVALID_COOKIE", new Object[]{"expire", value, url});
                        }
                    } else if (name.equalsIgnoreCase("path")) {
                        path = value;
                    } else if (name.equalsIgnoreCase("domain")) {
                        domain = value;
                    } else if (name.equalsIgnoreCase("max-age")) {
                        value = CookieEntry.trimQuote(value);
                        expires = Integer.parseInt(value) + UnixTime.now();
                    } else if (name.equalsIgnoreCase("version")) {
                        value = CookieEntry.trimQuote(value);
                        version = Integer.parseInt(value);
                    } else {
                        cName = name;
                        cValue = value;
                    }
                }
                if (j != 0) continue;
            }
            if (!valid) {
                return null;
            }
            return CookieEntry.newEntry(url, cName, cValue, expires, path, domain, version, secure, false);
        }
        catch (Exception e) {
            tracer.log(Level.FINE, "", e);
            return null;
        }
    }

    private static String trimQuote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static CookieEntry newEntry(CURL url, String name, String value, int expire, String path, String domain, int version, boolean secure) {
        return CookieEntry.newEntry(url, name, value, expire, path, domain, version, secure, false);
    }

    public static CookieEntry newEntry(CURL url, String name, String value, int expire, String path, String domain, int version, boolean secure, boolean validate) {
        int i;
        boolean session = false;
        if (url == null || !url.isValid() || name == null || value == null) {
            return null;
        }
        if (validate && path != null && !url.getPath().endsWith(path)) {
            return null;
        }
        if (path == null) {
            i = url.getPath().lastIndexOf("/");
            path = i < 0 ? "/" : url.getPath().substring(0, i);
        }
        if (domain != null) {
            if (validate && !url.getHostname().endsWith(domain)) {
                return null;
            }
            int last = 0;
            i = -1;
            int j = 0;
            while ((i = domain.indexOf(46, i + 1)) >= 0) {
                last = i + 1;
                ++j;
            }
            if (j < 1) {
                return null;
            }
            if (j == 1 && !TOP_DOMAIN_SET.contains(domain.substring(last).toLowerCase())) {
                return null;
            }
        } else {
            domain = url.getHostname();
        }
        if (expire == 0) {
            expire = UnixTime.now() + 31536000;
            session = true;
        }
        return new CookieEntry(name, value, expire, path, domain, secure, version, session);
    }

    private CookieEntry(String name, String value, int expire, String path, String domain, boolean secure, int version, boolean session) {
        this.name = name;
        this.value = value;
        this.expire = expire;
        this.path = path;
        this.domain = domain;
        this.secure = secure;
        this.version = version;
        this.session = session;
        this.hash = new Hash32(this.name + this.value + this.path + this.domain).intValue();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getExpire() {
        return this.expire;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public Hash64 getNameHash() {
        return new Hash64(this.path + "/" + this.name + "/" + this.domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        buffer.append("=");
        buffer.append(this.value);
        buffer.append(" ");
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            buffer.append(DATE_FORMAT.format(new Date((long)this.expire * 1000L)));
        }
        buffer.append(" ").append(this.path).append(" ").append(this.domain);
        buffer.append(" ").append(this.version);
        return buffer.toString();
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isSession() {
        return this.session;
    }

    public int hashCode() {
        return this.hash;
    }

    static {
        TOP_DOMAIN_SET.addAll(Arrays.asList(TOP_DOMAINS));
        DATE_FORMAT = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss Z", Locale.ENGLISH);
    }
}

