/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.validator;

import com.ibm.es.nuvo.crawler.framework.configuration.validator.HistoryEntry;
import com.ibm.es.nuvo.crawler.web.bucket.TmpBucketManager;
import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.configuration.validator.DNSValidator;
import com.ibm.es.nuvo.crawler.web.configuration.validator.ProxyValidator;
import com.ibm.es.nuvo.crawler.web.configuration.validator.RobotsValidator;
import com.ibm.es.nuvo.crawler.web.configuration.validator.RuleValidator;
import com.ibm.es.nuvo.crawler.web.configuration.validator.StartURLValidator;
import com.ibm.es.nuvo.crawler.web.configuration.validator.URLValidator;
import com.ibm.es.nuvo.crawler.web.configuration.validator.ValidatorBase;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCValidator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + WCValidator.class.getName());
    private CrawlerConfig global;
    private CrawlSpaceConfig space;
    private List<HistoryEntry<Type>> history = new ArrayList<HistoryEntry<Type>>();
    private List<String> startURLs = new ArrayList<String>();
    private TmpBucketManager manager;
    private boolean enableSuggestion;
    private boolean updated;
    private Map<String, String> realms = new HashMap<String, String>();

    public WCValidator(Properties config) {
        this.global = (CrawlerConfig)config.get("crawler.global.configured.object");
        this.space = (CrawlSpaceConfig)config.get("crawler.configured.object");
        try {
            this.manager = new TmpBucketManager(this.space);
        }
        catch (WCException ignored) {
            // empty catch block
        }
        if (this.space != null) {
            try {
                this.space.update();
            }
            catch (WCException wCException) {
                // empty catch block
            }
            this.startURLs.addAll(this.space.getStartURLs());
        }
    }

    public void validate(boolean suggestion) {
        block9: {
            if (suggestion) {
                this.enableSuggestion = true;
            }
            ArrayList<ValidatorBase> list = new ArrayList<ValidatorBase>();
            list.add(new URLValidator());
            RuleValidator rule = new RuleValidator();
            list.add(rule);
            list.add(new DNSValidator());
            list.add(new ProxyValidator());
            list.add(new RobotsValidator());
            list.add(new StartURLValidator());
            if (this.enableSuggestion) {
                list.add(rule);
            }
            int limit = 5;
            try {
                while (limit-- > 0) {
                    this.updated = false;
                    for (ValidatorBase validator : list) {
                        validator.validate(this);
                    }
                    if (this.updated && this.enableSuggestion) {
                        this.space.update();
                        this.global.update();
                        continue;
                    }
                    break;
                }
            }
            catch (WCException e) {
                if (!tracer.isLoggable(Level.FINE)) break block9;
                tracer.log(Level.FINE, "", e);
            }
        }
        if (suggestion) {
            HashSet<String> starts = new HashSet<String>();
            starts.addAll(this.space.getStartURLs());
            for (String url : this.startURLs) {
                if (starts.contains(url)) continue;
                this.space.addStartURL(url);
            }
        }
    }

    protected void addChanges(String key, String newValue, Type type) {
        this.history.add(new HistoryEntry<Type>(key, newValue, type, this.getLevel(type)));
    }

    public CrawlerConfig getGlobal() {
        return this.global;
    }

    public CrawlSpaceConfig getSpace() {
        return this.space;
    }

    public List<String> getStartURLs() {
        return this.startURLs;
    }

    public TmpBucketManager getManager() {
        return this.manager;
    }

    public boolean isEnableSuggestion() {
        return this.enableSuggestion;
    }

    public void setEnableSuggestion(boolean enableSuggestion) {
        this.enableSuggestion = enableSuggestion;
    }

    public void updated() {
        this.updated = true;
    }

    public List<HistoryEntry<Type>> getHistory() {
        return this.history;
    }

    Map<String, String> getRealms() {
        return this.realms;
    }

    public String getRealm(String url) {
        return this.realms.get(url);
    }

    protected Level getLevel(Type type) {
        switch (type) {
            case INVALID_URL: 
            case UNKNOWN_HOST: 
            case BAD_DNS: 
            case BAD_ROBOTS: 
            case ROBOTS_DISALLOW: 
            case PAGE_NOT_FOUND: 
            case BAD_PROXY: 
            case PROXY_AUTHENTICATION_REQUIRED: 
            case UNAUTHORIZED: 
            case UNSUPPORTED_DIGEST_AUTH: {
                return Level.SEVERE;
            }
            case EXCLUDE_DOMAIN: 
            case EXCLUDE_PREFIX: 
            case EXCLUDE_ADDRESS: 
            case EXCLUDE_SUFFIX: 
            case REDIRECTED: 
            case NO_LINK_FOUND: {
                return Level.WARNING;
            }
        }
        return Level.INFO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INVALID_URL,
        UNKNOWN_HOST,
        EXCLUDE_DOMAIN,
        EXCLUDE_PREFIX,
        NEW_DOMAIN,
        NEW_PREFIX,
        EXCLUDE_ADDRESS,
        EXCLUDE_SUFFIX,
        BAD_DNS,
        BAD_ROBOTS,
        ROBOTS_DISALLOW,
        REDIRECTED,
        PAGE_NOT_FOUND,
        NEW_START_URL,
        BAD_PROXY,
        PROXY_AUTHENTICATION_REQUIRED,
        NO_LINK_FOUND,
        UNAUTHORIZED,
        UNSUPPORTED_DIGEST_AUTH;

    }
}

