/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.validator;

import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.RuleConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.RuleEntry;
import com.ibm.es.nuvo.crawler.web.configuration.validator.ValidatorBase;
import com.ibm.es.nuvo.crawler.web.configuration.validator.WCValidator;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.rule.WebSpace;
import java.util.List;
import java.util.ListIterator;

class RuleValidator
extends ValidatorBase {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    RuleValidator() {
    }

    void validate(WCValidator validator) {
        List<String> startURLs = validator.getStartURLs();
        CrawlSpaceConfig space = validator.getSpace();
        RuleConfig rule = space.getRule();
        WebSpace webSpace = space.getWebSpace();
        ListIterator<String> itr = startURLs.listIterator();
        while (itr.hasNext()) {
            List<RuleEntry> rules;
            String url = itr.next();
            CURL curl = new CURL(url);
            String domain = curl.getHostname();
            boolean allow = webSpace.isAllowed(domain, curl.getProtocolNumber(), curl.getProtocolNumber());
            if (!allow) {
                if (validator.isEnableSuggestion()) {
                    rules = rule.getRules();
                    RuleEntry entry = new RuleEntry(RuleEntry.RuleType.DOMAIN, domain, true);
                    validator.addChanges("/Crawler/Rules/DomainRules/Rule", domain, WCValidator.Type.NEW_DOMAIN);
                    rules.add(0, entry);
                    try {
                        space.update();
                        webSpace = space.getWebSpace();
                    }
                    catch (WCException ignored) {
                        // empty catch block
                    }
                    validator.updated();
                    continue;
                }
                validator.addChanges("/Crawler/Rules/DomainRules/Rule", url, WCValidator.Type.EXCLUDE_DOMAIN);
                itr.remove();
                continue;
            }
            allow = webSpace.isAllowed(curl);
            if (!allow) {
                if (validator.isEnableSuggestion()) {
                    rules = rule.getRules();
                    String prefix = curl.getRootURLString() + "*";
                    RuleEntry entry = new RuleEntry(RuleEntry.RuleType.PREFIX, prefix, true);
                    rules.add(0, entry);
                    validator.addChanges("/Crawler/Rules/DomainRules/Rule", prefix, WCValidator.Type.NEW_PREFIX);
                    try {
                        space.update();
                        webSpace = space.getWebSpace();
                    }
                    catch (WCException ignored) {
                        // empty catch block
                    }
                    validator.updated();
                    continue;
                }
                validator.addChanges("/Crawler/Rules/DomainRules/Rule", url, WCValidator.Type.EXCLUDE_PREFIX);
                itr.remove();
                continue;
            }
            allow = !webSpace.isExcluded(curl);
            if (allow) continue;
            validator.addChanges("/Crawler/Rules/DomainRules/Rule", url, WCValidator.Type.EXCLUDE_SUFFIX);
            itr.remove();
        }
    }
}

