/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.validator;

import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.bucket.RobotsResolver;
import com.ibm.es.nuvo.crawler.web.bucket.TmpBucketManager;
import com.ibm.es.nuvo.crawler.web.configuration.validator.ValidatorBase;
import com.ibm.es.nuvo.crawler.web.configuration.validator.WCValidator;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

public class RobotsValidator
extends ValidatorBase {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    void validate(WCValidator validator) {
        TmpBucketManager manager = validator.getManager();
        List<String> startURLs = validator.getStartURLs();
        HashSet<Bucket> buckets = new HashSet<Bucket>();
        for (String url : startURLs) {
            Bucket bucket = manager.bucketForURL(new CURL(url));
            if (bucket == null) continue;
            buckets.add(bucket);
        }
        RobotsResolver resolver = RobotsResolver.instance();
        for (Bucket bucket : buckets) {
            resolver.downloadRobots(bucket);
        }
        ListIterator<String> itr = startURLs.listIterator();
        while (itr.hasNext()) {
            String url = itr.next();
            CURL curl = new CURL(url);
            Bucket bucket = manager.bucketForURL(curl);
            if (bucket == null) continue;
            if (bucket.getRobotsFailCount() > 0) {
                validator.addChanges("/Crawler/StartURLs/URL", url, WCValidator.Type.BAD_ROBOTS);
                itr.remove();
                continue;
            }
            if (!bucket.robotsExcludes(curl)) continue;
            validator.addChanges("/Crawler/StartURLs/URL", url, WCValidator.Type.ROBOTS_DISALLOW);
            itr.remove();
        }
    }
}

