/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.validator;

import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.bucket.TmpBucketManager;
import com.ibm.es.nuvo.crawler.web.config.HTTPProxy;
import com.ibm.es.nuvo.crawler.web.configuration.validator.ValidatorBase;
import com.ibm.es.nuvo.crawler.web.configuration.validator.WCValidator;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.http.Client;
import com.ibm.es.nuvo.crawler.web.http.HTTPCategory;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import java.util.List;

public class ProxyValidator
extends ValidatorBase {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate(WCValidator validator) {
        List<HTTPProxy> proxies = validator.getSpace().getAgent().getProxies();
        if (proxies == null || proxies.size() == 0) {
            return;
        }
        List<String> startURLs = validator.getStartURLs();
        TmpBucketManager manager = validator.getManager();
        for (HTTPProxy proxy : proxies) {
            proxy.getAddress();
            if (!proxy.isValid()) {
                validator.addChanges("/Crawler/Agent/Proxies/Proxy", proxy.toString(), WCValidator.Type.BAD_PROXY);
                continue;
            }
            boolean valid = false;
            boolean needAuth = false;
            for (String url : startURLs) {
                Bucket bucket;
                CURL curl = new CURL(url);
                if (!proxy.matches(curl.getHostname()) || (bucket = manager.bucketForURL(curl)) == null) continue;
                CrawlRec rec = new CrawlRec();
                bucket.setProxyAddress(proxy.getSocketAddress());
                rec.setURL(curl);
                rec.setBucket(bucket);
                Client client = new Client(rec);
                try {
                    client.download();
                    if (407 == client.getHTTPReturnCode()) {
                        needAuth = true;
                        break;
                    }
                    if (!HTTPCategory.talkedToServer(client.getHTTPReturnCode())) continue;
                    valid = true;
                    break;
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
                finally {
                    client.clear();
                    client = null;
                }
            }
            if (startURLs.size() <= 0 || valid) continue;
            validator.addChanges("/Crawler/Agent/Proxies/Proxy", proxy.toString(), needAuth ? WCValidator.Type.PROXY_AUTHENTICATION_REQUIRED : WCValidator.Type.BAD_PROXY);
        }
    }
}

