/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.validator;

import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.bucket.DNSResolver;
import com.ibm.es.nuvo.crawler.web.configuration.validator.ValidatorBase;
import com.ibm.es.nuvo.crawler.web.configuration.validator.WCValidator;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

class DNSValidator
extends ValidatorBase {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    DNSValidator() {
    }

    void validate(WCValidator validator) {
        List<String> startURLs = validator.getStartURLs();
        HashSet<Bucket> set = new HashSet<Bucket>();
        for (String url : startURLs) {
            CURL curl = new CURL(url);
            Bucket bucket = validator.getManager().bucketForURL(curl);
            assert (bucket != null);
            if (bucket == null) continue;
            set.add(bucket);
        }
        HashSet<String> invalidHost = new HashSet<String>();
        HashSet<String> excludeHost = new HashSet<String>();
        for (Bucket bucket : set) {
            DNSResolver.instance().resolve(bucket);
            if (bucket.getDNSFailCount() > 0) {
                invalidHost.add(bucket.getHostname());
                continue;
            }
            if (bucket.hasGoodDNS()) continue;
            excludeHost.add(bucket.getHostname());
        }
        set.clear();
        ListIterator<String> itr = startURLs.listIterator();
        while (itr.hasNext()) {
            String url = itr.next();
            CURL curl = new CURL(url);
            String hostname = curl.getHostname();
            if (invalidHost.contains(hostname)) {
                validator.addChanges("/Crawler/StartURLs/URL", url, WCValidator.Type.UNKNOWN_HOST);
            } else {
                if (!excludeHost.contains(hostname)) continue;
                validator.addChanges("/Crawler/Rules", url, WCValidator.Type.EXCLUDE_ADDRESS);
            }
            itr.remove();
        }
    }
}

