/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.rule.WildcardRule;
import com.ibm.es.nuvo.crawler.web.util.StreamUtils;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SoftErrorConfig
implements PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private List<SoftErrorPage> pages = new ArrayList<SoftErrorPage>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getReplacementCode(CURL url, String title, DataBufferOutputStream data, String encoding) throws IOException, DataBufferException {
        short ret = 0;
        String urlString = url.toString();
        for (SoftErrorPage page : this.pages) {
            InputStream is = null;
            try {
                is = data.getInputStream();
                if (!page.matches(urlString, title, is, encoding)) continue;
                short s = page.getCode();
                return s;
            }
            finally {
                StreamUtils.safeClose(is);
            }
        }
        return ret;
    }

    public void add(String urlPattern, String titlePattern, String contentPattern, short code) {
        this.pages.add(new SoftErrorPage(urlPattern, titlePattern, contentPattern, code));
    }

    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("SoftErrorPages");
        tagger.closeTag();
        for (SoftErrorPage page : this.pages) {
            page.toXML(tagger);
        }
        tagger.endElement("SoftErrorPages");
    }

    public long getHash(PublishableConfig.HashType type) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void clear() {
        this.pages.clear();
    }

    private static class SoftErrorPage
    implements PublishableConfig {
        private WildcardRule urlRule;
        private WildcardRule titleRule;
        private WildcardRule contentRule;
        private short code;

        public SoftErrorPage(String urlPattern, String titlePattern, String contentPattern, short code) {
            this.urlRule = WildcardRule.compile(urlPattern, true);
            this.titleRule = WildcardRule.compile(titlePattern, true);
            this.contentRule = WildcardRule.compile(contentPattern, true);
            this.code = code;
            if (this.urlRule == null || this.titleRule == null || this.contentRule == null) {
                // empty if block
            }
        }

        public boolean matches(String url, String title, InputStream content, String encoding) throws IOException {
            if (this.urlRule == null || this.titleRule == null || this.contentRule == null) {
                return false;
            }
            return this.urlRule.matches(url) && this.titleRule.matches(title) && this.contentRule.matches(content, encoding);
        }

        public short getCode() {
            return this.code;
        }

        public void toXML(XMLTagger tagger) {
            tagger.openStartElement("SoftErrorPage");
            tagger.writeAttr("Code", this.code);
            tagger.writeAttr("URL", this.urlRule.toString());
            tagger.writeAttr("Title", this.titleRule.toString());
            tagger.writeAttr("Body", this.contentRule.toString());
            tagger.closeEndElementTag();
        }

        public long getHash(PublishableConfig.HashType type) {
            return 0L;
        }
    }
}

