/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.util.XMLTagger;

public class RuleEntry
implements PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private boolean allow;
    private String pattern;
    private RuleType type;

    public RuleEntry(RuleType type, String pattern, boolean allow) {
        this.type = type;
        this.pattern = pattern;
        this.allow = allow;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public String getPattern() {
        return this.pattern;
    }

    public RuleType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.type);
        builder.append(":");
        builder.append(this.pattern);
        builder.append(":");
        builder.append(this.allow);
        return builder.toString();
    }

    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("Rule");
        tagger.writeAttr("RuleType", this.getType().toString().toLowerCase());
        tagger.writeAttr("Allow", "" + this.isAllow());
        tagger.writeAttr("Pattern", this.getPattern());
        tagger.closeEndElementTag();
    }

    public long getHash(PublishableConfig.HashType hashType) {
        return new Hash64(this.pattern + ":" + this.allow).longValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RuleType {
        PREFIX,
        DOMAIN,
        ADDRESS;

    }
}

