/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.config.InvalidRuleException;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.configuration.UpdatableConfiguration;
import com.ibm.es.nuvo.crawler.web.configuration.space.RuleEntry;
import com.ibm.es.nuvo.crawler.web.configuration.space.SoftErrorConfig;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.http.HTTPCategory;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.rule.WebSpace;
import com.ibm.es.nuvo.crawler.web.util.TaggerUtil;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.util.XMLTagger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleConfig
implements UpdatableConfiguration,
PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + RuleConfig.class.getName());
    private String excludePattern = "\\\\.jar|\\\\.ear|\\\\.war|\\\\.pkg|\\\\.bmp|\\\\.png|\\\\.wmv|\\\\.jpg|\\\\.jpeg|\\\\.gif|\\\\.bz2|\\\\.dvi|\\\\.rpm|\\\\.swf|\\\\.ram|\\\\.rm|\\\\.ra|\\\\.wav|\\\\.mp3|\\\\.mp2|\\\\.vrml|\\\\.mpeg|\\\\.mpg|\\\\.mov|\\\\.avi|\\\\.tif|\\\\.eps|\\\\.class|\\\\.exe|\\\\.asx|\\\\.asf|\\\\.c|\\\\.o|\\\\.h|\\\\.dll|\\\\.so|\\\\.a|\\\\.msi|\\\\.ico|\\\\.css|\\\\.js";
    private List<String> dominoExclusion = new ArrayList<String>(1);
    private String dominoBaseExclusion = ".*ExpandSection.*|.*ExpandOutline.*";
    private String dominoRelExclusion = ".*ExpandSection.*|.*ExpandOutline.*";
    private List<RuleEntry> rules = new ArrayList<RuleEntry>();
    private SoftErrorConfig softErrorConfig = new SoftErrorConfig();
    private static Pattern m_openDocPage = Pattern.compile("[\\?!][Oo]pen([Dd]ocument|[Pp]age)");
    private static Pattern m_forbiddenOps = Pattern.compile("[\\?!]([dD]elete|[eE]dit|[cC]reate|[sS]ave)[dD]ocument");
    private static Pattern m_expandSection = Pattern.compile("expandsection=([^&])", 2);
    private WebSpace webSpace;

    public String getDominoBaseExclusion() {
        return this.dominoBaseExclusion;
    }

    public void setDominoBaseExclusion(String dominoBaseExclusion) {
        this.dominoBaseExclusion = dominoBaseExclusion;
    }

    public List<String> getDominoExclusion() {
        return this.dominoExclusion;
    }

    public void setDominoExclusion(List<String> dominoExclusion) {
        this.dominoExclusion = dominoExclusion;
    }

    public void addDominoExclusion(String dominoServer) {
        this.dominoExclusion.add(dominoServer);
    }

    public String getDominoRelExclusion() {
        return this.dominoRelExclusion;
    }

    public void setDominoRelExclusion(String dominoRelExclusion) {
        this.dominoRelExclusion = dominoRelExclusion;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }

    public List<RuleEntry> getRules() {
        return this.rules;
    }

    public void addRule(String type, String pattern, boolean allow) {
        RuleEntry.RuleType ruleType = null;
        try {
            ruleType = RuleEntry.RuleType.valueOf(type.toUpperCase());
        }
        catch (Exception e) {
            tracer.log(Level.FINE, "Invalid rule", e);
            return;
        }
        this.rules.add(new RuleEntry(ruleType, pattern, allow));
    }

    public WebSpace getWebSpace() {
        return this.webSpace;
    }

    public SoftErrorConfig getSoftErrorConfig() {
        return this.softErrorConfig;
    }

    public void handleDomino(CrawlRec cr) {
        String serverID = cr.getServerID();
        if (cr.isNoFollow() || !HTTPCategory.hasContent(cr.getNewHTTPStatus()) || serverID == null || !serverID.startsWith("Lotus")) {
            return;
        }
        CURL url = cr.getURL();
        String hostname = url.getHostname();
        for (String exclude : this.dominoExclusion) {
            if (!exclude.equals(hostname)) continue;
            return;
        }
        List<CURL> outLinks = cr.getOutLinks();
        outLinks = url.toString().matches(this.dominoBaseExclusion) ? this._doDominoExclusions(outLinks, url) : this._doDominoGlobbing(outLinks, url);
        cr.setOutLinks(outLinks);
    }

    private List<CURL> _doDominoExclusions(List<CURL> m_outLinks, CURL m_url) {
        if (m_outLinks == null) {
            return null;
        }
        ArrayList<CURL> retainedLinks = null;
        for (CURL url : m_outLinks) {
            if (url.getHostHash().equals(m_url.getHostHash()) && url.toString().matches(this.dominoRelExclusion)) continue;
            if (retainedLinks == null) {
                retainedLinks = new ArrayList<CURL>();
            }
            retainedLinks.add(url);
        }
        return retainedLinks;
    }

    private List<CURL> _doDominoGlobbing(List<CURL> m_outLinks, CURL m_url) {
        Iterator<CURL> it;
        Iterator<CURL> it2;
        Matcher m = m_openDocPage.matcher(m_url.toString());
        if (!m.find()) {
            return m_outLinks;
        }
        String baseURL = m_url.toString().substring(0, m.start());
        HashSet<String> sections = new HashSet<String>();
        this._cumulateExpandedSections(m_url, sections);
        Iterator<CURL> iterator = it2 = m_outLinks == null ? null : m_outLinks.iterator();
        while (it2 != null && it2.hasNext()) {
            CURL url = it2.next();
            if (!url.toString().startsWith(baseURL)) continue;
            this._cumulateExpandedSections(url, sections);
        }
        if (sections.size() == 0) {
            return m_outLinks;
        }
        ArrayList<CURL> retainedLinks = new ArrayList<CURL>();
        Iterator<CURL> iterator2 = it = m_outLinks == null ? null : m_outLinks.iterator();
        while (it != null && it.hasNext()) {
            CURL url = it.next();
            boolean keep = true;
            CURL glob = null;
            boolean again = true;
            while (again && url.toString().startsWith(baseURL)) {
                if (m_forbiddenOps.matcher(url.toString()).find()) {
                    keep = false;
                    break;
                }
                m = m_openDocPage.matcher(url.toString());
                if (!m.find()) break;
                keep = false;
                if (glob != null) break;
                StringBuilder sb = new StringBuilder();
                sb.append(url.toString().substring(0, m.end()));
                sb.append("&ExpandSection=");
                Iterator<String> it22 = sections.iterator();
                while (it22.hasNext()) {
                    sb.append(it22.next());
                    if (!it22.hasNext()) continue;
                    sb.append(",");
                }
                glob = new CURL(sb.toString());
                if (glob.isValid()) {
                    retainedLinks.add(glob);
                }
                again = false;
            }
            if (!keep) continue;
            retainedLinks.add(url);
        }
        return retainedLinks.size() == 0 ? null : retainedLinks;
    }

    private void _cumulateExpandedSections(CURL url, HashSet<String> sections) {
        Matcher m = m_expandSection.matcher(url.toString());
        if (m.find() && m.group(1) != null) {
            int k;
            String[] sa = m.group(1).split("[ \t,-]", 0);
            int n = k = sa == null ? 0 : sa.length;
            for (int j = 0; j < k; ++j) {
                if (sa[j] == null || sa[j].length() <= 0) continue;
                sections.add(sa[j]);
            }
        }
    }

    @Override
    public void update() throws InvalidRuleException {
        WebSpace newSpace = new WebSpace(1);
        newSpace.configure(this.rules);
        newSpace.setExcludePattern(this.excludePattern);
        this.webSpace = newSpace;
    }

    @Override
    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("Rules");
        tagger.closeTag();
        TaggerUtil.addSimpleValue(tagger, "ExcludePattern", this.excludePattern);
        tagger.openStartElement("DominoRule");
        if (this.dominoBaseExclusion != null) {
            tagger.writeAttr("BaseExclusion", this.dominoBaseExclusion);
        }
        if (this.dominoRelExclusion != null) {
            tagger.writeAttr("RelativeExclusion", this.dominoRelExclusion);
        }
        tagger.closeTag();
        for (String ex : this.dominoExclusion) {
            TaggerUtil.addSimpleValue(tagger, "UnRestrictedServer", ex);
        }
        tagger.endElement("DominoRule");
        tagger.openStartElement("DomainRules");
        tagger.closeTag();
        for (RuleEntry entry : this.rules) {
            entry.toXML(tagger);
        }
        tagger.endElement("DomainRules");
        this.softErrorConfig.toXML(tagger);
        tagger.endElement("Rules");
    }

    @Override
    public long getHash(PublishableConfig.HashType type) {
        long hash = 0L;
        switch (type) {
            case DNS: {
                for (RuleEntry entry : this.rules) {
                    long l;
                    if (entry.getType() != RuleEntry.RuleType.ADDRESS || (l = entry.getHash(type)) == 0L) continue;
                    hash ^= l;
                }
                break;
            }
            case RULE: 
            case HTTP: 
            case HTTPS: {
                hash = new Hash64(this.excludePattern + this.dominoBaseExclusion + this.dominoRelExclusion).longValue();
                for (RuleEntry entry : this.rules) {
                    long l;
                    if (entry.getType() != RuleEntry.RuleType.PREFIX && entry.getType() != RuleEntry.RuleType.DOMAIN || (l = entry.getHash(type)) == 0L) continue;
                    hash ^= l;
                }
                break;
            }
            default: {
                return 0L;
            }
        }
        return hash;
    }

    public void clear(RuleTypes type) {
        switch (type) {
            case DOMAIN: {
                this.rules.clear();
                break;
            }
            case DOMINO: {
                this.dominoExclusion.clear();
                break;
            }
            case SOFT_ERROR: {
                this.softErrorConfig.clear();
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RuleTypes {
        DOMINO,
        DOMAIN,
        SOFT_ERROR;

    }
}

