/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.PolitenessExceptionConfig;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.util.XMLTagger;
import java.util.HashMap;
import java.util.Map;

public class PolitenessConfig
implements PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public HashMap<Hash64, Integer> exceptions = new HashMap();
    public HashMap<String, Integer> names = new HashMap();
    int interval = 2000;

    public void addException(PolitenessExceptionConfig exception) {
        this.addException(exception.getHostName(), exception.getPoliteness());
    }

    public void addException(String hostName, int politeness) {
        CURL curl = new CURL(hostName);
        if (!curl.isValid()) {
            if (!hostName.startsWith("http")) {
                this.addException("http://" + hostName, politeness);
                this.addException("https://" + hostName, politeness);
            }
            return;
        }
        this.exceptions.put(curl.getHostHash(), politeness);
        this.names.put(hostName, politeness);
    }

    public void clearExceptions() {
        this.exceptions.clear();
        this.names.clear();
    }

    public int forHost(Hash64 hostHash) {
        Integer exception = this.exceptions.get(hostHash);
        if (exception != null) {
            return exception;
        }
        return this.interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("Politeness");
        tagger.writeAttr("Default", this.interval);
        if (this.names.size() == 0) {
            tagger.closeEndElementTag();
        } else {
            tagger.closeTag();
            for (Map.Entry<String, Integer> entry : this.names.entrySet()) {
                tagger.openStartElement("SitePoliteness");
                tagger.writeAttr("Host", entry.getKey());
                tagger.writeAttr("politeness", entry.getValue().intValue());
                tagger.closeEndElementTag();
            }
            tagger.endElement("Politeness");
        }
    }

    public long getHash(PublishableConfig.HashType type) {
        return 0L;
    }
}

