/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.plugin.WebCrawlerPlugin;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class PluginConfig
implements PublishableConfig {
    private URLClassLoader classLoader;
    private WebCrawlerPlugin plugin;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private PluginType type = PluginType.POSTPARSE;
    private String name;
    private String path;

    public PluginConfig(String name, String path, String type) {
        PluginType t = null;
        try {
            t = PluginType.valueOf(type.toUpperCase());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (t != null) {
            this.name = name;
            this.path = path;
            this.type = t;
            this.init();
        }
    }

    PluginConfig(String name, String path, PluginType type) {
        this.name = name;
        this.path = path;
        this.type = type;
        this.init();
    }

    private void init() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String url : this.path.split(File.pathSeparator)) {
            URL purl = null;
            try {
                purl = new URL(url);
            }
            catch (MalformedURLException e) {
                continue;
            }
            if (purl == null) continue;
            urls.add(purl);
        }
        if (urls.size() > 0) {
            this.classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
            if (this.classLoader != null) {
                try {
                    Class<?> cls = this.classLoader.loadClass(this.name);
                    this.plugin = (WebCrawlerPlugin)cls.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public PluginType getType() {
        return this.type;
    }

    public void toXML(XMLTagger tagger) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public long getHash(PublishableConfig.HashType hashType) {
        if (hashType == PublishableConfig.HashType.HTTP) {
            return new Hash64((Object)((Object)this.type) + this.name + this.path).longValue();
        }
        return 0L;
    }

    public WebCrawlerPlugin getInstance() {
        return this.plugin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PluginType {
        PREFETCH,
        POSTPARSE;

    }
}

