/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.rule.WildcardRule;
import com.ibm.es.nuvo.util.XMLTagger;
import java.nio.charset.Charset;

public class KnownInfo
implements PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String language;
    private String codepage;
    private WildcardRule pattern;

    public KnownInfo(String urlPattern, String language, String codepage) {
        this.language = language;
        if (codepage != null && Charset.isSupported(codepage)) {
            this.codepage = codepage;
        }
        if (this.language != null || this.codepage != null) {
            this.pattern = WildcardRule.compile(urlPattern, true);
        }
    }

    public boolean match(String url) {
        return this.pattern == null ? false : this.pattern.matches(url);
    }

    public String getCodepage() {
        return this.codepage;
    }

    public String getLanguage() {
        return this.language;
    }

    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("DocumentProperty");
        tagger.writeAttr("URLPattern", this.pattern.toString());
        if (this.language != null) {
            tagger.writeAttr("Language", this.language);
        }
        if (this.codepage != null) {
            tagger.writeAttr("Codepage", this.codepage);
        }
        tagger.closeEndElementTag();
    }

    public long getHash(PublishableConfig.HashType type) {
        if (type == PublishableConfig.HashType.HTTP) {
            return new Hash64(this.language + this.codepage + this.pattern == null ? "" : this.pattern.toString()).longValue();
        }
        return 0L;
    }

    public String toString() {
        if (this.pattern == null) {
            return "Invalid";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.pattern);
        builder.append(" ");
        builder.append(this.language);
        builder.append(" ");
        builder.append(this.codepage);
        return builder.toString();
    }
}

