/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.config.FormBaseAuthenticator;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.AuthConfig;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.XMLTagger;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormAuthConfig
extends AuthConfig
implements PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ArrayList<FormBaseAuthenticator.FormDatum> params = new ArrayList();
    private String formName;
    private String action;
    private String method;

    public FormAuthConfig(String url, String formName, String action, String method) {
        super(url);
        this.formName = formName;
        this.action = action;
        this.method = method;
    }

    public FormAuthConfig() {
        super(null);
    }

    public void addParam(String name, String value, boolean encrypted) {
        this.params.add(new FormBaseAuthenticator.FormDatum(name, value, encrypted));
    }

    public void addParam(FormBaseAuthenticator.FormDatum param) {
        this.params.add(param);
    }

    public FormBaseAuthenticator toAuth() throws WCException {
        return new FormBaseAuthenticator(this.getUrl(), this.formName, this.action, this.method, this.params);
    }

    public String getAction() {
        return this.action;
    }

    public String getFormName() {
        return this.formName;
    }

    public String getMethod() {
        return this.method;
    }

    public ArrayList<FormBaseAuthenticator.FormDatum> getParams() {
        return this.params;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParams(ArrayList<FormBaseAuthenticator.FormDatum> params) {
        this.params = params;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.formName);
        builder.append(", ");
        builder.append(this.action);
        builder.append(", ");
        builder.append(this.method);
        builder.append(", ");
        builder.append(this.params);
        return builder.toString();
    }

    @Override
    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("Form");
        tagger.writeAttr("URLPattern", this.getUrl());
        tagger.writeAttr("Name", this.getFormName());
        tagger.writeAttr("Action", this.getAction());
        tagger.writeAttr("Method", this.getMethod());
        if (this.params == null || this.params.size() == 0) {
            tagger.closeEndElementTag();
        } else {
            tagger.closeTag();
            for (FormBaseAuthenticator.FormDatum fd : this.params) {
                String value;
                tagger.openStartElement("Param");
                tagger.writeAttr("Name", fd.getName());
                if (fd.isEncrypted()) {
                    try {
                        value = Encryption.encrypt(fd.getValue());
                    }
                    catch (ExtendedException e) {
                        value = fd.getValue();
                    }
                } else {
                    value = fd.getValue();
                }
                tagger.writeAttr("Value", value);
                tagger.writeAttr("Encrypted", "" + fd.isEncrypted());
                tagger.closeEndElementTag();
            }
            tagger.endElement("Form");
        }
    }

    @Override
    public long getHash(PublishableConfig.HashType type) {
        return new Hash64(this.getUrl() + this.formName + this.action + this.method + this.getParams().toString()).longValue();
    }
}

