/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.configuration.UpdatableConfiguration;
import com.ibm.es.nuvo.crawler.web.configuration.space.ACLConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.AgentConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.KnownInfo;
import com.ibm.es.nuvo.crawler.web.configuration.space.PolitenessConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.RuleConfig;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.rule.WebSpace;
import com.ibm.es.nuvo.crawler.web.util.TaggerUtil;
import com.ibm.es.nuvo.util.XMLTagger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlSpaceConfig
implements UpdatableConfiguration,
PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String id;
    private String collectionId;
    private String name;
    private String language = "en";
    private boolean detectLanguage = true;
    private String codepage = "iso8859-1";
    private boolean detectCodepage = true;
    private int maxPageLength = 0x3200000;
    private int maxConnections = 10;
    private int maxPathDepth = 16;
    private int logURL = 40;
    private AgentConfig agent = new AgentConfig();
    private ACLConfig acl = new ACLConfig();
    private RuleConfig rule = new RuleConfig();
    private int minRecrawlInterval = 86400;
    private int maxRecrawlInterval = 172800;
    private int maxDocuments = 2000000;
    private List<String> startURLs = new ArrayList<String>();
    private String description;
    private boolean forceRecrawl;
    private static Map<String, CrawlSpaceConfig> managers = new HashMap<String, CrawlSpaceConfig>();
    private List<KnownInfo> knownDocuments = new ArrayList<KnownInfo>();
    private PolitenessConfig politeness = new PolitenessConfig();
    private boolean valid = true;

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public CrawlSpaceConfig(String id) {
        this.id = id;
    }

    public List<String> getStartURLs() {
        return this.startURLs;
    }

    public void addStartURL(String url) {
        this.startURLs.add(url);
    }

    public ACLConfig getAcl() {
        return this.acl;
    }

    public AgentConfig getAgent() {
        return this.agent;
    }

    public String getCodepage() {
        return this.codepage;
    }

    public void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public String getId() {
        return this.id;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getLogURL() {
        return this.logURL;
    }

    public void setLogURL(int logURL) {
        this.logURL = logURL;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxPageLength() {
        return this.maxPageLength;
    }

    public void setMaxPageLength(int maxPageLength) {
        this.maxPageLength = maxPageLength;
    }

    public int getMaxPathDepth() {
        return this.maxPathDepth;
    }

    public void setMaxPathDepth(int maxPathDepth) {
        this.maxPathDepth = maxPathDepth;
    }

    public String getName() {
        return this.name;
    }

    public RuleConfig getRule() {
        return this.rule;
    }

    public boolean isDetectCodepage() {
        return this.detectCodepage;
    }

    public void setDetectCodepage(boolean detectCodepage) {
        this.detectCodepage = detectCodepage;
    }

    public boolean isDetectLanguage() {
        return this.detectLanguage;
    }

    public void setDetectLanguage(boolean detectLanguage) {
        this.detectLanguage = detectLanguage;
    }

    public int getMaxRecrawlInterval() {
        return this.maxRecrawlInterval;
    }

    public void setMaxRecrawlInterval(int maxRecrawlInterval) {
        this.maxRecrawlInterval = maxRecrawlInterval;
    }

    public int getMinRecrawlInterval() {
        return this.minRecrawlInterval;
    }

    public void setMinRecrawlInterval(int minRecrawlInterval) {
        this.minRecrawlInterval = minRecrawlInterval;
    }

    public void setRecrawlInterval(int min, int max) {
        this.maxRecrawlInterval = max;
        this.minRecrawlInterval = min;
    }

    public int getMaxDocuments() {
        return this.maxDocuments;
    }

    public void setMaxDocs(int maxDocs) {
        this.maxDocuments = maxDocs;
    }

    public WebSpace getWebSpace() {
        return this.rule.getWebSpace();
    }

    @Override
    public void update() throws WCException {
        this.agent.update();
        this.rule.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CrawlSpaceConfig forName(String id) {
        Map<String, CrawlSpaceConfig> map = managers;
        synchronized (map) {
            return managers.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateConfig(String id, CrawlSpaceConfig config) {
        config.setId(id);
        Map<String, CrawlSpaceConfig> map = managers;
        synchronized (map) {
            CrawlSpaceConfig oldConfig = managers.put(id, config);
            if (oldConfig != null && oldConfig != config) {
                oldConfig.setValid(false);
            }
            config.setValid(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateAll() {
        Map<String, CrawlSpaceConfig> map = managers;
        synchronized (map) {
            for (CrawlSpaceConfig config : managers.values()) {
                config.setValid(false);
            }
        }
    }

    @Override
    public long getHash(PublishableConfig.HashType type) {
        long hash = 0L;
        ArrayList<PublishableConfig> list = new ArrayList<PublishableConfig>();
        list.add(this.agent);
        list.add(this.acl);
        list.addAll(this.knownDocuments);
        list.add(this.politeness);
        list.add(this.rule);
        hash = Hash64.xorHash(type, list);
        return hash;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("Crawler");
        tagger.writeAttr("Version", "1.0");
        tagger.writeAttr("DataSourceType", "Web");
        tagger.closeTag();
        TaggerUtil.addSimpleValue(tagger, "CrawlerID", this.id);
        TaggerUtil.addSimpleValue(tagger, "CrawlerName", this.name);
        TaggerUtil.addSimpleValue(tagger, "Description", this.description);
        TaggerUtil.addSimpleValue(tagger, "Language", this.language);
        TaggerUtil.addSimpleValue(tagger, "Codepage", this.codepage);
        tagger.openStartElement("KnownDocuments");
        tagger.closeTag();
        for (KnownInfo info : this.knownDocuments) {
            info.toXML(tagger);
        }
        tagger.endElement("KnownDocuments");
        TaggerUtil.addSimpleValue(tagger, "NumberOfMaxDocuments", this.maxDocuments);
        TaggerUtil.addSimpleValue(tagger, "MaxPageLength", this.maxPageLength);
        TaggerUtil.addSimpleValue(tagger, "NumberOfMaxConnections", this.maxConnections);
        TaggerUtil.addSimpleValue(tagger, "MaxPathDepth", this.maxPathDepth);
        TaggerUtil.addSimpleValue(tagger, "NumberOfLogURL", this.logURL);
        tagger.openStartElement("RecrawlInterval");
        tagger.writeAttr("min", this.minRecrawlInterval);
        tagger.writeAttr("max", this.maxRecrawlInterval);
        tagger.closeEndElementTag();
        this.agent.toXML(tagger);
        this.acl.toXML(tagger);
        this.rule.toXML(tagger);
        this.politeness.toXML(tagger);
        tagger.openStartElement("StartURLs");
        tagger.closeTag();
        for (String url : this.startURLs) {
            TaggerUtil.addSimpleValue(tagger, "URL", url);
        }
        tagger.endElement("StartURLs");
        tagger.endElement("Crawler");
    }

    public void clearStartURLs() {
        this.startURLs.clear();
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String crawlerId) {
        this.collectionId = crawlerId;
    }

    public PolitenessConfig getPoliteness() {
        return this.politeness;
    }

    public void setPoliteness(PolitenessConfig politeness) {
        this.politeness = politeness;
    }

    public KnownInfo getKnownInfo(CURL curl) {
        if (curl == null) {
            return null;
        }
        String url = curl.toString();
        for (KnownInfo info : this.knownDocuments) {
            if (!info.match(url)) continue;
            return info;
        }
        url = curl.downstreamString();
        for (KnownInfo info : this.knownDocuments) {
            if (!info.match(url)) continue;
            return info;
        }
        return null;
    }

    public List<KnownInfo> getKnownDocuments() {
        return this.knownDocuments;
    }

    public void addKnownDocument(String urlPattern, String lang, String encoding) {
        if (urlPattern == null || lang == null && encoding == null) {
            return;
        }
        this.knownDocuments.add(new KnownInfo(urlPattern, lang, encoding));
    }

    public boolean isForceRecrawl() {
        return this.forceRecrawl;
    }

    public void setForceRecrawl(boolean forceRecrawl) {
        this.forceRecrawl = forceRecrawl;
    }

    static boolean forcePlainPassword() {
        return Boolean.getBoolean("crawler.web.password.plain");
    }

    public CrawlSpaceConfig alterSpace() {
        Field[] declaredFields;
        CrawlSpaceConfig config = new CrawlSpaceConfig(this.id);
        for (Field field : declaredFields = this.getClass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) continue;
            try {
                field.set(config, field.get(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return config;
    }
}

