/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.AuthConfig;
import com.ibm.es.nuvo.crawler.web.http.BasicAuth;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.XMLTagger;

public class BasicAuthConfig
extends AuthConfig
implements PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String realm;
    private String user;
    private String password;
    private String acl;

    public BasicAuthConfig(String url, String user, String password, boolean encrypted, String acl, String realm) {
        super(url);
        this.user = user;
        String pw = password;
        if (encrypted) {
            try {
                pw = Encryption.decrypt(password);
            }
            catch (Exception e) {
                pw = password;
            }
        }
        this.password = pw;
        this.acl = acl;
        this.realm = realm;
    }

    public BasicAuthConfig() {
        super(null);
    }

    public BasicAuth toAuth() {
        return new BasicAuth(this.getUrl(), this.realm, this.user, this.password, this.acl);
    }

    public String getAcl() {
        return this.acl;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUser() {
        return this.user;
    }

    public void toXML(XMLTagger tagger) {
        String pw;
        tagger.openStartElement("Basic");
        tagger.writeAttr("URL", this.getUrl());
        tagger.writeAttr("Realm", this.realm);
        tagger.writeAttr("User", this.user);
        try {
            pw = Encryption.encrypt(this.password);
        }
        catch (ExtendedException e) {
            pw = this.password;
        }
        tagger.writeAttr("Password", pw);
        tagger.writeAttr("ACL", this.acl);
        tagger.closeEndElementTag();
    }

    public long getHash(PublishableConfig.HashType type) {
        return new Hash64(this.getUrl() + this.realm + this.user + this.password + this.acl).longValue();
    }
}

