/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.config.FormBaseAuthenticator;
import com.ibm.es.nuvo.crawler.web.config.HTTPProxy;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.configuration.UpdatableConfiguration;
import com.ibm.es.nuvo.crawler.web.configuration.space.BasicAuthConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.FormAuthConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.PluginConfig;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.http.BasicAuth;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.plugin.WebCrawlerPlugin;
import com.ibm.es.nuvo.crawler.web.util.TaggerUtil;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.util.XMLTagger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentConfig
implements UpdatableConfiguration,
PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + AgentConfig.class.getName());
    private String name;
    private String email;
    private String accept = "text/*,application/pdf,application/msword,application/rtf,application/x-msexcel,application/x-mspowerpoxsd:int,application/vnd.ms-powerpoxsd:int,application/xml,application/vnd.lotus-1-2-3,application/vnd.lotus-freelance,application/vnd.lotus-wordpro,application/vnd.ms-excel";
    private String language = "*";
    private List<BasicAuthConfig> basicAuthConfig = new ArrayList<BasicAuthConfig>();
    private List<FormAuthConfig> formAuthConfig = new ArrayList<FormAuthConfig>();
    private List<PluginConfig> plugins = new ArrayList<PluginConfig>();
    private List<HTTPProxy> proxies = new ArrayList<HTTPProxy>();
    private List<BasicAuth> basicAuth = new ArrayList<BasicAuth>();
    private List<FormBaseAuthenticator> formAuth = new ArrayList<FormBaseAuthenticator>();
    private FormAuthConfig lastFBA;

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<BasicAuthConfig> getBasicAuthConfig() {
        return this.basicAuthConfig;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void update() throws WCException {
        ArrayList<BasicAuth> newBasicAuth = new ArrayList<BasicAuth>(this.basicAuthConfig.size());
        for (BasicAuthConfig config : this.basicAuthConfig) {
            newBasicAuth.add(config.toAuth());
        }
        ArrayList<FormBaseAuthenticator> newFormAuth = new ArrayList<FormBaseAuthenticator>(this.formAuthConfig.size());
        for (FormAuthConfig config : this.formAuthConfig) {
            newFormAuth.add(config.toAuth());
        }
        this.basicAuth = newBasicAuth;
        this.formAuth = newFormAuth;
    }

    public FormAuthConfig newFormAuthConfig() {
        FormAuthConfig config = new FormAuthConfig();
        this.formAuthConfig.add(config);
        return config;
    }

    public HTTPProxy getProxy(String dnsHostname) {
        for (HTTPProxy p : this.proxies) {
            if (!p.matches(dnsHostname)) continue;
            return p;
        }
        return null;
    }

    public void addProxy(String domain, String ipAddress, String portString, String id, String pw, boolean enc) {
        HTTPProxy proxy;
        try {
            proxy = new HTTPProxy(domain, ipAddress, portString, id == null ? 0 : 1, id, pw, enc);
        }
        catch (WCException e) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, domain + " " + ipAddress + " " + portString + " " + id + " " + pw + " " + enc, e);
            }
            return;
        }
        this.proxies.add(proxy);
    }

    public List<HTTPProxy> getProxies() {
        return this.proxies;
    }

    public BasicAuth getBasicAuth(CURL url) {
        if (url == null || !url.isValid() || this.basicAuth.size() == 0) {
            return null;
        }
        String urlString = url.toString();
        for (BasicAuth auth : this.basicAuth) {
            CURL rootURL = auth.getRootURL();
            if (!urlString.startsWith(rootURL.toString())) continue;
            return auth;
        }
        return null;
    }

    public FormBaseAuthenticator getFormBaseAuthenticator(CURL url) {
        if (url == null || !url.isValid() || this.formAuth.size() == 0) {
            return null;
        }
        for (FormBaseAuthenticator auth : this.formAuth) {
            if (!auth.matches(url)) continue;
            return auth;
        }
        return null;
    }

    public List<FormBaseAuthenticator> getFormBaseAuthConfig() {
        return this.formAuth;
    }

    public void addBasicAuth(String url, String user, String password, String acl, String realm) {
        this.addBasicAuth(url, user, password, false, acl, realm);
    }

    public void addBasicAuth(String url, String user, String password, boolean encrypted, String acl, String realm) {
        this.basicAuthConfig.add(new BasicAuthConfig(url, user, password, encrypted, acl, realm));
    }

    public void addFormBaseAuth(String url, String formName, String action, String method) {
        this.lastFBA = new FormAuthConfig(url, formName, action, method);
        this.formAuthConfig.add(this.lastFBA);
    }

    public void addFormBaseAuthParam(String paramName, String value, boolean encripted) {
        if (this.lastFBA != null) {
            this.lastFBA.addParam(paramName, value, encripted);
        }
    }

    @Override
    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("Agent");
        tagger.writeAttr("Name", this.name);
        tagger.writeAttr("From", this.email);
        tagger.closeTag();
        TaggerUtil.addSimpleValue(tagger, "AcceptType", this.accept);
        TaggerUtil.addSimpleValue(tagger, "AcceptLanguage", this.language);
        tagger.openStartElement("Authentications");
        tagger.closeTag();
        for (BasicAuthConfig ba : this.basicAuthConfig) {
            ba.toXML(tagger);
        }
        for (FormAuthConfig fa : this.formAuthConfig) {
            fa.toXML(tagger);
        }
        tagger.endElement("Authentications");
        tagger.openStartElement("Proxies");
        tagger.closeTag();
        for (HTTPProxy proxy : this.proxies) {
            proxy.toXML(tagger);
        }
        tagger.endElement("Proxies");
        tagger.openStartElement("Plugins");
        tagger.closeTag();
        for (PluginConfig config : this.plugins) {
            tagger.openStartElement("Pluin");
            tagger.writeAttr("PluginType", config.getType().toString());
            tagger.writeAttr("Path", config.getPath());
            tagger.writeAttr("Name", config.getName());
            tagger.closeEndElementTag();
        }
        tagger.endElement("Plugins");
        tagger.endElement("Agent");
    }

    @Override
    public long getHash(PublishableConfig.HashType type) {
        long hash = 0L;
        ArrayList<PublishableConfig> list = new ArrayList<PublishableConfig>();
        switch (type) {
            case ALL: {
                hash = new Hash64(this.name).longValue();
                break;
            }
            case BASIC_AUTH: {
                list.addAll(this.basicAuthConfig);
                hash = Hash64.xorHash(type, list);
                break;
            }
            case FORM_BASE_AUTH: {
                list.addAll(this.formAuthConfig);
                hash = Hash64.xorHash(type, list);
                break;
            }
            case PROXY: {
                list.addAll(this.proxies);
                hash = Hash64.xorHash(type, list);
                break;
            }
            case HTTP: 
            case HTTPS: {
                list.addAll(this.plugins);
                hash = Hash64.xorHash(type, list);
                hash ^= new Hash64(this.accept + this.language).longValue();
                break;
            }
            case ROBOTS: {
                list.addAll(this.basicAuthConfig);
                hash = Hash64.xorHash(type, list);
                break;
            }
        }
        return hash;
    }

    public void clear(ClearTarget target) {
        switch (target) {
            case BASIC: {
                this.basicAuth.clear();
                this.basicAuthConfig.clear();
                break;
            }
            case FORM: {
                this.formAuth.clear();
                this.formAuthConfig.clear();
                break;
            }
            case PROXY: {
                this.proxies.clear();
                break;
            }
        }
    }

    public List<FormAuthConfig> getFormAuthConfig() {
        return this.formAuthConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlugin(String typeName, String className, String classPath) {
        block5: {
            try {
                PluginConfig config = new PluginConfig(className, classPath, typeName);
                if (config.getInstance() == null) break block5;
                List<PluginConfig> list = this.plugins;
                synchronized (list) {
                    this.plugins.add(config);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebCrawlerPlugin> getPlugins() {
        ArrayList<WebCrawlerPlugin> list = new ArrayList<WebCrawlerPlugin>();
        List<PluginConfig> list2 = this.plugins;
        synchronized (list2) {
            for (PluginConfig config : this.plugins) {
                list.add(config.getInstance());
            }
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClearTarget {
        BASIC,
        FORM,
        PROXY;

    }
}

