/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.space;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.util.TaggerUtil;
import com.ibm.es.nuvo.util.XMLTagger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLConfig
implements PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private boolean enable;
    private List<String> metaTags = new ArrayList<String>();
    private String global;

    public String getGlobal() {
        return this.global;
    }

    public void setGlobal(String global) {
        this.global = global;
        this.checkEnable();
    }

    private void checkEnable() {
        this.enable = this.global != null || this.metaTags.size() > 0;
    }

    public List<String> getMetaTags() {
        this.checkEnable();
        return this.metaTags;
    }

    public void addMetaTag(String tag) {
        this.metaTags.add(tag);
        this.checkEnable();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isACL(String fieldName) {
        for (String tag : this.metaTags) {
            if (!tag.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("ACL");
        tagger.writeAttr("enable", "" + this.enable);
        tagger.closeTag();
        tagger.openStartElement("MetaTags");
        tagger.closeTag();
        for (String tag : this.metaTags) {
            TaggerUtil.addSimpleValue(tagger, "MetaTag", tag);
        }
        tagger.endElement("MetaTags");
        if (this.global != null && this.global.trim().length() > 0) {
            TaggerUtil.addSimpleValue(tagger, "Global", this.global);
        }
        tagger.endElement("ACL");
    }

    @Override
    public long getHash(PublishableConfig.HashType type) {
        return new Hash64(this.global + this.metaTags.toString()).longValue();
    }

    public void clearMetaTags() {
        this.metaTags.clear();
        this.checkEnable();
    }
}

