/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.notify;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigChangeListener;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;

public class ConfigEventBroaker {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String GLOBAL = File.separator + "GLOBAL" + File.separator;
    private static ExtendedLogger logger = Loggers.logger;
    private static Map<String, List<WeakReference<ConfigChangeListener>>> listeners = new HashMap<String, List<WeakReference<ConfigChangeListener>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String id, ConfigChangeListener listener) {
        Object object;
        List<WeakReference<ConfigChangeListener>> list = listeners.get(id);
        if (list == null) {
            object = listeners;
            synchronized (object) {
                list = listeners.get(id);
                if (list == null) {
                    list = new ArrayList<WeakReference<ConfigChangeListener>>();
                    listeners.put(id, list);
                }
            }
        }
        object = list;
        synchronized (object) {
            list.add(new WeakReference<ConfigChangeListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deredister(String id) {
        Map<String, List<WeakReference<ConfigChangeListener>>> map = listeners;
        synchronized (map) {
            listeners.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notify(String id) {
        List<WeakReference<ConfigChangeListener>> list = listeners.get(id);
        if (list == null) {
            return;
        }
        List<WeakReference<ConfigChangeListener>> list2 = list;
        synchronized (list2) {
            ListIterator<WeakReference<ConfigChangeListener>> iterator = list.listIterator();
            while (iterator.hasNext()) {
                WeakReference<ConfigChangeListener> reference = iterator.next();
                if (reference.get() == null) {
                    iterator.remove();
                    continue;
                }
                ConfigChangeListener listener = (ConfigChangeListener)reference.get();
                try {
                    listener.applyChange();
                }
                catch (WCException e) {
                    Message message = new Message("C4905W.CONFIG_NOT_APPLIED", listener);
                    ExtendedException exception = new ExtendedException(message, (Throwable)e);
                    logger.log(Level.WARNING, exception);
                }
            }
        }
    }
}

