/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.loader;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.crawler.CrawlerConfigLoader;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.PluginConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.RuleEntry;
import com.ibm.es.nuvo.crawler.web.util.StreamUtils;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class WebCrawlSpaceConfigLoader
implements CrawlerConfigLoader {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static WebCrawlSpaceConfigLoader instance = new WebCrawlSpaceConfigLoader();

    private WebCrawlSpaceConfigLoader() {
    }

    public static CrawlerConfigLoader instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CrawlSpaceConfig load(String id, InputStream is) throws ExtendedException {
        ParseTree tree = new ParseTree();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("From", "email");
        map.put("BaseExclusion", "DominoBaseExclusion");
        map.put("RelativeExclusion", "DominoRelExclusion");
        map.put("Default", "interval");
        tree.addCallMethod("/Crawler/CrawlerID", "setId");
        tree.addCallMethod("/Crawler/CrawlerName", "setName");
        tree.addCallMethod("/Crawler/Description", "setDescription");
        tree.addCallMethod("/Crawler/Language", "setLanguage");
        tree.addCallMethod("/Crawler/Codepage", "setCodepage");
        tree.addCallMethod("/Crawler/KnownDocuments/DocumentProperty", "addKnownDocument", new String[]{"URLPattern", "Language", "Codepage"}, new Object[]{null, null, null});
        tree.addCallMethod("/Crawler/MaxPageLength", "setMaxPageLength");
        tree.addCallMethod("/Crawler/NumberOfMaxDocuments", "setMaxDocs");
        tree.addCallMethod("/Crawler/NumberOfMaxConnections", "setMaxConnections");
        tree.addCallMethod("/Crawler/MaxPathDepth", "setMaxPathDepth");
        tree.addCallMethod("/Crawler/NumberOfLogURL", "setLogURL");
        tree.addCallMethod("/Crawler/RecrawlInterval", "setRecrawlInterval", new String[]{"min", "max"}, new Object[]{86400, 1209600});
        tree.addSetSubcomponent("/Crawler/Agent", "getAgent");
        tree.addAttributesRule("/Crawler/Agent", map);
        tree.addCallMethod("/Crawler/Agent/AcceptLangage", "setLanguage");
        tree.addCallMethod("/Crawler/Agent/AcceptType", "setAccept");
        tree.addCallMethod("/Crawler/Agent/Authentications/Basic", "addBasicAuth", new String[]{"URL", "User", "Password", "Encrypted", "ACL", "Realm"}, new Object[]{null, null, null, Boolean.TRUE, null, null});
        tree.addCallMethod("/Crawler/Agent/Authentications/Form", "addFormBaseAuth", new String[]{"URLPattern", "Name", "Action", "Method"}, new Object[]{null, null, null, null});
        tree.addCallMethod("/Crawler/Agent/Authentications/Form/Param", "addFormBaseAuthParam", new String[]{"Name", "Value", "Encrypted"}, new Object[]{null, null, Boolean.FALSE});
        tree.addCallMethod("/Crawler/Agent/Proxies/Proxy", "addProxy", new String[]{"Domain", "Server", "Port", "User", "Password", "Encrypted"}, new Object[]{null, null, null, null, null, Boolean.TRUE});
        tree.addSetSubcomponent("/Crawler/ACL", "getAcl");
        tree.addCallMethod("/Crawler/ACL/MetaTags/MetaTag", "addMetaTag");
        tree.addCallMethod("/Crawler/ACL/Global", "setGlobal");
        tree.addSetSubcomponent("/Crawler/Rules", "getRule");
        tree.addCallMethod("/Crawler/Rules/ExcludePattern", "setExcludePattern");
        tree.addCallMethod("/Crawler/Rules/DominoRule/UnRestrictedServer", "addDominoExclusion");
        tree.addAttributesRule("/Crawler/Rules/DominoRule", map);
        tree.addCallMethod("/Crawler/Rules/DomainRules/Rule", "addRule", new String[]{"RuleType", "Pattern", "Allow"}, new Object[]{RuleEntry.RuleType.PREFIX, null, false});
        tree.addSetSubcomponent("/Crawler/Rules/SoftErrorPages", "getSoftErrorConfig");
        tree.addCallMethod("/Crawler/Rules/SoftErrorPages/SoftErrorPage", "add", new String[]{"URL", "Title", "Body", "Code"}, new Object[]{null, "*", "*", 404});
        tree.addSetSubcomponent("/Crawler/Politeness", "getPoliteness");
        tree.addAttributesRule("/Crawler/Politeness", map);
        tree.addCallMethod("/Crawler/Politeness/SitePoliteness", "addException", new String[]{"Host", "politeness"}, new Object[]{"", 2});
        tree.addCallMethod("/Crawler/Agent/Plugins/Plugin", "addPlugin", new String[]{"PluginType", "Name", "Path"}, new Object[]{PluginConfig.PluginType.POSTPARSE.toString(), null, null});
        tree.addCallMethod("/Crawler/StartURLs/URL", "addStartURL");
        Parser parser = new Parser();
        CrawlSpaceConfig config = new CrawlSpaceConfig(id);
        parser.parse(is, tree, config);
        GlobalConfiguration globalConfig = GlobalConfiguration.getConfiguration();
        String conf = globalConfig != null ? globalConfig.getCollectionPath() : "." + File.separator + id + File.separator + "web_crawlspace_override.xml";
        File override = new File(conf);
        if (override.exists() && override.canRead() && override.isFile()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(override);
                parser.parse(fis, tree, config);
            }
            catch (IOException ignored) {
                StreamUtils.safeClose(fis);
                catch (Throwable throwable) {
                    StreamUtils.safeClose(fis);
                    throw throwable;
                }
            }
            StreamUtils.safeClose(fis);
        }
        config.update();
        return config;
    }
}

