/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration.loader;

import com.ibm.es.nuvo.crawler.web.configuration.BucketConfig;
import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.crawler.web.configuration.IntervalConfig;
import com.ibm.es.nuvo.crawler.web.configuration.RobotConfig;
import com.ibm.es.nuvo.crawler.web.configuration.SSLConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.ACLConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.AgentConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.BasicAuthConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.RuleConfig;
import com.ibm.es.nuvo.crawler.web.configuration.space.RuleEntry;
import com.ibm.es.nuvo.crawler.web.configuration.space.SoftErrorConfig;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFConfigLoader
implements ErrorHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String PROXY = "WebCrawlerConfig/Proxies/HTTPProxy";
    private static final String FBA = "WebCrawlerConfig/FBAs/FBA";

    private OFConfigLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String dir, String name) throws Exception {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(dir + File.separator + "crawl.properties");
            properties.load(fis);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
        }
        CrawlerConfig instance = CrawlerConfig.getInstance();
        if (CrawlSpaceConfig.forName(name) != null) {
            return;
        }
        instance.setMaxConnections(Integer.parseInt(properties.getProperty("crawlrate")));
        instance.setSoTimeout(Integer.parseInt(properties.getProperty("timeout")));
        IntervalConfig dnsIntervalConfig = instance.getDnsIntervalConfig();
        dnsIntervalConfig.setCheck(Integer.parseInt(properties.getProperty("dns_check_interval")));
        dnsIntervalConfig.setRetry(Integer.parseInt(properties.getProperty("dns_retry_interval")));
        BucketConfig bucketConfig = instance.getBucketConfig();
        bucketConfig.setMaxActive(Integer.parseInt(properties.getProperty("active_buckets")));
        bucketConfig.setTimeout(Integer.parseInt(properties.getProperty("bucket_timeout")));
        RobotConfig robotConfig = instance.getRobotConfig();
        robotConfig.setCheck(Integer.parseInt(properties.getProperty("robots_check_interval")));
        robotConfig.setMaxFail(Integer.parseInt(properties.getProperty("robots_max_fail_count")));
        robotConfig.setMaxPageSize(Integer.parseInt(properties.getProperty("robots_max_size")));
        CrawlSpaceConfig config = new CrawlSpaceConfig(name);
        config.setCodepage(properties.getProperty("default_code_page"));
        config.setLanguage(properties.getProperty("default_language"));
        config.setLogURL(Integer.parseInt(properties.getProperty("logcapacity")));
        config.setMaxConnections(Integer.parseInt(properties.getProperty("crawlrate")));
        config.setMaxPageLength(Integer.parseInt(properties.getProperty("page_max_size")));
        config.setMaxPathDepth(Integer.parseInt(properties.getProperty("max_path_depth")));
        config.setMaxRecrawlInterval(Integer.parseInt(properties.getProperty("max_recrawl_interval")));
        config.setMinRecrawlInterval(Integer.parseInt(properties.getProperty("min_recrawl_interval")));
        config.setMaxDocs(Integer.parseInt(properties.getProperty("valid_url_limit")));
        ACLConfig acl = config.getAcl();
        acl.setEnable(false);
        AgentConfig agent = config.getAgent();
        agent.setName(properties.getProperty("user_agent"));
        agent.setEmail(properties.getProperty("complaint_email"));
        agent.setAccept(properties.getProperty("accepts"));
        instance.getSslConfig().setTrustMode(SSLConfig.CertificationType.SELF.name());
        RuleConfig rule = config.getRule();
        List<RuleEntry> rules = rule.getRules();
        OFConfigLoader.loadRules(rules, dir);
        List<String> startURLs = config.getStartURLs();
        OFConfigLoader.loadStartUrls(startURLs, dir);
        OFConfigLoader.loadFormBassAuth(agent, dir);
        OFConfigLoader.loadAuth(agent.getBasicAuthConfig(), dir);
        OFConfigLoader.loadProxy(agent, dir);
        OFConfigLoader.loadSoftError(rule.getSoftErrorConfig(), dir);
        config.update();
        CrawlSpaceConfig.updateConfig(name, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSoftError(SoftErrorConfig softErrorConfig, String dir) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(dir + File.separator + "soft_errors.cnf"));
            ArrayList<String> list = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf("#");
                if (idx > 0) {
                    line = line.substring(0, idx);
                }
                if (idx == 0 || (line = line.trim()).length() == 0) continue;
                list.add(line);
                if (list.size() != 4) continue;
                softErrorConfig.add((String)list.get(0), (String)list.get(1), (String)list.get(2), Short.parseShort((String)list.get(3)));
                list.clear();
            }
        }
        catch (IOException ignored) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadStartUrls(List<String> startURLs, String dir) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(dir + File.separator + "start_urls"));
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf("#");
                if (idx > 0) {
                    line = line.substring(0, idx);
                }
                if (idx == 0 || (line = line.trim()).length() == 0) continue;
                startURLs.add(line);
            }
        }
        catch (IOException ignored) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRules(List<RuleEntry> rules, String dir) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(dir + File.separator + "crawl.rules"));
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf("#");
                if (idx > 0) {
                    line = line.substring(0, idx);
                }
                if (idx == 0 || (line = line.trim()).length() == 0) continue;
                String[] tokens = line.split("[ \t]+");
                if (tokens.length < 3) {
                    System.err.println("Invalid " + line);
                    continue;
                }
                RuleEntry.RuleType type = null;
                try {
                    type = RuleEntry.RuleType.valueOf(tokens[1].toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Invalid " + line);
                }
                if (type == null) {
                    System.err.println("Invalid " + line);
                    continue;
                }
                boolean allow = "allow".equalsIgnoreCase(tokens[0]);
                String value = tokens[2];
                if (RuleEntry.RuleType.ADDRESS == type && tokens.length > 3) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(value);
                    builder.append("/");
                    builder.append(tokens[3]);
                    value = builder.toString();
                }
                rules.add(new RuleEntry(type, value, allow));
            }
        }
        catch (IOException ignored) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFormBassAuth(AgentConfig agent, String dir) {
        InputStream is = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Name", "formName");
        try {
            is = new FileInputStream(dir + File.separator + "fba.xml");
            ParseTree tree = new ParseTree();
            tree.addSetSubcomponent(FBA, "newFormAuthConfig");
            tree.addCallMethod("WebCrawlerConfig/FBAs/FBA/URLPattern", "setUrl");
            tree.addAttributesRule("WebCrawlerConfig/FBAs/FBA/Form", map);
            tree.addCallMethod("WebCrawlerConfig/FBAs/FBA/Form/Param", "addParam", new String[]{"Name", null, "Encrypted"}, new Object[]{null, null, false});
            Parser parser = new Parser();
            parser.parse(is, tree, agent);
        }
        catch (FileNotFoundException ignored) {
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAuth(List<BasicAuthConfig> list, String dir) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(dir + File.separator + "httpauth.ini"));
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(",");
                if (args == null || args.length != 6) {
                    System.err.println("Invalid rule " + line);
                }
                BasicAuthConfig config = new BasicAuthConfig(args[0], args[2], args[3], false, args[5], args[1]);
                list.add(config);
            }
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProxy(AgentConfig agent, String dir) {
        InputStream is = null;
        try {
            is = new FileInputStream(dir + File.separator + "proxy.xml");
            ParseTree tree = new ParseTree();
            tree.addCallMethod(PROXY, "addProxy", new String[]{"Domain", "Server", "Port", "User", "Password", "Dummy1"}, new Object[]{null, null, null, null, null, true});
            Parser parser = new Parser();
            parser.parse(is, tree, agent);
        }
        catch (FileNotFoundException ignored) {
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void warning(SAXParseException arg0) throws SAXException {
        System.out.println(arg0);
    }

    @Override
    public void error(SAXParseException arg0) throws SAXException {
        System.out.println(arg0);
    }

    @Override
    public void fatalError(SAXParseException arg0) throws SAXException {
        System.out.println(arg0);
    }
}

