/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.util.XMLTagger;

public class SSLConfig
implements PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private CertificationType trustMode = CertificationType.SYSTEM;
    private String certPath;
    private String password;

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTrustMode() {
        return this.trustMode.name();
    }

    public void setTrustMode(String type) {
        this.trustMode = CertificationType.valueOf(type.toUpperCase());
    }

    public CertificationType getType() {
        return this.trustMode;
    }

    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("SSLCertification");
        tagger.writeAttr("TrustMode", this.trustMode.toString());
        if (this.certPath != null) {
            tagger.writeAttr("CertsPath", this.certPath);
            if (this.password != null) {
                tagger.writeAttr("Password", this.password);
            }
        }
        tagger.closeEndElementTag();
    }

    public long getHash(PublishableConfig.HashType type) {
        if (type == PublishableConfig.HashType.HTTPS) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.trustMode.toString());
            builder.append(":");
            if (this.certPath != null) {
                builder.append(this.certPath);
            }
            return new Hash64(builder.toString()).longValue();
        }
        return 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertificationType {
        SYSTEM,
        SELF,
        ALL;

    }
}

