/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.configuration;

import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.configuration.BucketConfig;
import com.ibm.es.nuvo.crawler.web.configuration.IntervalConfig;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.configuration.RobotConfig;
import com.ibm.es.nuvo.crawler.web.configuration.SSLConfig;
import com.ibm.es.nuvo.crawler.web.configuration.UpdatableConfiguration;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.util.TaggerUtil;
import com.ibm.es.nuvo.util.XMLTagger;

public class CrawlerConfig
implements UpdatableConfiguration,
PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static CrawlerConfig instance = new CrawlerConfig();
    private int soTimeout = 20;
    private int maxConnections = 10;
    private IntervalConfig dnsIntervalConfig = new IntervalConfig();
    private RobotConfig robotConfig = new RobotConfig();
    private BucketConfig bucketConfig = new BucketConfig();
    private SSLConfig sslConfig = new SSLConfig();

    public static CrawlerConfig getInstance() {
        return instance;
    }

    public static CrawlerConfig newInstance() {
        return new CrawlerConfig();
    }

    private CrawlerConfig() {
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(String maxConnections) {
        try {
            this.setMaxConnections(Integer.parseInt(maxConnections));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(String soTimeout) {
        try {
            this.setSoTimeout(Integer.parseInt(soTimeout));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public IntervalConfig getDnsIntervalConfig() {
        return this.dnsIntervalConfig;
    }

    public RobotConfig getRobotConfig() {
        return this.robotConfig;
    }

    public BucketConfig getBucketConfig() {
        return this.bucketConfig;
    }

    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    public void update() throws WCException {
    }

    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("WebCrawler");
        tagger.closeTag();
        this.sslConfig.toXML(tagger);
        this.bucketConfig.toXML(tagger);
        this.dnsIntervalConfig.toXML(tagger);
        this.robotConfig.toXML(tagger);
        TaggerUtil.addSimpleValue(tagger, "SoTimeout", "" + this.soTimeout);
        TaggerUtil.addSimpleValue(tagger, "NumberOfMaxConnections", "" + this.maxConnections);
        tagger.endElement("WebCrawler");
    }

    public long getHash(PublishableConfig.HashType type) {
        PublishableConfig[] confs = new PublishableConfig[]{this.robotConfig, this.bucketConfig, this.sslConfig};
        long ret = Hash64.xorHash(type, confs);
        return ret;
    }

    public static void setInstance(CrawlerConfig instance) {
        CrawlerConfig.instance = instance;
    }
}

