/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.config;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawler.util.hash.Hash64;
import com.ibm.es.nuvo.crawler.web.configuration.PublishableConfig;
import com.ibm.es.nuvo.crawler.web.error.ArgCheck;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.util.Base64;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTTPProxy
implements PublishableConfig {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + HTTPProxy.class.getName());
    public static final int S_AUTH_NONE = 0;
    public static final int S_AUTH_HTTPBASIC = 1;
    private String address;
    private String orgPort;
    private boolean valid = true;
    private String m_httpBasicCredential;
    private String m_domain;
    private InetSocketAddress m_socketAddress;
    private Pattern m_pattern;
    private int m_authType;
    private String user;
    private String password;
    private static final String s_agent = "HTTP Proxy";

    public HTTPProxy(String domain, String ipAddress, String portString, int authType, String id, String pw, boolean enc) throws WCException {
        ArgCheck.nonWSArg("HTTP Proxy domain name", domain);
        ArgCheck.nonWSArg("HTTP Proxy IP address", ipAddress);
        ArgCheck.nonWSArg("HTTP Proxy port number", portString);
        this.m_domain = domain.trim().toLowerCase();
        if (this.m_domain.indexOf(42) >= 0) {
            String pat = this.m_domain.replaceAll("\\.", "\\\\.");
            pat = pat.replaceAll("\\*", ".*");
            this.m_pattern = Pattern.compile(pat);
            if (tracer.isLoggable(Level.FINER)) {
                tracer.log(Level.FINER, "HPRX domain " + this.m_domain + " using RE " + pat);
            }
        }
        this.address = ipAddress;
        this.orgPort = portString;
        this.m_authType = authType;
        this.user = id;
        if (pw != null && enc) {
            try {
                this.password = Encryption.decrypt(pw);
            }
            catch (Exception e) {
                this.password = pw;
            }
        } else {
            this.password = pw;
        }
    }

    public void getAddress() {
        if (this.m_socketAddress == null && this.valid) {
            try {
                InetAddress ia = InetAddress.getByName(this.address);
                int port = Integer.parseInt(this.orgPort.trim());
                this.m_socketAddress = new InetSocketAddress(ia, port);
            }
            catch (NumberFormatException nfe) {
                tracer.log(Level.FINE, "" + this.orgPort, nfe);
                this.valid = false;
            }
            catch (UnknownHostException e) {
                tracer.log(Level.FINE, this.address, e);
                this.valid = false;
            }
        }
    }

    public String getHTTPBasicCredential() {
        if (this.m_authType != 1) {
            return null;
        }
        if (this.m_httpBasicCredential == null) {
            try {
                if (this.user.length() > 0 || this.password.length() > 0) {
                    this.m_httpBasicCredential = "Proxy-Authorization: Basic " + Base64.encode((this.user + ":" + this.password).getBytes("UTF-8"));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.m_httpBasicCredential;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public InetSocketAddress getSocketAddress() {
        this.getAddress();
        if (!this.valid) {
            return null;
        }
        return this.m_socketAddress;
    }

    public boolean matches(String dnsHostname) {
        if (dnsHostname == null) {
            return false;
        }
        if ((dnsHostname = dnsHostname.trim()).length() == 0) {
            return false;
        }
        dnsHostname = dnsHostname.toLowerCase();
        boolean matched = false;
        if (this.m_pattern == null) {
            matched = dnsHostname.equals(this.m_domain);
        } else {
            Matcher m = this.m_pattern.matcher(dnsHostname);
            matched = m.matches();
        }
        if (matched && tracer.isLoggable(Level.FINER)) {
            tracer.finer("HPRX " + this.m_domain + " matched " + dnsHostname);
        }
        return matched;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_domain);
        sb.append(":");
        sb.append(this.address);
        sb.append(":");
        sb.append(this.orgPort);
        return sb.toString();
    }

    public String getServer() {
        return this.address;
    }

    public String getPort() {
        return this.orgPort;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public void toXML(XMLTagger tagger) {
        tagger.openStartElement("Proxy");
        tagger.writeAttr("Domain", this.m_domain);
        tagger.writeAttr("Port", this.orgPort);
        tagger.writeAttr("Server", this.address);
        if (this.user != null && this.user.trim().length() > 0) {
            tagger.writeAttr("User", this.user);
            if (this.password != null && this.password.trim().length() > 0) {
                String pw;
                try {
                    pw = Encryption.encrypt(this.password);
                }
                catch (ExtendedException ignored) {
                    pw = this.password;
                }
                tagger.writeAttr("Password", pw);
            }
        }
        tagger.closeEndElementTag();
    }

    public long getHash(PublishableConfig.HashType type) {
        return new Hash64(this.address + this.orgPort + this.m_domain + this.user + this.password).longValue();
    }

    public boolean isValid() {
        return this.valid;
    }
}

