/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.config;

import com.ibm.es.nuvo.crawler.web.data.SimpleWildcardPattern;
import com.ibm.es.nuvo.crawler.web.error.ArgCheck;
import com.ibm.es.nuvo.crawler.web.error.InvalidHTTPMethodException;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.util.Encryption;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormBaseAuthenticator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static Logger tracer = ExtendedLogger.getLogger("NuvoTracer." + FormBaseAuthenticator.class.getName());
    public static final int METHOD_GET = 0;
    public static final int METHOD_POST = 1;
    protected int m_formMethodInt = -1;
    private SimpleWildcardPattern m_urlPattern;
    private String name;
    private String action;
    private String method;
    private ArrayList<FormDatum> m_formData;
    private String m_defID;

    public FormBaseAuthenticator(String urlPattern, String formName, String formAction, String formMethod, ArrayList<FormDatum> formData) throws WCException {
        ArgCheck.nonWSArg("URL pattern", urlPattern);
        ArgCheck.nonWSArg("FORM method", formMethod);
        ArgCheck.nonWSArg("FORM action", formAction);
        urlPattern = this._portPatch(urlPattern);
        this.m_urlPattern = new SimpleWildcardPattern(urlPattern);
        if (formName != null) {
            this.name = formName.trim();
        }
        this.action = formAction = formAction.trim();
        this.method = formMethod.trim();
        if (this.method.equalsIgnoreCase("GET")) {
            this.m_formMethodInt = 0;
        } else if (this.method.equalsIgnoreCase("POST")) {
            this.m_formMethodInt = 1;
        } else {
            throw new InvalidHTTPMethodException("FBA", this.method, "GET,POST");
        }
        this.m_formData = formData;
        this.m_defID = this._createDefID();
    }

    public String getAction() {
        if (this.m_formMethodInt == 1) {
            return this.action;
        }
        return this.action + "?" + this.getURLEncodedParams();
    }

    public CURL getFormActionURL(CURL resolveURL) {
        CURL url = null;
        if (this.m_formMethodInt == 1) {
            if (url == null) {
                url = new CURL(this.action);
            }
            if (url.isValid()) {
                return url;
            }
            String s = (this.action.charAt(0) != '/' ? "/" : "") + this.action;
            return new CURL(resolveURL, s);
        }
        if (url == null) {
            url = new CURL(this.action + "?" + this.getURLEncodedParams());
        }
        if (url.isValid()) {
            return url;
        }
        return new CURL(resolveURL, this.action + "?" + this.getURLEncodedParams());
    }

    public String getURLEncodedParams() {
        StringBuffer sb = new StringBuffer();
        if (this.m_formData == null) {
            return "";
        }
        for (FormDatum p : this.m_formData) {
            String paramName = p.getName();
            String value = p.getValue();
            if (p.isEncrypted()) {
                try {
                    value = Encryption.decrypt(p.getValue());
                }
                catch (Exception e) {
                    value = p.getValue();
                }
            }
            if (sb.length() > 0) {
                sb.append("&");
            }
            try {
                sb.append(URLEncoder.encode(paramName, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                sb.append(paramName);
            }
            sb.append("=");
            try {
                sb.append(URLEncoder.encode(value, "utf-8"));
            }
            catch (UnsupportedEncodingException e1) {
                sb.append(value);
            }
        }
        return sb.toString();
    }

    public int getFormMethodInt() {
        return this.m_formMethodInt;
    }

    public boolean matches(CURL url) {
        boolean matched = false;
        if (url != null) {
            matched = this.m_urlPattern.matches(url.toString());
        }
        if (matched && tracer.isLoggable(Level.FINER)) {
            tracer.log(Level.FINER, "FBA " + this.m_urlPattern + " matched " + url);
        }
        return matched;
    }

    public String toString() {
        int lim;
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_urlPattern).append(", ").append(this.name).append(", ").append(this.action).append(", ").append(this.method);
        int n = lim = this.m_formData == null ? 0 : this.m_formData.size();
        for (int j = 0; j < lim; ++j) {
            FormDatum p = this.m_formData.get(j);
            sb.append(", ").append(p.getName()).append("=").append(p.getValue());
            if (!p.isEncrypted()) continue;
            sb.append("(enc)");
        }
        return sb.toString();
    }

    private String _portPatch(String urlPattern) {
        int ssi = urlPattern.indexOf("//");
        if (ssi < 0) {
            return urlPattern;
        }
        int si = urlPattern.indexOf(47, ssi + 2);
        if (si < 0) {
            si = urlPattern.length();
        }
        if (urlPattern.charAt(si - 1) == '*') {
            return urlPattern;
        }
        String host = urlPattern.substring(ssi + 2, si);
        int ci = host.lastIndexOf(58);
        if (ci > 0) {
            int bi = host.lastIndexOf(93);
            if (bi > ci) {
                String s = urlPattern.substring(0, si) + ":*";
                if (si < urlPattern.length()) {
                    s = s + urlPattern.substring(si);
                }
                return s;
            }
            return urlPattern;
        }
        String s = urlPattern.substring(0, si) + ":*";
        if (si < urlPattern.length()) {
            s = s + urlPattern.substring(si);
        }
        return s;
    }

    public String getDefID() {
        return this.m_defID;
    }

    private String _createDefID() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(this.m_urlPattern);
        sb.append(",");
        sb.append(this.name);
        sb.append(",");
        sb.append(this.action);
        sb.append(",");
        sb.append(this.method);
        return new String(sb);
    }

    public static class FormDatum {
        private String name;
        private String value;
        private boolean encrypted;

        public FormDatum(String name, String value, boolean encrypted) {
            this.name = name;
            String v = value;
            if (encrypted) {
                try {
                    v = Encryption.decrypt(v);
                }
                catch (Exception e) {
                    v = value;
                }
            }
            this.value = v;
            this.encrypted = encrypted;
        }

        public FormDatum() {
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getName());
            builder.append("=");
            if (this.encrypted) {
                builder.append("(Encrypted)");
            }
            builder.append(this.getValue());
            return builder.toString();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setEncrypted(boolean encrypted) {
            this.encrypted = encrypted;
        }
    }
}

