/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.bucket;

import com.ibm.es.nuvo.crawler.web.net.CURL;
import com.ibm.es.nuvo.crawler.web.net.IPProto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class HostInfo {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private CURL curl;
    private String domain;
    private boolean crawled;

    public HostInfo(String hostname, int port, int protoNo) {
        this.curl = new CURL(IPProto.getProtocolName(protoNo) + "://" + hostname + ":" + port);
        StringBuilder builder = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(hostname, ".");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        ListIterator itr = list.listIterator(list.size());
        while (itr.hasPrevious()) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append((String)itr.previous());
        }
        this.domain = builder.toString();
    }

    public boolean isCrawled() {
        return this.crawled;
    }

    public void setCrawled(boolean crawled) {
        this.crawled = crawled;
    }

    public String getURL() {
        return this.curl.downstreamString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.crawled ? "ALLOWED  " : "FORBIDDEN");
        builder.append(";");
        builder.append(this.getURL());
        builder.append(";");
        builder.append(this.domain);
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HostComparator
    implements Comparator<HostInfo>,
    Serializable {
        private static final long serialVersionUID = 6233666416116307723L;

        HostComparator() {
        }

        @Override
        public int compare(HostInfo src, HostInfo dest) {
            if (src == dest || src.curl.toString().equals(dest.curl.toString())) {
                return 0;
            }
            if (src.domain == null || dest.domain == null) {
                return 0;
            }
            int rc = src.domain.compareTo(dest.domain);
            if (rc != 0) {
                return rc;
            }
            rc = src.curl.getProtocolNumber() - dest.curl.getProtocolNumber();
            if (rc != 0) {
                return rc;
            }
            rc = src.curl.getPort() - dest.curl.getPort();
            return rc;
        }
    }
}

