/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.web.bucket;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawler.CrawlerControl;
import com.ibm.es.nuvo.crawler.CrawlerMonitor;
import com.ibm.es.nuvo.crawler.web.Ant;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.crawler.web.admin.WCMonitor;
import com.ibm.es.nuvo.crawler.web.bucket.ActiveBucketInfo;
import com.ibm.es.nuvo.crawler.web.bucket.Bucket;
import com.ibm.es.nuvo.crawler.web.bucket.BucketManager;
import com.ibm.es.nuvo.crawler.web.bucket.BucketSelector;
import com.ibm.es.nuvo.crawler.web.configuration.CrawlerConfig;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigChangeListener;
import com.ibm.es.nuvo.crawler.web.configuration.notify.ConfigEventBroaker;
import com.ibm.es.nuvo.crawler.web.configuration.space.CrawlSpaceConfig;
import com.ibm.es.nuvo.crawler.web.db.CrawlRec;
import com.ibm.es.nuvo.crawler.web.db.URLInserter;
import com.ibm.es.nuvo.crawler.web.db.URLUpdater;
import com.ibm.es.nuvo.crawler.web.db.tables.AbstractTable;
import com.ibm.es.nuvo.crawler.web.db.tables.SystemTable;
import com.ibm.es.nuvo.crawler.web.db.tables.URLTable;
import com.ibm.es.nuvo.crawler.web.error.WCException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FederatedBucketManager
implements CrawlerControl,
ConfigChangeListener {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + FederatedBucketManager.class.getName());
    private static FederatedBucketManager instance = new FederatedBucketManager();
    private Map<String, BucketManager> managers = new HashMap<String, BucketManager>();
    private Map<String, BucketManager> dumpedManagers = new HashMap<String, BucketManager>();
    private List<CrawlRec> readyRecs = new ArrayList<CrawlRec>();
    private ReleaseTask releaseTask;
    private BucketSelector selector = new BucketSelector();
    private String startingManager;
    private RefillTask refillTask;

    public static FederatedBucketManager instance() {
        return instance;
    }

    private FederatedBucketManager() {
        ConfigEventBroaker.register(ConfigEventBroaker.GLOBAL, this);
    }

    public BucketManager getManager(String id) {
        return this.managers.get(id);
    }

    public boolean isActive(String id) {
        return id != null && (this.managers.containsKey(id) || id.equals(this.startingManager));
    }

    public boolean isAlive(String id) {
        return this.managers.containsKey(id) || this.dumpedManagers.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Bucket> getBucketsForDNSUpdate() {
        ArrayList<Bucket> list = new ArrayList<Bucket>();
        Map<String, BucketManager> map = this.managers;
        synchronized (map) {
            for (BucketManager manager : this.managers.values()) {
                list.addAll(manager.getBucketsForDNSUpdate());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Bucket> getBucketsForRobotsUpdate() {
        ArrayList<Bucket> list = new ArrayList<Bucket>();
        Map<String, BucketManager> map = this.managers;
        synchronized (map) {
            for (BucketManager manager : this.managers.values()) {
                list.addAll(manager.getBucketsForRobotsUpdate());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActiveBucketInfo> getActiveBucketInfo() {
        ArrayList<ActiveBucketInfo> list = new ArrayList<ActiveBucketInfo>();
        Map<String, BucketManager> map = this.managers;
        synchronized (map) {
            for (BucketManager manager : this.managers.values()) {
                list.addAll(manager.getActiveBucketInfo());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsMoreBucketsFilled() {
        int count = 0;
        Map<String, BucketManager> map = this.managers;
        synchronized (map) {
            for (BucketManager manager : this.managers.values()) {
                count += manager.countBucketsInState(Bucket.State.CRAWLING);
            }
        }
        int max = CrawlerConfig.getInstance().getBucketConfig().getMaxActive();
        return count < max;
    }

    public Bucket getEmptyBucket() {
        return this.selector.getEmptyBucket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawlRec getCrawlRec() throws InterruptedException {
        if (Ant.instance().isRunning()) {
            List<CrawlRec> list = this.readyRecs;
            synchronized (list) {
                if (this.readyRecs.size() == 0) {
                    this.readyRecs.wait(100L);
                }
                if (this.readyRecs.size() > 0) {
                    return this.readyRecs.remove(0);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startCrawl(String crawlSpace, Properties configurations) throws WCException {
        block18: {
            config = CrawlSpaceConfig.forName(crawlSpace);
            var4_4 = this.managers;
            synchronized (var4_4) {
                this.startingManager = crawlSpace;
                if (this.managers.containsKey(crawlSpace)) {
                    // MONITOREXIT @DISABLED, blocks:[0, 17, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.startingManager = null;
                    return;
                }
            }
            {
                if (FederatedBucketManager.tracer.isLoggable(Level.FINE)) {
                    FederatedBucketManager.tracer.log(Level.FINE, "C5019I.START_CRAWL_SPACE", new Object[]{crawlSpace});
                }
                var6_5 = this.dumpedManagers;
                synchronized (var6_5) {
                    manager = this.dumpedManagers.remove(crawlSpace);
                    if (manager != null) {
                        AbstractTable.close(crawlSpace, false);
                    }
                    ** if (manager != null) goto lbl30
                }
lbl-1000:
                // 1 sources

                {
                    if (config == null) {
                        // MONITOREXIT @DISABLED, blocks:[6, 13, 14] lbl23 : MonitorExitStatement: MONITOREXIT : var4_4
                        this.startingManager = null;
                        return;
                    }
                    ** try [egrp 4[TRYBLOCK] [8 : 136->265)] { 
lbl26:
                    // 1 sources

                    config.update();
                    manager = new BucketManager(config);
                    manager.startInsertStartURLs();
                    AbstractTable.close(crawlSpace, false);
                }
lbl30:
                // 2 sources

                if (config != null && config.isForceRecrawl()) {
                    manager.fullRecrawl();
                }
                this.managers.put(crawlSpace, manager);
                if (this.refillTask == null) {
                    this.refillTask = new RefillTask();
                    WebCrawler.schedule(this.refillTask, 0L, 100L);
                }
                if (this.releaseTask == null) {
                    this.releaseTask = new ReleaseTask();
                    WebCrawler.schedule(this.releaseTask, 0L, 1000L);
                }
                break block18;
lbl41:
                // 1 sources

                finally {
                    this.startingManager = null;
                }
            }
        }
        this.adjust();
        this.changeState(crawlSpace, CrawlerMonitor.CrawlerState.CRAWLING);
        WCMonitor.forName(crawlSpace).startMonitor();
    }

    private void changeState(String crawlSpace, CrawlerMonitor.CrawlerState state) {
        WCMonitor monitor = WCMonitor.forName(crawlSpace);
        if (monitor != null) {
            monitor.setState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCrawl(String crawlSpace) {
        boolean removed = false;
        Map<String, BucketManager> map = this.managers;
        synchronized (map) {
            BucketManager manager = this.managers.remove(crawlSpace);
            if (manager != null) {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "C5020I.STOP_CRAWL_SPACE", new Object[]{crawlSpace});
                }
                removed = true;
                manager.terminate();
                Object object = this.dumpedManagers;
                synchronized (object) {
                    this.dumpedManagers.put(crawlSpace, manager);
                }
                object = this.readyRecs;
                synchronized (object) {
                    ListIterator<CrawlRec> it = this.readyRecs.listIterator();
                    while (it.hasNext()) {
                        CrawlRec rec = it.next();
                        if (rec.getBucket().getManager() != manager) continue;
                        rec.deregister();
                        it.remove();
                    }
                }
            }
        }
        if (removed) {
            this.adjust();
        }
        this.changeState(crawlSpace, CrawlerMonitor.CrawlerState.INACTIVE);
    }

    @Override
    public void drop(String crawlSpace, Properties config) throws ExtendedException {
        if (this.isActive(crawlSpace)) {
            this.stopCrawl(crawlSpace);
        }
        int maxWait = 180;
        try {
            block12: {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.fine("Waiting for termination " + crawlSpace);
                }
                while (this.isAlive(crawlSpace) && maxWait-- > 0) {
                    if (tracer.isLoggable(Level.FINEST)) {
                        tracer.finest("Waiting " + this.managers + " " + this.dumpedManagers);
                    }
                    Thread.sleep(1000L);
                }
                try {
                    URLUpdater.instance().flush();
                }
                catch (Exception ignored) {
                    if (!tracer.isLoggable(Level.FINE)) break block12;
                    tracer.log(Level.FINE, "drop", ignored);
                }
            }
            try {
                URLInserter.instance().flush();
            }
            catch (Exception ignored) {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "drop", ignored);
                }
            }
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("Drop tables " + crawlSpace);
        }
        AbstractTable.drop(crawlSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjust() {
        Map<String, BucketManager> map = this.managers;
        synchronized (map) {
            this.selector.setManagers(this.managers.values());
        }
    }

    @Override
    public void pause(String collectionId, String crawlerId) {
        this.changeState(crawlerId, CrawlerMonitor.CrawlerState.PAUSED);
    }

    @Override
    public void resume(String collectionId, String crawlerId) {
        this.changeState(crawlerId, CrawlerMonitor.CrawlerState.CRAWLING);
    }

    @Override
    public void applyChange() throws WCException {
        this.adjust();
    }

    @Override
    public void startCrawl(String collectionId, String crawlerId, Properties properties) throws WCException {
        this.startCrawl(crawlerId, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<String, BucketManager> map = this.managers;
        synchronized (map) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(this.managers.keySet());
            for (String name : names) {
                this.stopCrawl(name);
            }
        }
        try {
            map = this.dumpedManagers;
            synchronized (map) {
                while (this.dumpedManagers.size() > 0) {
                    if (tracer.isLoggable(Level.FINER)) {
                        tracer.finer("Waiting for shutdown " + this.dumpedManagers.keySet());
                    }
                    this.dumpedManagers.wait(5000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.refillTask != null) {
            this.refillTask.cancel();
        }
        this.refillTask = null;
        if (this.releaseTask != null) {
            this.releaseTask.cancel();
        }
        this.releaseTask = null;
    }

    @Override
    public void applyConfig(String crawlSpace, Properties config) {
        try {
            this.applyChange();
        }
        catch (WCException e) {
            tracer.log(Level.FINE, "", e);
        }
    }

    @Override
    public void initializeDB(String crawlSpaceID, String dbPath) throws ExtendedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeSnapshot(StringBuilder builder) {
        builder.append("Waiting for release\n");
        builder.append(this.dumpedManagers.keySet());
        builder.append("\n");
        Map<String, BucketManager> map = this.managers;
        synchronized (map) {
            builder.append("Active indexes\n");
            builder.append(this.managers.keySet());
            builder.append("\n");
            for (Map.Entry<String, BucketManager> entry : this.managers.entrySet()) {
                builder.append("Detail host information for ");
                builder.append(entry.getKey());
                builder.append(" ");
                WCMonitor monitor = WCMonitor.forName(entry.getKey());
                if (monitor != null) {
                    builder.append((Object)monitor.getState());
                    builder.append("\n");
                    List<Integer> counts = monitor.getDocumentCount();
                    if (counts != null) {
                        for (int i = counts.size() - 1; i > 0; --i) {
                            counts.set(i, counts.get(i) - counts.get(i - 1));
                        }
                    }
                    builder.append("Crawled ");
                    builder.append(counts);
                }
                builder.append("\n");
                entry.getValue().snap(builder);
            }
        }
    }

    public void updatePublishedDocuments(String collectionId) {
        block2: {
            try {
                SystemTable.getInstance(collectionId).setFoeceUpdateScheduled(true);
            }
            catch (Exception e) {
                if (!tracer.isLoggable(Level.FINE)) break block2;
                tracer.log(Level.FINE, "updatePublishedDocuments " + collectionId, e);
            }
        }
    }

    public boolean isPublishedDocumentUpdated(String collectionId) {
        try {
            return !SystemTable.getInstance(collectionId).isFoeceUpdateScheduled() && URLTable.getInstance(collectionId).countRefreshDoc() == 0;
        }
        catch (Exception e) {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "isPublished " + collectionId, e);
            }
            return true;
        }
    }

    private class RefillTask
    extends TimerTask {
        private RefillTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List recs;
            List list = recs = FederatedBucketManager.this.readyRecs;
            synchronized (list) {
                if (recs.size() == 0) {
                    boolean taken = true;
                    while (taken) {
                        taken = false;
                        for (BucketManager manager : FederatedBucketManager.this.managers.values()) {
                            CrawlRec crawlRec = manager.getCrawlRec();
                            if (crawlRec == null) continue;
                            taken = true;
                            recs.add(crawlRec);
                        }
                    }
                    if (recs.size() > 0) {
                        recs.notifyAll();
                    }
                }
            }
        }
    }

    private class ReleaseTask
    extends TimerTask {
        private ReleaseTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = FederatedBucketManager.this.dumpedManagers;
            synchronized (map) {
                if (FederatedBucketManager.this.dumpedManagers.size() == 0) {
                    return;
                }
                ArrayList<String> keys = new ArrayList<String>();
                int maxWait = CrawlerConfig.getInstance().getSoTimeout() * 1000;
                for (String id : FederatedBucketManager.this.dumpedManagers.keySet()) {
                    BucketManager manager = (BucketManager)FederatedBucketManager.this.dumpedManagers.get(id);
                    boolean removeList = true;
                    if (manager.countBucketsInState(Bucket.State.CRAWLING) > 0) {
                        if (tracer.isLoggable(Level.FINER)) {
                            tracer.finer("Crawling " + manager.getConfig().getId());
                        }
                        manager.terminate();
                        removeList = false;
                    }
                    if (manager.countBucketsInState(Bucket.State.RECYCLE) > 0) {
                        if (tracer.isLoggable(Level.FINER)) {
                            tracer.finer("Recycling " + manager.getConfig().getId());
                        }
                        removeList = false;
                    }
                    if (removeList) {
                        WCMonitor.forName(id).stopMonitor();
                        keys.add(id);
                        ConfigEventBroaker.deredister(id);
                        continue;
                    }
                    if (System.currentTimeMillis() - manager.getTerminateTime() <= (long)maxWait) continue;
                    manager.forceStop();
                }
                for (String key : keys) {
                    if (tracer.isLoggable(Level.FINER)) {
                        tracer.finer("Removing " + key);
                    }
                    FederatedBucketManager.this.dumpedManagers.remove(key);
                    FederatedBucketManager.this.dumpedManagers.notifyAll();
                    AbstractTable.close(key, true);
                }
            }
        }
    }
}

